/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.fs.DBFFileSystemManager;
import org.jkiss.dbeaver.model.impl.app.DefaultValueEncryptor;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretSubject;
import org.jkiss.dbeaver.model.secret.DBSValueEncryptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class BaseProjectImpl
implements DBPProject,
DBSSecretSubject {
    private static final Log log = Log.getLog(BaseProjectImpl.class);
    public static final String SETTINGS_STORAGE_FILE = "project-settings.json";
    public static final String METADATA_STORAGE_FILE = "project-metadata.json";
    public static final String PROP_PROJECT_ID = "id";
    public static final Gson METADATA_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    private static final byte[] LOCAL_KEY_CACHE = new byte[]{-70, -69, 74, -97, 119, 74, -72, 83, -55, 108, 45, 101, 61, -2, 84, 74};
    @NotNull
    private final DBPWorkspace workspace;
    @NotNull
    private final SMSessionContext sessionContext;
    private volatile ProjectFormat format = ProjectFormat.UNKNOWN;
    private volatile DBPDataSourceRegistry dataSourceRegistry;
    private volatile DBFFileSystemManager fileSystemManager;
    private volatile Map<String, String> runtimeProperties = new ConcurrentHashMap<String, String>();
    private volatile Map<String, Object> properties;
    protected volatile Map<String, Map<String, Object>> resourceProperties;
    private UUID projectID;
    protected final Object metadataSync = new Object();
    protected final Object resourcesSync = new Object();
    private ProjectSyncJob metadataSyncJob;
    private boolean inMemory;

    public BaseProjectImpl(@NotNull DBPWorkspace workspace, @Nullable SMSessionContext sessionContext) {
        this.workspace = workspace;
        this.sessionContext = sessionContext == null ? workspace.getAuthContext() : sessionContext;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    @Override
    public boolean isInMemory() {
        return this.inMemory;
    }

    @Override
    @NotNull
    public String getId() {
        return this.getName();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    @NotNull
    public DBPWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    @NotNull
    public UUID getProjectID() {
        if (this.projectID == null) {
            if (this.isInMemory()) {
                this.projectID = UUID.randomUUID();
                return this.projectID;
            }
            String idStr = CommonUtils.toString((Object)this.getProjectProperty(PROP_PROJECT_ID), null);
            if (CommonUtils.isEmpty((String)idStr)) {
                this.projectID = UUID.randomUUID();
                this.setProjectProperty(PROP_PROJECT_ID, this.projectID.toString());
            } else {
                this.projectID = UUID.fromString(idStr);
            }
        }
        return this.projectID;
    }

    @Override
    @NotNull
    public Path getMetadataFolder(boolean create) {
        Path metadataFolder = this.getMetadataPath();
        if (create && !Files.exists(metadataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(metadataFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Error creating metadata folder" + String.valueOf(metadataFolder), e);
            }
        }
        return metadataFolder;
    }

    @NotNull
    protected Path getMetadataPath() {
        return this.getAbsolutePath().resolve(".dbeaver");
    }

    @Override
    public boolean isRegistryLoaded() {
        return this.dataSourceRegistry != null;
    }

    @Override
    public boolean isEncryptedProject() {
        return false;
    }

    @Override
    public boolean isPrivateProject() {
        return true;
    }

    @Override
    @NotNull
    public DBPDataSourceRegistry getDataSourceRegistry() {
        if (this.dataSourceRegistry == null) {
            Runnable registryOpener = () -> {
                if (this.dataSourceRegistry == null) {
                    Object object = this.metadataSync;
                    synchronized (object) {
                        this.ensureOpen();
                        if (this.dataSourceRegistry == null) {
                            this.dataSourceRegistry = this.createDataSourceRegistry();
                        }
                    }
                }
            };
            if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                registryOpener.run();
            } else {
                RuntimeUtils.runTask(monitor -> registryOpener.run(), "Load registry", 0L);
            }
        }
        return this.dataSourceRegistry;
    }

    @NotNull
    protected abstract DBPDataSourceRegistry createDataSourceRegistry();

    @Override
    @NotNull
    public DBSValueEncryptor getValueEncryptor() throws DBException {
        SecretKey key = this.getLocalSecretKey();
        if (key == null) {
            throw new IllegalStateException("Can't obtain secret key");
        }
        return new DefaultValueEncryptor(key);
    }

    @Nullable
    protected SecretKey getLocalSecretKey() {
        return new SecretKeySpec(LOCAL_KEY_CACHE, "AES");
    }

    @Override
    @NotNull
    public SMSessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DBFFileSystemManager getFileSystemManager() {
        if (this.fileSystemManager == null) {
            BaseProjectImpl baseProjectImpl = this;
            synchronized (baseProjectImpl) {
                if (this.fileSystemManager == null) {
                    this.fileSystemManager = new DBFFileSystemManager(this);
                }
            }
        }
        return this.fileSystemManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getProjectProperty(String propName) {
        BaseProjectImpl baseProjectImpl = this;
        synchronized (baseProjectImpl) {
            this.loadProperties();
            return this.properties.get(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProjectProperty(@NotNull String propName, @Nullable Object propValue) {
        Object object = this.metadataSync;
        synchronized (object) {
            this.loadProperties();
            if (propValue == null) {
                this.properties.remove(propName);
            } else {
                this.properties.put(propName, propValue);
            }
            this.saveProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        if (this.properties != null) {
            return;
        }
        if (this.isInMemory() || DBWorkbench.isDistributed()) {
            this.properties = new LinkedHashMap<String, Object>();
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            Path settingsFile = this.getMetadataPath().resolve(SETTINGS_STORAGE_FILE);
            if (this.fileExistsAndNonEmpty(settingsFile)) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader settingsReader = Files.newBufferedReader(settingsFile, StandardCharsets.UTF_8);){
                        this.properties = JSONUtils.parseMap(METADATA_GSON, settingsReader);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error("Error reading project '" + this.getName() + "' setting from " + String.valueOf(settingsFile.toAbsolutePath()), e);
                }
            }
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
        }
    }

    private void saveProperties() {
        if (this.isInMemory() || DBWorkbench.isDistributed()) {
            return;
        }
        Path settingsFile = this.getMetadataFolder(true).resolve(SETTINGS_STORAGE_FILE);
        String settingsString = METADATA_GSON.toJson(this.properties);
        try {
            Path configFolder = settingsFile.getParent();
            if (!Files.exists(configFolder, new LinkOption[0])) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            Files.writeString(settingsFile, (CharSequence)settingsString, new OpenOption[0]);
        }
        catch (Exception e) {
            log.error("Error writing project '" + this.getName() + "' setting to " + String.valueOf(settingsFile.toAbsolutePath()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String[] findResources(@NotNull Map<String, ?> properties) throws DBException {
        this.loadMetadata();
        Object object = this.resourcesSync;
        synchronized (object) {
            ArrayList<String> resources = new ArrayList<String>();
            for (Map.Entry<String, Map<String, Object>> resource : this.resourceProperties.entrySet()) {
                boolean containsRequiredProperties = true;
                Map<String, Object> props = resource.getValue();
                for (Map.Entry<String, ?> property : properties.entrySet()) {
                    String propName = property.getKey();
                    Object propValue = property.getValue();
                    if (props.containsKey(propName) && Objects.equals(props.get(propName), propValue)) continue;
                    containsRequiredProperties = false;
                    break;
                }
                if (!containsRequiredProperties) continue;
                resources.add(resource.getKey());
            }
            return (String[])resources.toArray(String[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getResourceProperty(@NotNull String resourcePath, @NotNull String propName) {
        this.loadMetadata();
        resourcePath = CommonUtils.normalizeResourcePath((String)resourcePath);
        Object object = this.resourcesSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resourcePath);
            if (resProps != null) {
                return resProps.get(propName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Map<String, Object> getResourceProperties(@NotNull String resourcePath) {
        this.loadMetadata();
        resourcePath = CommonUtils.normalizeResourcePath((String)resourcePath);
        Object object = this.resourcesSync;
        synchronized (object) {
            return this.resourceProperties.get(resourcePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResourceProperties(@NotNull String resourcePath, @NotNull Map<String, Object> newProps) {
        this.loadMetadata();
        resourcePath = CommonUtils.normalizeResourcePath((String)resourcePath);
        Object object = this.resourcesSync;
        synchronized (object) {
            this.resourceProperties.put(resourcePath, new LinkedHashMap<String, Object>(newProps));
        }
        this.flushMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setResourceProperty(@NotNull String resourcePath, @NotNull String propName, @Nullable Object propValue) {
        this.loadMetadata();
        resourcePath = CommonUtils.normalizeResourcePath((String)resourcePath);
        Object object = this.resourcesSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resourcePath);
            if (resProps == null) {
                if (propValue == null) {
                    return;
                }
                resProps = new LinkedHashMap<String, Object>();
                this.resourceProperties.put(resourcePath, resProps);
            }
            if (propValue == null) {
                if (resProps.remove(propName) == null) {
                    if (!resProps.isEmpty()) {
                        return;
                    }
                    this.resourceProperties.remove(resourcePath);
                }
            } else {
                Object oldValue = resProps.put(propName, propValue);
                if (Objects.equals(oldValue, propValue)) {
                    return;
                }
            }
        }
        this.flushMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveResourceProperties(@NotNull String oldResourcePath, @NotNull String newResourcePath) {
        this.loadMetadata();
        oldResourcePath = CommonUtils.normalizeResourcePath((String)oldResourcePath);
        newResourcePath = CommonUtils.normalizeResourcePath((String)newResourcePath);
        Object object = this.resourcesSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.remove(oldResourcePath);
            if (resProps != null) {
                this.resourceProperties.put(newResourcePath, resProps);
            }
        }
        this.flushMetadata();
    }

    @Override
    public void refreshProject(DBRProgressMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetResourceProperties(@NotNull String resourcePath) {
        boolean hadProperties;
        this.loadMetadata();
        resourcePath = CommonUtils.normalizeResourcePath((String)resourcePath);
        Object object = this.resourcesSync;
        synchronized (object) {
            hadProperties = this.resourceProperties.remove(resourcePath) != null;
        }
        if (hadProperties) {
            this.flushMetadata();
        }
        return hadProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResourceProperties(Map<String, Map<String, Object>> resourceProperties) {
        Object object = this.resourcesSync;
        synchronized (object) {
            this.resourceProperties = resourceProperties;
        }
    }

    @Override
    public boolean hasRealmPermission(@NotNull String permission) {
        return true;
    }

    @Override
    public boolean supportsRealmFeature(@NotNull String feature) {
        return true;
    }

    @Override
    public void dispose() {
        if (this.dataSourceRegistry != null) {
            this.dataSourceRegistry.dispose();
            this.dataSourceRegistry = null;
        }
        if (this.fileSystemManager != null) {
            this.fileSystemManager.close();
            this.fileSystemManager = null;
        }
    }

    public ProjectFormat getFormat() {
        return this.format;
    }

    protected void setFormat(ProjectFormat format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMetadata() {
        if (this.isInMemory()) {
            return;
        }
        this.ensureOpen();
        Object object = this.resourcesSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                return;
            }
            Path mdFile = this.getMetadataPath().resolve(METADATA_STORAGE_FILE);
            if (this.fileExistsAndNonEmpty(mdFile)) {
                TreeMap<String, Map<String, Object>> mdCache = new TreeMap<String, Map<String, Object>>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedReader mdReader = Files.newBufferedReader(mdFile, StandardCharsets.UTF_8);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (JsonReader jsonReader = METADATA_GSON.newJsonReader((Reader)mdReader);){
                            jsonReader.beginObject();
                            while (jsonReader.hasNext()) {
                                String topName = jsonReader.nextName();
                                if (!"resources".equals(topName)) continue;
                                jsonReader.beginObject();
                                while (jsonReader.hasNext()) {
                                    String resourceName = jsonReader.nextName();
                                    HashMap<String, Object> resProperties = new HashMap<String, Object>();
                                    jsonReader.beginObject();
                                    while (jsonReader.hasNext()) {
                                        String propName = jsonReader.nextName();
                                        Object propValue = switch (jsonReader.peek()) {
                                            case JsonToken.NUMBER -> jsonReader.nextDouble();
                                            case JsonToken.BOOLEAN -> jsonReader.nextBoolean();
                                            case JsonToken.NULL -> null;
                                            default -> jsonReader.nextString();
                                        };
                                        resProperties.put(propName, propValue);
                                    }
                                    jsonReader.endObject();
                                    if (resProperties.isEmpty()) continue;
                                    mdCache.put(resourceName, resProperties);
                                }
                                jsonReader.endObject();
                            }
                            jsonReader.endObject();
                            this.resourceProperties = mdCache;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error("Error reading project '" + this.getName() + "' metadata from " + String.valueOf(mdFile.toAbsolutePath()), e);
                }
            }
            if (this.resourceProperties == null) {
                this.resourceProperties = new TreeMap<String, Map<String, Object>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushMetadata() {
        if (this.inMemory) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.metadataSyncJob == null) {
                this.metadataSyncJob = new ProjectSyncJob();
            }
            if (DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                this.metadataSyncJob.run(new VoidProgressMonitor());
            } else {
                this.metadataSyncJob.schedule(100L);
            }
        }
    }

    @Override
    public String getRuntimeProperty(@NotNull String key) {
        return this.runtimeProperties.get(key);
    }

    @Override
    public void setRuntimeProperty(@NotNull String key, String value) {
        this.runtimeProperties.put(key, value);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @Nullable
    public DBNModel getNavigatorModel() {
        return null;
    }

    @Override
    public String getSecretSubjectId() {
        return "project/" + this.getId();
    }

    private boolean fileExistsAndNonEmpty(@NotNull Path path) {
        boolean fileNotEmpty = false;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Files.size(path) > 0L;
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        return fileNotEmpty;
    }

    public static enum ProjectFormat {
        UNKNOWN,
        LEGACY,
        MODERN;

    }

    private class ProjectSyncJob
    extends AbstractJob {
        ProjectSyncJob() {
            super("Project metadata sync");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected IStatus run(DBRProgressMonitor monitor) {
            this.setName("Project '" + BaseProjectImpl.this.getName() + "' sync job");
            ContentUtils.makeFileBackup(BaseProjectImpl.this.getMetadataFolder(false).resolve(BaseProjectImpl.METADATA_STORAGE_FILE));
            Object object = BaseProjectImpl.this.metadataSync;
            synchronized (object) {
                Path mdFile = BaseProjectImpl.this.getMetadataFolder(true).resolve(BaseProjectImpl.METADATA_STORAGE_FILE);
                if (CommonUtils.isEmpty(BaseProjectImpl.this.resourceProperties) && !Files.exists(mdFile, new LinkOption[0])) {
                    return Status.OK_STATUS;
                }
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try {
                        BufferedWriter mdWriter = Files.newBufferedWriter(mdFile, StandardCharsets.UTF_8, new OpenOption[0]);
                        try {
                            try (JsonWriter jsonWriter = METADATA_GSON.newJsonWriter((Writer)mdWriter);){
                                jsonWriter.beginObject();
                                jsonWriter.name("resources");
                                jsonWriter.beginObject();
                                for (Map.Entry<String, Map<String, Object>> resEntry : BaseProjectImpl.this.resourceProperties.entrySet()) {
                                    jsonWriter.name(resEntry.getKey());
                                    jsonWriter.beginObject();
                                    Map<String, Object> resProps = resEntry.getValue();
                                    for (Map.Entry<String, Object> propEntry : resProps.entrySet()) {
                                        jsonWriter.name(propEntry.getKey());
                                        Object value = propEntry.getValue();
                                        if (value == null) {
                                            jsonWriter.nullValue();
                                            continue;
                                        }
                                        if (value instanceof Number) {
                                            jsonWriter.value((Number)value);
                                            continue;
                                        }
                                        if (value instanceof Boolean) {
                                            jsonWriter.value((Boolean)value);
                                            continue;
                                        }
                                        jsonWriter.value(CommonUtils.toString((Object)value));
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                                jsonWriter.endObject();
                                jsonWriter.flush();
                            }
                            if (mdWriter == null) return Status.OK_STATUS;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (mdWriter == null) throw throwable;
                            ((Writer)mdWriter).close();
                            throw throwable;
                        }
                        ((Writer)mdWriter).close();
                        {
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.error("Error flushing project metadata", e);
                }
                return Status.OK_STATUS;
            }
        }
    }
}

