/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObjectLocalized;
import org.jkiss.dbeaver.model.DBPObjectWithDescriptionLocalized;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.osgi.framework.Bundle;

public abstract class LocalizedPropertyDescriptor
extends PropertyDescriptor
implements DBPNamedObjectLocalized,
DBPObjectWithDescriptionLocalized {
    private final transient Bundle bundle;

    public LocalizedPropertyDescriptor(String category, IConfigurationElement config) {
        super(category, config);
        this.bundle = this.getBundle(config);
    }

    @Override
    public String getLocalizedName(String locale) {
        try {
            return RuntimeUtils.getBundleLocalization(this.bundle, locale).getString(this.getPropertyId());
        }
        catch (Exception exception) {
            return this.getName();
        }
    }

    @Override
    @Nullable
    public String getLocalizedDescription(String locale) {
        try {
            return RuntimeUtils.getBundleLocalization(this.bundle, locale).getString(this.getPropertyId() + ".description");
        }
        catch (Exception exception) {
            return this.getDescription();
        }
    }

    public String getPropertyId() {
        return this.getId();
    }

    @NotNull
    private Bundle getBundle(@NotNull IConfigurationElement config) {
        String bundleName = config.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new IllegalStateException("Bundle '" + bundleName + "' not found");
        }
        return bundle;
    }
}

