/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.text.MessageFormat;
import org.eclipse.draw2d.AbstractConstraintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.internal.Logger;
import org.eclipse.draw2d.internal.Messages;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;

public class RulerLayout
extends AbstractConstraintLayout {
    private static final Logger LOGGER = Logger.getLogger(RulerLayout.class);

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return new Dimension(1, 1);
    }

    public Integer getConstraint(IFigure child) {
        return (Integer)this.constraints.get(child);
    }

    public void layout(IFigure container) {
        Rectangle rulerSize = container.getClientArea();
        for (IFigure child : container.getChildren()) {
            Dimension childSize = child.getPreferredSize();
            Integer childPos = this.getConstraint(child);
            if (childPos == null) continue;
            int position = childPos;
            if (((RulerFigure)container).isHorizontal()) {
                childSize.height = rulerSize.height - 1;
                Rectangle.SINGLETON.setLocation(position - childSize.width / 2, rulerSize.y);
            } else {
                childSize.width = rulerSize.width - 1;
                Rectangle.SINGLETON.setLocation(rulerSize.x, position - childSize.height / 2);
            }
            Rectangle.SINGLETON.setSize(childSize);
            child.setBounds(Rectangle.SINGLETON);
        }
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        if (newConstraint != null && !(newConstraint instanceof Integer)) {
            LOGGER.warn(MessageFormat.format(Messages.LayoutManager_InvalidConstraint, ((Object)((Object)this)).getClass().getSimpleName(), newConstraint.getClass().getSimpleName(), Integer.class.getSimpleName()));
        }
        super.setConstraint(figure, newConstraint);
    }
}

