/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.editor.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;
import org.jkiss.dbeaver.ui.editors.erd.part.ICustomizablePart;

public class SetPartColorAction
extends SelectionAction {
    private IStructuredSelection selection;

    public SetPartColorAction(ERDEditorPart part, IStructuredSelection selection) {
        super((IWorkbenchPart)part);
        this.selection = selection;
        this.setText(ERDUIMessages.erd_tool_color_action_text_set_color);
        this.setToolTipText(ERDUIMessages.erd_tool_color_action_tip_text_set_figure_color);
        this.setId("setFigureColor");
    }

    protected boolean calculateEnabled() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof ICustomizablePart) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void init() {
        super.init();
    }

    public void run() {
        this.execute(this.createColorCommand(this.selection.toArray()));
    }

    private Command createColorCommand(final Object[] objects) {
        return new Command(){
            private final Map<ICustomizablePart, Color> oldColors = new HashMap<ICustomizablePart, Color>();
            private Color newColor;

            public void execute() {
                Shell shell = UIUtils.createCenteredShell((Shell)SetPartColorAction.this.getWorkbenchPart().getSite().getShell());
                ColorDialog colorDialog = new ColorDialog(shell);
                RGB color = colorDialog.open();
                if (color == null) {
                    return;
                }
                this.newColor = new Color((Device)Display.getCurrent(), color);
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        ICustomizablePart colorizedPart = (ICustomizablePart)item;
                        this.oldColors.put(colorizedPart, colorizedPart.getCustomBackgroundColor());
                        colorizedPart.setCustomBackgroundColor(this.newColor);
                    }
                    ++n2;
                }
            }

            public void undo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        ICustomizablePart colorizedPart = (ICustomizablePart)item;
                        colorizedPart.setCustomBackgroundColor(this.oldColors.get(colorizedPart));
                    }
                    ++n2;
                }
            }

            public void redo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        ICustomizablePart colorizedPart = (ICustomizablePart)item;
                        colorizedPart.setCustomBackgroundColor(this.newColor);
                    }
                    ++n2;
                }
            }
        };
    }
}

