/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.imageview;

import java.io.InputStream;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.controls.imageview.SWTImageViewer;

public class SWTImageEditor
extends SWTImageViewer {
    private final Color redColor = Display.getCurrent().getSystemColor(3);
    private final Color blackColor = Display.getCurrent().getSystemColor(2);
    private final Text messageLabel;

    public SWTImageEditor(Composite parent, int style) {
        super(parent, style);
        Composite statusGroup = new Composite((Composite)this, 0);
        GridData gd = new GridData(768);
        statusGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        statusGroup.setLayout((Layout)layout);
        this.messageLabel = new Text(statusGroup, 8);
        this.messageLabel.setText("");
        gd = new GridData(768);
        this.messageLabel.setLayoutData((Object)gd);
        ToolBarManager toolBar = new ToolBarManager(0);
        this.fillToolBar((IContributionManager)toolBar);
        toolBar.createControl(statusGroup);
        this.updateActions();
    }

    @Override
    public boolean loadImage(@NotNull InputStream inputStream) {
        super.loadImage(inputStream);
        try {
            SWTException lastError = this.getLastError();
            if (lastError != null) {
                this.messageLabel.setText(lastError.getMessage());
                this.messageLabel.setForeground(this.redColor);
                return false;
            }
            this.messageLabel.setText(this.getImageDescription());
            this.messageLabel.setForeground(this.blackColor);
            return true;
        }
        finally {
            this.updateActions();
        }
    }
}

