/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class TrimBarLayout
extends Layout {
    private List<TrimLine> lines = new ArrayList<TrimLine>();
    public static final String SPACER = "stretch";
    public static final String GLUE = "glue";
    private final boolean horizontal;
    public int marginLeft = 0;
    public int marginRight = 0;
    public int marginTop = 0;
    public int marginBottom = 0;
    public int wrapSpacing = 0;

    public TrimBarLayout(boolean horizontal) {
        this.horizontal = horizontal;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Object bar;
        if (flushCache) {
            this.lines.clear();
        }
        if ((bar = composite.getData("modelElement")) instanceof MTrimBar) {
            ((MTrimBar)bar).getChildren().forEach(this::hideManagedTB);
        }
        int totalMajor = this.horizontal ? wHint - (this.marginLeft + this.marginRight) : hHint - (this.marginTop + this.marginBottom);
        int totalMinor = 0;
        int spaceLeft = totalMajor;
        TrimLine curLine = new TrimLine();
        Control[] kids = composite.getChildren();
        int i = 0;
        while (i < kids.length) {
            Control ctrl = kids[i];
            TrimLine segment = new TrimLine();
            segment.addControl(ctrl);
            while (i < kids.length - 2 && this.isGlue(kids[i + 1])) {
                segment.addControl(kids[i + 1]);
                segment.addControl(kids[i + 2]);
                i += 2;
            }
            if (segment.major <= spaceLeft) {
                curLine.mergeSegment(segment);
                spaceLeft -= segment.major;
            } else {
                curLine.extraSpace = spaceLeft;
                this.lines.add(curLine);
                totalMinor += curLine.minor;
                curLine = segment;
                spaceLeft = totalMajor - segment.major;
            }
            ++i;
        }
        if (curLine.ctrls.size() > 0) {
            curLine.extraSpace = spaceLeft;
            this.lines.add(curLine);
            totalMinor += curLine.minor;
        }
        int totalWrapSpacing = (this.lines.size() - 1) * this.wrapSpacing;
        return this.horizontal ? new Point(wHint, totalMinor) : new Point(totalMinor += this.horizontal ? this.marginTop + this.marginBottom + totalWrapSpacing : this.marginLeft + this.marginRight + totalWrapSpacing, hHint);
    }

    private Point computeSize(Control ctrl) {
        Point ctrlSize = ctrl.computeSize(-1, -1);
        if (this.isStatusLine(ctrl)) {
            ctrlSize.x = 375;
            ctrlSize.y = 26;
        }
        return ctrlSize;
    }

    private boolean hideManagedTB(MTrimElement te) {
        boolean barVisible;
        if (!(te instanceof MToolBar) || !(te.getRenderer() instanceof ToolBarManagerRenderer)) {
            return false;
        }
        if (!(te.getWidget() instanceof Composite)) {
            return false;
        }
        Composite teComp = (Composite)te.getWidget();
        Control[] kids = teComp.getChildren();
        if (kids.length != 1 || !(kids[0] instanceof ToolBar)) {
            return false;
        }
        boolean bl = barVisible = ((ToolBar)kids[0]).getItemCount() > 0;
        if (!te.getTags().contains("LockVisibility")) {
            te.setVisible(barVisible);
        }
        return !barVisible;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (flushCache) {
            this.lines.clear();
        }
        Rectangle bounds = composite.getBounds();
        bounds.x = this.marginLeft;
        bounds.y = this.marginTop;
        bounds.width -= this.marginLeft + this.marginRight;
        bounds.height -= this.marginTop + this.marginBottom;
        if (this.lines.isEmpty()) {
            if (this.horizontal) {
                this.computeSize(composite, bounds.width, -1, true);
            } else {
                this.computeSize(composite, -1, bounds.height, true);
            }
        }
        if (this.lines.isEmpty()) {
            return;
        }
        for (TrimLine curLine : this.lines) {
            this.tileLine(curLine, bounds);
            if (this.horizontal) {
                bounds.y += curLine.minor + this.wrapSpacing;
                continue;
            }
            bounds.x += curLine.minor + this.wrapSpacing;
        }
    }

    private void tileLine(TrimLine curLine, Rectangle bounds) {
        int curX = bounds.x;
        int curY = bounds.y;
        int remainingExtraSpace = curLine.extraSpace;
        int remainingSpacerCount = curLine.spacerCount;
        for (Control ctrl : curLine.ctrls) {
            int offset;
            boolean zeroSize;
            if (ctrl.isDisposed()) continue;
            Point ctrlSize = curLine.sizeMap.get(ctrl);
            int ctrlWidth = ctrlSize.x;
            int ctrlHeight = ctrlSize.y;
            boolean bl = zeroSize = ctrlWidth == 0 && ctrlHeight == 0;
            if (this.isSpacer(ctrl)) {
                int extra = remainingExtraSpace / remainingSpacerCount;
                if (this.horizontal) {
                    ctrl.setBounds(curX, curY, ctrlWidth += extra, curLine.minor - 4);
                } else {
                    ctrl.setBounds(curX, curY, curLine.minor, ctrlHeight += extra);
                }
                zeroSize = false;
                remainingExtraSpace -= extra;
                --remainingSpacerCount;
            }
            if (this.horizontal) {
                offset = (curLine.minor - ctrlHeight) / 2;
                if (!this.isSpacer(ctrl)) {
                    if (!zeroSize) {
                        ctrl.setBounds(curX, curY + offset, ctrlWidth, ctrlHeight);
                    } else {
                        ctrl.setBounds(curX, curY, 0, 0);
                    }
                }
                curX += ctrlWidth;
                continue;
            }
            offset = (curLine.minor - ctrlWidth) / 2;
            ctrl.setBounds(curX + offset, curY, ctrlWidth, ctrlHeight);
            curY += ctrlHeight;
        }
    }

    private boolean isSpacer(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getTags().contains(SPACER);
    }

    private boolean isGlue(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getTags().contains(GLUE);
    }

    private boolean isStatusLine(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getElementId() != null && element.getElementId().equals("org.eclipse.ui.StatusLine");
    }

    public Control ctrlFromPoint(Composite trimComp, Point trimPos) {
        Control[] kids;
        if (trimComp == null || trimComp.isDisposed() || this.lines == null || this.lines.isEmpty()) {
            return null;
        }
        Control[] controlArray = kids = trimComp.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            if (!kid.isDisposed() && kid.getBounds().contains(trimPos)) {
                return kid;
            }
            ++n2;
        }
        return null;
    }

    class TrimLine {
        Map<Control, Point> sizeMap = new HashMap<Control, Point>();
        List<Control> ctrls = new ArrayList<Control>();
        int spacerCount = 0;
        int extraSpace = 0;
        int major = 0;
        int minor = 0;

        TrimLine() {
        }

        public void addControl(Control ctrl) {
            Point ctrlSize = TrimBarLayout.this.computeSize(ctrl);
            int ctrlMajor = TrimBarLayout.this.horizontal ? ctrlSize.x : ctrlSize.y;
            int ctrlMinor = TrimBarLayout.this.horizontal ? ctrlSize.y : ctrlSize.x;
            this.major += ctrlMajor;
            if (ctrlMinor > this.minor) {
                this.minor = ctrlMinor;
            }
            this.sizeMap.put(ctrl, ctrlSize);
            this.ctrls.add(ctrl);
            if (TrimBarLayout.this.isSpacer(ctrl)) {
                ++this.spacerCount;
            }
        }

        public void mergeSegment(TrimLine segment) {
            this.sizeMap.putAll(segment.sizeMap);
            this.ctrls.addAll(segment.ctrls);
            this.major += segment.major;
            if (segment.minor > this.minor) {
                this.minor = segment.minor;
            }
            this.spacerCount += segment.spacerCount;
        }
    }
}

