/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardRendererType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.utils.ArrayUtils;

public class DashboardUIRegistry {
    private static final Log log = Log.getLog(DashboardUIRegistry.class);
    private static DashboardUIRegistry instance = null;
    private final Object syncRoot = new Object();
    private final List<DashboardRendererDescriptor> viewTypeList = new ArrayList<DashboardRendererDescriptor>();

    public static synchronized DashboardUIRegistry getInstance() {
        if (instance == null) {
            instance = new DashboardUIRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DashboardUIRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dashboard.ui");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("dashboardView".equals(ext.getName())) {
                this.viewTypeList.add(new DashboardRendererDescriptor(ext));
            }
            ++n2;
        }
    }

    public DashboardRendererDescriptor getViewType(String id) {
        for (DashboardRendererDescriptor descriptor : this.viewTypeList) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public List<DashboardRendererType> getAllViewTypes() {
        return new ArrayList<DashboardRendererType>(this.viewTypeList);
    }

    public List<DashboardRendererType> getSupportedViewTypes(DBDashboardDataType dataType) {
        ArrayList<DashboardRendererType> result = new ArrayList<DashboardRendererType>();
        for (DashboardRendererType dashboardRendererType : this.viewTypeList) {
            if (!ArrayUtils.contains((Object[])dashboardRendererType.getSupportedTypes(), (Object)dataType)) continue;
            result.add(dashboardRendererType);
        }
        return result;
    }
}

