/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.DataExporterArrayFormat;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.QuoteStrategy;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterCSV
extends StreamExporterAbstract
implements IAppendableDataExporter {
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_ROW_DELIMITER = "rowDelimiter";
    private static final String PROP_HEADER = "header";
    private static final String PROP_HEADER_FORMAT = "headerFormat";
    private static final String PROP_HEADER_CASE = "headerCase";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_QUOTE_ALWAYS = "quoteAlways";
    private static final String PROP_QUOTE_NEVER = "quoteNever";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_FORMAT_NUMBERS = "formatNumbers";
    private static final String PROP_LINE_FEED_ESCAPE_STRING = "lineFeedEscapeString";
    private static final String PROP_FORMAT_ARRAY = "formatArray";
    private static final Pattern LINE_BREAK_REGEX = Pattern.compile("\\r\\n|\\n");
    private static final String DEF_QUOTE_CHAR = "\"";
    private static final String DEFAULT_ARRAY_BRACKETS = "{ }";
    private boolean formatNumbers;
    private static final String ROW_DELIMITER_DEFAULT = "default";
    private String delimiter;
    private char quoteChar = (char)34;
    private boolean useQuotes = true;
    private QuoteStrategy quoteStrategy = QuoteStrategy.DISABLED;
    private String rowDelimiter;
    private String nullString;
    private HeaderPosition headerPosition;
    private HeaderFormat headerFormat;
    private DBPIdentifierCase headerCase;
    private String lineFeedEscapeString;
    private DBDAttributeBinding[] columns;
    private DataExporterArrayFormat dataExporterArrayFormat;
    private final StringBuilder buffer = new StringBuilder();

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        Object nullStringProp;
        String quoteStr;
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.delimiter = StreamTransferUtils.getDelimiterString(properties, PROP_DELIMITER);
        this.rowDelimiter = StreamTransferUtils.getDelimiterString(properties, PROP_ROW_DELIMITER);
        if (ROW_DELIMITER_DEFAULT.equalsIgnoreCase(this.rowDelimiter.trim())) {
            this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        }
        this.lineFeedEscapeString = CommonUtils.toString((Object)properties.get(PROP_LINE_FEED_ESCAPE_STRING), (String)"").replace("\\t", "\t").replace("\\n", "\n").replace("\\r", "\r");
        Object quoteProp = properties.get(PROP_QUOTE_CHAR);
        String string = quoteStr = quoteProp == null ? DEF_QUOTE_CHAR : quoteProp.toString();
        if (!CommonUtils.isEmpty((String)quoteStr)) {
            this.quoteChar = quoteStr.charAt(0);
        }
        if (CommonUtils.toBoolean((Object)properties.get(PROP_QUOTE_NEVER))) {
            this.quoteChar = (char)32;
        }
        this.nullString = (nullStringProp = properties.get(PROP_NULL_STRING)) == null ? null : nullStringProp.toString();
        this.useQuotes = this.quoteChar != ' ';
        this.quoteStrategy = QuoteStrategy.fromValue(CommonUtils.toString((Object)properties.get(PROP_QUOTE_ALWAYS)));
        if (this.headerPosition == null) {
            this.headerPosition = (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)properties.get(PROP_HEADER)), (Enum)HeaderPosition.top);
        }
        this.headerFormat = (HeaderFormat)CommonUtils.valueOf(HeaderFormat.class, (String)CommonUtils.toString((Object)properties.get(PROP_HEADER_FORMAT)), (Enum)HeaderFormat.label);
        this.formatNumbers = CommonUtils.toBoolean((Object)this.getSite().getProperties().get(PROP_FORMAT_NUMBERS));
        this.headerCase = switch (CommonUtils.toString((Object)properties.get(PROP_HEADER_CASE))) {
            case "as is" -> DBPIdentifierCase.MIXED;
            case "lower" -> DBPIdentifierCase.LOWER;
            default -> DBPIdentifierCase.UPPER;
        };
        String arrFormatProp = CommonUtils.toString((Object)properties.get(PROP_FORMAT_ARRAY), (String)DEFAULT_ARRAY_BRACKETS).trim();
        if (arrFormatProp.isEmpty()) {
            arrFormatProp = DEFAULT_ARRAY_BRACKETS;
        }
        this.dataExporterArrayFormat = DataExporterArrayFormat.getArrayFormat(arrFormatProp);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected DBDDisplayFormat getValueExportFormat(DBDAttributeBinding column) {
        if (column.getDataKind() == DBPDataKind.NUMERIC && !this.formatNumbers || column.getDataKind() == DBPDataKind.ARRAY) {
            return DBDDisplayFormat.NATIVE;
        }
        return super.getValueExportFormat(column);
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        if (this.headerPosition == HeaderPosition.top || this.headerPosition == HeaderPosition.both) {
            if (this.headerFormat != HeaderFormat.label) {
                DBSEntity srcEntity = (DBSEntity)DBUtils.getAdapter(DBSEntity.class, (Object)this.getSite().getSource());
                DBExecUtils.bindAttributes((DBCSession)session, (DBSEntity)srcEntity, null, (DBDAttributeBinding[])this.columns, null);
            }
            this.printHeader();
        }
    }

    private void printHeader() {
        int i = 0;
        int columnsSize = this.columns.length;
        while (i < columnsSize) {
            DBDAttributeBinding column = this.columns[i];
            Object colName = column.getName();
            if (this.headerFormat == HeaderFormat.description) {
                colName = column.getDescription();
                if (colName == null) {
                    colName = column.getLabel();
                }
            } else {
                String description;
                String colLabel = column.getLabel();
                if (CommonUtils.equalObjects((Object)colLabel, (Object)colName)) {
                    colName = column.getParentObject() == null ? column.getName() : DBUtils.getObjectFullName((DBPNamedObject)column, (DBPEvaluationContext)DBPEvaluationContext.UI);
                } else if (!CommonUtils.isEmpty((String)colLabel)) {
                    colName = colLabel;
                }
                if (this.headerFormat == HeaderFormat.both && !CommonUtils.isEmpty((String)(description = column.getDescription()))) {
                    colName = (String)colName + ":" + description;
                }
            }
            this.writeCellValue(this.headerCase.transform((String)colName), true);
            if (i < columnsSize - 1) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        int i = 0;
        while (i < row.length && i < this.columns.length) {
            DBDAttributeBinding column = this.columns[i];
            if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        this.writeCellValue("[NULL]", false);
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cs.getContentReader());
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    DTUtils.closeContents(resultSet, content);
                }
            } else {
                String stringValue = super.getValueDisplayString(column, row[i]);
                boolean quote = false;
                if (column.getDataKind() == DBPDataKind.ARRAY) {
                    stringValue = this.editArrayPrefixAndSuffix(this.dataExporterArrayFormat, stringValue);
                }
                if (this.quoteStrategy == QuoteStrategy.DISABLED) {
                    if (!stringValue.isEmpty() && !(row[i] instanceof Number) && !(row[i] instanceof Date) && Character.isDigit(stringValue.charAt(0))) {
                        quote = true;
                    }
                } else if (this.quoteStrategy == QuoteStrategy.STRINGS) {
                    if (!(stringValue.isEmpty() || row[i] instanceof Number || row[i] instanceof Date)) {
                        quote = true;
                    }
                } else if (this.quoteStrategy == QuoteStrategy.ALL_BUT_NUMBERS && !(row[i] instanceof Number)) {
                    quote = true;
                }
                if (DBUtils.isNullValue((Object)row[i])) {
                    if (CommonUtils.isNotEmpty((String)this.nullString)) {
                        this.writeCellValue(this.nullString, quote);
                    } else if (this.quoteStrategy == QuoteStrategy.ALL_INCLUDING_NULLS) {
                        this.writeCellValue("", true);
                    }
                } else {
                    this.writeCellValue(stringValue, quote);
                }
            }
            if (i < row.length - 1) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    /*
     * Unable to fully structure code
     */
    private String editArrayPrefixAndSuffix(DataExporterArrayFormat modifiedFormat, String stringValue) {
        if (stringValue == null || stringValue.isEmpty()) {
            return stringValue;
        }
        currentArrayFormat = DataExporterArrayFormat.getArrayFormatOnPrefix((stringValue = stringValue.trim()).charAt(0));
        if (currentArrayFormat.equals((Object)modifiedFormat)) {
            return stringValue;
        }
        insideQuotes = false;
        modifiedBuilder = new StringBuilder();
        var9_6 = stringValue.toCharArray();
        var8_7 = var9_6.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            c = var9_6[var7_8];
            if (c == '\"') {
                v0 = insideQuotes = insideQuotes == false;
            }
            if (insideQuotes) ** GOTO lbl-1000
            if (c == currentArrayFormat.getPrefix()) {
                modifiedBuilder.append(modifiedFormat.getPrefix());
            } else if (c == currentArrayFormat.getSuffix()) {
                modifiedBuilder.append(modifiedFormat.getSuffix());
            } else lbl-1000:
            // 2 sources

            {
                modifiedBuilder.append(c);
            }
            ++var7_8;
        }
        return modifiedBuilder.toString();
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        if (this.headerPosition == HeaderPosition.bottom || this.headerPosition == HeaderPosition.both) {
            this.printHeader();
        }
    }

    @Override
    public void importData(@NotNull IStreamDataExporterSite site) {
        Path file = site.getOutputFile();
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.headerPosition = HeaderPosition.none;
    }

    @Override
    public boolean shouldTruncateOutputFileBeforeExport() {
        return false;
    }

    private void writeCellValue(String value, boolean quote) {
        boolean hasQuotes;
        if (!this.useQuotes) {
            quote = false;
        }
        boolean bl = hasQuotes = this.useQuotes && value.indexOf(this.quoteChar) != -1;
        if (CommonUtils.isNotEmpty((String)this.lineFeedEscapeString) && value.indexOf(10) != -1) {
            value = LINE_BREAK_REGEX.matcher(value).replaceAll(this.lineFeedEscapeString);
        }
        if (this.quoteStrategy == QuoteStrategy.ALL || this.quoteStrategy == QuoteStrategy.ALL_INCLUDING_NULLS || this.useQuotes && value.isEmpty()) {
            quote = true;
        } else if (!quote && (hasQuotes || value.contains(this.delimiter) || value.indexOf(13) != -1 || value.indexOf(10) != -1 || value.contains(this.rowDelimiter))) {
            quote = true;
        }
        if (quote && hasQuotes) {
            this.buffer.setLength(0);
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == this.quoteChar) {
                    this.buffer.append(this.quoteChar);
                }
                this.buffer.append(c);
                ++i;
            }
            value = this.buffer.toString();
        }
        PrintWriter out = this.getWriter();
        if (quote && this.useQuotes) {
            out.write(this.quoteChar);
        }
        out.write(value);
        if (quote && this.useQuotes) {
            out.write(this.quoteChar);
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        try {
            int count;
            PrintWriter out = this.getWriter();
            if (this.useQuotes) {
                out.write(this.quoteChar);
            }
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                int i = 0;
                while (i < count) {
                    if (this.useQuotes && buffer[i] == this.quoteChar) {
                        out.write(this.quoteChar);
                    }
                    out.write(buffer[i]);
                    ++i;
                }
            }
            if (this.useQuotes) {
                out.write(this.quoteChar);
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private void writeDelimiter() {
        this.getWriter().write(this.delimiter);
    }

    private void writeRowLimit() {
        this.getWriter().write(this.rowDelimiter);
    }

    static enum HeaderFormat {
        label,
        description,
        both;

    }

    static enum HeaderPosition {
        none,
        top,
        bottom,
        both;

    }
}

