/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.preferences;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class AIPreferencePageMain
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(AIPreferencePageMain.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.ai";
    private final AISettings settings;
    private AIEngineDescriptor completionEngine;
    private Combo serviceCombo;
    private final Map<String, String> serviceNameMappings = new HashMap<String, String>();
    private final Map<String, EngineConfiguratorPage> engineConfiguratorMapping = new HashMap<String, EngineConfiguratorPage>();
    private EngineConfiguratorPage activeEngineConfiguratorPage;
    private Button enableAICheck;

    public AIPreferencePageMain() {
        this.settings = AISettingsManager.getInstance().getSettings();
        String activeEngine = this.settings.activeEngine();
        this.completionEngine = AIEngineRegistry.getInstance().getEngineDescriptor(activeEngine);
    }

    public IAdaptable getElement() {
        return this.settings;
    }

    public void setElement(IAdaptable element) {
    }

    @Nullable
    private IObjectPropertyConfigurator<AIEngineDescriptor, AIEngineProperties> createEngineConfigurator() {
        UIPropertyConfiguratorDescriptor engineDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.completionEngine.getEngineObjectType().getImplName());
        if (engineDescriptor != null) {
            try {
                return engineDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    protected void performDefaults() {
        if (!this.hasAccessToPage()) {
            return;
        }
        this.enableAICheck.setSelection(!this.settings.isAiDisabled());
    }

    public boolean performOk() {
        if (!this.hasAccessToPage()) {
            return false;
        }
        this.settings.setAiDisabled(!this.enableAICheck.getSelection());
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.settings.setActiveEngine(this.serviceNameMappings.get(this.serviceCombo.getText()));
        if (!this.serviceCombo.getText().isEmpty()) {
            for (Map.Entry<String, EngineConfiguratorPage> entry : this.engineConfiguratorMapping.entrySet()) {
                try {
                    AIEngineProperties engineConfiguration = this.settings.getEngineConfiguration(entry.getKey());
                    entry.getValue().saveSettings(engineConfiguration);
                }
                catch (DBException e) {
                    log.error((Object)"Error saving engine settings", (Throwable)e);
                    DBWorkbench.getPlatformUI().showError("Error saving AI settings", "Error saving engine settings for " + entry.getKey(), (Throwable)e);
                }
            }
        }
        AISettingsManager.getInstance().saveSettings(this.settings);
        try {
            store.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(final @NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        this.enableAICheck = UIUtils.createCheckbox((Composite)composite, (String)AIUIMessages.gpt_preference_page_checkbox_enable_ai_label, (String)AIUIMessages.gpt_preference_page_checkbox_enable_ai_tip, (boolean)false, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        Composite serviceComposite = UIUtils.createComposite((Composite)composite, (int)2);
        serviceComposite.setLayoutData((Object)new GridData(32));
        this.serviceCombo = UIUtils.createLabelCombo((Composite)serviceComposite, (String)"Engine", (int)12);
        List completionEngines = AIEngineRegistry.getInstance().getCompletionEngines();
        completionEngines.sort(Comparator.comparing(AIEngineDescriptor::getLabel));
        int defaultEngineSelection = -1;
        int i = 0;
        while (i < completionEngines.size()) {
            this.serviceCombo.add(((AIEngineDescriptor)completionEngines.get(i)).getLabel());
            this.serviceNameMappings.put(((AIEngineDescriptor)completionEngines.get(i)).getLabel(), ((AIEngineDescriptor)completionEngines.get(i)).getId());
            if (((AIEngineDescriptor)completionEngines.get(i)).isDefault()) {
                defaultEngineSelection = i;
            }
            if (((AIEngineDescriptor)completionEngines.get(i)).getId().equals(this.settings.activeEngine())) {
                this.serviceCombo.select(i);
            }
            ++i;
        }
        if (this.serviceCombo.getSelectionIndex() == -1 && defaultEngineSelection != -1) {
            this.serviceCombo.select(defaultEngineSelection);
        }
        final Group engineGroup = UIUtils.createControlGroup((Composite)composite, (String)"Engine Settings", (int)2, (int)2048, (int)5);
        engineGroup.setLayoutData((Object)new GridData(1808));
        if (this.completionEngine != null) {
            this.drawConfiguratorComposite(this.settings.activeEngine(), engineGroup);
        }
        this.serviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = AIPreferencePageMain.this.serviceNameMappings.get(AIPreferencePageMain.this.serviceCombo.getText());
                AIPreferencePageMain.this.completionEngine = AIEngineRegistry.getInstance().getEngineDescriptor(id);
                if (AIPreferencePageMain.this.activeEngineConfiguratorPage != null) {
                    AIPreferencePageMain.this.activeEngineConfiguratorPage.disposeControl();
                }
                AIPreferencePageMain.this.drawConfiguratorComposite(id, engineGroup);
                engineGroup.layout(true, true);
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        this.performDefaults();
        return composite;
    }

    private void drawConfiguratorComposite(@NotNull String id, @NotNull Group engineGroup) {
        this.activeEngineConfiguratorPage = this.engineConfiguratorMapping.get(id);
        if (this.activeEngineConfiguratorPage == null) {
            IObjectPropertyConfigurator<AIEngineDescriptor, AIEngineProperties> engineConfigurator = this.createEngineConfigurator();
            this.activeEngineConfiguratorPage = new EngineConfiguratorPage(engineConfigurator);
            this.activeEngineConfiguratorPage.createControl((Composite)engineGroup, this.completionEngine);
            this.engineConfiguratorMapping.put(id, this.activeEngineConfiguratorPage);
        } else {
            this.activeEngineConfiguratorPage.createControl((Composite)engineGroup, this.completionEngine);
        }
        try {
            this.activeEngineConfiguratorPage.loadSettings(this.settings.getEngineConfiguration(id));
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error loading AI settings", "Error loading engine settings for " + id, (Throwable)e);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected boolean hasAccessToPage() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
    }

    private static class EngineConfiguratorPage {
        private final IObjectPropertyConfigurator<AIEngineDescriptor, AIEngineProperties> configurator;
        private Composite composite;

        EngineConfiguratorPage(IObjectPropertyConfigurator<AIEngineDescriptor, AIEngineProperties> configurator) {
            this.configurator = configurator;
        }

        private void createControl(Composite parent, AIEngineDescriptor engine) {
            this.composite = UIUtils.createComposite((Composite)parent, (int)1);
            this.composite.setLayoutData((Object)new GridData(768));
            if (this.configurator != null) {
                this.configurator.createControl(this.composite, (Object)engine, () -> {});
            }
        }

        private void disposeControl() {
            this.composite.dispose();
        }

        private void loadSettings(AIEngineProperties settings) {
            if (this.configurator != null) {
                this.configurator.loadSettings((Object)settings);
            }
        }

        private void saveSettings(AIEngineProperties settings) {
            if (this.configurator != null) {
                this.configurator.saveSettings((Object)settings);
            }
        }
    }
}

