/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Util {
    public static String getSymbolicName(Resource resource) {
        List<Capability> caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return cap.getAttributes().get("osgi.identity").toString();
        }
        return null;
    }

    public static Version getVersion(Resource resource) {
        List<Capability> caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return (Version)cap.getAttributes().get("version");
        }
        return null;
    }

    public static boolean isFragment(Resource resource) {
        List<Capability> caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            String type = (String)cap.getAttributes().get("type");
            return type != null && type.equals("osgi.fragment");
        }
        return false;
    }

    public static boolean isOptional(Requirement req) {
        String resolution = req.getDirectives().get("resolution");
        return "optional".equalsIgnoreCase(resolution);
    }

    public static boolean isMultiple(Requirement req) {
        return "multiple".equals(req.getDirectives().get("cardinality")) && !Util.isDynamic(req);
    }

    public static boolean isDynamic(Requirement req) {
        return "dynamic".equals(req.getDirectives().get("resolution"));
    }

    public static boolean isReexport(Requirement req) {
        return "reexport".equals(req.getDirectives().get("visibility"));
    }

    public static String getPackageName(Capability capability) {
        Object object;
        if (capability != null && "osgi.wiring.package".equals(capability.getNamespace()) && (object = capability.getAttributes().get("osgi.wiring.package")) instanceof String) {
            return (String)object;
        }
        return "";
    }

    public static Set<String> getUses(Capability capability) {
        String uses;
        if (capability != null && "osgi.wiring.package".equals(capability.getNamespace()) && (uses = capability.getDirectives().get("uses")) != null && !uses.isEmpty()) {
            return Arrays.stream(uses.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

