/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IScalablePane;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ScalableLayeredPane
extends LayeredPane
implements IScalablePane {
    private double scale = 1.0;
    private final boolean useScaledGraphics;

    public ScalableLayeredPane() {
        this(true);
    }

    public ScalableLayeredPane(boolean useScaledGraphics) {
        this.useScaledGraphics = useScaledGraphics;
    }

    @Override
    public Rectangle getClientArea(Rectangle rect) {
        return this.getScaledRect(super.getClientArea(rect));
    }

    @Override
    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension d = super.getMinimumSize(wHint != -1 ? (int)((double)wHint / this.getScale()) : -1, hHint != -1 ? (int)((double)hHint / this.getScale()) : -1);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint != -1 ? (int)((double)wHint / this.getScale()) : -1, hHint != -1 ? (int)((double)hHint / this.getScale()) : -1);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0) {
            super.paintClientArea(graphics);
        } else {
            Graphics graphicsToUse = IScalablePane.IScalablePaneHelper.prepareScaledGraphics(graphics, this);
            this.paintChildren(graphicsToUse);
            IScalablePane.IScalablePaneHelper.cleanupScaledGraphics(graphics, graphicsToUse);
        }
    }

    @Override
    public boolean optimizeClip() {
        return super.optimizeClip();
    }

    @Override
    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.fireMoved();
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean useScaledGraphics() {
        return this.useScaledGraphics;
    }

    @Override
    public void translateToParent(Translatable t) {
        t.performScale(this.getScale());
    }

    @Override
    public void translateFromParent(Translatable t) {
        t.performScale(1.0 / this.getScale());
    }

    @Override
    public boolean isCoordinateSystem() {
        return true;
    }
}

