/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.project;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizard;

public class EditProjectWizard
extends ActiveWizard {
    private static final Log log = Log.getLog(EditProjectWizard.class);
    private final RCPProject project;

    public EditProjectWizard(RCPProject project) {
        this.project = project;
    }

    public String getWindowTitle() {
        return "Project " + this.project.getName() + " settings";
    }

    public Image getDefaultPageImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT);
    }

    public void addPages() {
        IPreferenceNode[] preferenceNodes = PreferencesUtil.propertiesContributorsFor((Object)this.project.getEclipseProject());
        this.createPreferencePages(preferenceNodes);
    }

    protected IAdaptable getActiveElement() {
        return this.project.getEclipseProject();
    }

    public boolean performFinish() {
        super.savePrefPageSettings();
        this.project.getDataSourceRegistry().flushConfig();
        return true;
    }
}

