/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetImpl;

public class OracleRefCursor
implements DBDCursor {
    private static final Log log = Log.getLog(OracleRefCursor.class);
    private final JDBCSession session;
    private final JDBCStatement sourceStatement;
    private final Object cursorValue;

    public OracleRefCursor(JDBCSession session, JDBCStatement sourceStatement, @Nullable Object cursorValue) throws SQLException {
        this.session = session;
        this.sourceStatement = sourceStatement;
        this.cursorValue = cursorValue;
    }

    public Object getRawValue() {
        return this.cursorValue;
    }

    public boolean isNull() {
        return this.cursorValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        if (this.cursorValue instanceof ResultSet) {
            try {
                ((ResultSet)this.cursorValue).close();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
    }

    @NotNull
    public DBCResultSet openResultSet(@NotNull DBCSession session) throws DBCException {
        if (this.cursorValue instanceof ResultSet) {
            try {
                return JDBCResultSetImpl.makeResultSet((JDBCSession)((JDBCSession)session), (JDBCStatement)this.sourceStatement, (ResultSet)((ResultSet)this.cursorValue), (boolean)false);
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
        }
        throw new DBCException("Unsupported cursor value: " + String.valueOf(this.cursorValue));
    }

    @Nullable
    public String getCursorName() {
        if (this.cursorValue instanceof ResultSet) {
            try {
                return ((ResultSet)this.cursorValue).getCursorName();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public String toString() {
        return this.cursorValue == null ? "[NULL]" : "REFCURSOR";
    }
}

