/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DuckDataTypeCache
extends JDBCBasicDataTypeCache<GenericStructContainer, GenericDataType> {
    public DuckDataTypeCache(@NotNull GenericStructContainer container) {
        super((DBSObject)container);
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        return session.prepareStatement("select distinct(type_name), type_name, type_category from duckdb_types() where schema_name = 'main'");
    }

    protected GenericDataType fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type_name");
        int kind = DuckDataTypeCache.getTypeKind(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type_category"));
        return new GenericDataType(container, kind, name, null, false, false, -1, -1, -1);
    }

    private static int getTypeKind(@Nullable String category) {
        if (category == null) {
            return 1111;
        }
        switch (category.toLowerCase(Locale.ROOT)) {
            case "bool": 
            case "boolean": 
            case "logical": {
                return 16;
            }
            case "composite": 
            case "box_2d": 
            case "polygon_2d": 
            case "linestring_2d": 
            case "point_2d": 
            case "point_3d": 
            case "point_4d": {
                return 2002;
            }
            case "binary": 
            case "varbinary": 
            case "blob": 
            case "bytea": 
            case "wkb_blob": {
                return -2;
            }
            case "date": {
                return 91;
            }
            case "timestamp_us": 
            case "datetime": {
                return 93;
            }
            case "timestamptz": {
                return 2014;
            }
            case "time": {
                return 92;
            }
            case "timetz": {
                return 2013;
            }
            case "numeric": {
                return 2;
            }
            case "bpchar": 
            case "nvarchar": 
            case "string": 
            case "text": 
            case "varchar": {
                return 12;
            }
        }
        return 1111;
    }
}

