/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class ValuePropertyDetailValue<S, M, T>
extends ValueProperty<S, T>
implements IValueProperty<S, T> {
    private IValueProperty<S, M> masterProperty;
    private IValueProperty<? super M, T> detailProperty;

    public ValuePropertyDetailValue(IValueProperty<S, M> masterProperty, IValueProperty<? super M, T> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    @Override
    protected T doGetValue(S source) {
        M masterValue = this.masterProperty.getValue(source);
        return this.detailProperty.getValue(masterValue);
    }

    @Override
    protected void doSetValue(S source, T value) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.setValue(masterValue, value);
    }

    @Override
    public IObservableValue<T> observe(Realm realm, S source) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterValue = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableValue<T> detailValue = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailValue, masterValue);
        return detailValue;
    }

    @Override
    public <V extends S> IObservableValue<T> observeDetail(IObservableValue<V> master) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterValue = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableValue<T> detailValue = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailValue, masterValue);
        return detailValue;
    }

    @Override
    public <V extends S> IObservableList<T> observeDetail(IObservableList<V> master) {
        IObservableList<M> masterList;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterList = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableList<T> detailList = this.detailProperty.observeDetail(masterList);
        PropertyObservableUtil.cascadeDispose(detailList, masterList);
        return detailList;
    }

    @Override
    public <V extends S> IObservableMap<V, T> observeDetail(IObservableSet<V> master) {
        IObservableMap<V, M> masterMap;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterMap = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap<V, T> detailMap = this.detailProperty.observeDetail(masterMap);
        PropertyObservableUtil.cascadeDispose(detailMap, masterMap);
        return detailMap;
    }

    @Override
    public <K, V extends S> IObservableMap<K, T> observeDetail(IObservableMap<K, V> master) {
        IObservableMap<K, M> masterMap;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterMap = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap<K, T> detailMap = this.detailProperty.observeDetail(masterMap);
        PropertyObservableUtil.cascadeDispose(detailMap, masterMap);
        return detailMap;
    }

    public String toString() {
        return String.valueOf(this.masterProperty) + " => " + String.valueOf(this.detailProperty);
    }
}

