/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.settings;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class GlobalSettings {
    private static final String DBEAVER_CONFIG_FOLDER = "settings";
    private static final String DBEAVER_CONFIG_FILE = "global-settings.ini";
    private static final String DBEAVER_PROP_LANGUAGE = "nl";
    private static final Log log = Log.getLog(GlobalSettings.class);
    private static GlobalSettings instance;
    private Properties properties;

    public static synchronized GlobalSettings getInstance() {
        if (instance == null) {
            instance = new GlobalSettings();
        }
        return instance;
    }

    public synchronized String getGlobalProperty(@NotNull String key) {
        this.loadProperties();
        return this.properties.getProperty(key);
    }

    public synchronized void setGlobalProperty(@NotNull String key, @Nullable String value) {
        this.loadProperties();
        if (value != null) {
            this.properties.setProperty(key, value);
        } else {
            this.properties.remove(key);
        }
        this.saveProperties();
    }

    private void loadProperties() {
        block12: {
            if (this.properties != null) {
                return;
            }
            this.properties = new Properties();
            Path file = GlobalSettings.getPropertiesFile();
            try {
                if (!Files.exists(file, new LinkOption[0])) break block12;
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    this.properties.load(reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error loading global properties", (Throwable)e);
            }
        }
    }

    @NotNull
    private static Path getPropertiesFile() {
        Path root = Path.of(RuntimeUtils.getWorkingDirectory((String)"DBeaverData"), new String[0]);
        return root.resolve(DBEAVER_CONFIG_FOLDER).resolve(DBEAVER_CONFIG_FILE);
    }

    private void saveProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        try {
            Path file = GlobalSettings.getPropertiesFile();
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                this.properties.store(writer, "DBeaver configuration");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error saving global properties", (Throwable)e);
        }
    }
}

