package dagpb

// Code generated by go-ipld-prime gengo.  DO NOT EDIT.

import (
	ipld "github.com/ipld/go-ipld-prime"
	"github.com/ipld/go-ipld-prime/node/mixins"
	"github.com/ipld/go-ipld-prime/schema"
)

func (n Bytes) Bytes() []byte {
	return n.x
}
func (_Bytes__Prototype) FromBytes(v []byte) (Bytes, error) {
	n := _Bytes{v}
	return &n, nil
}

type _Bytes__Maybe struct {
	m schema.Maybe
	v _Bytes
}
type MaybeBytes = *_Bytes__Maybe

func (m MaybeBytes) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBytes) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBytes) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBytes) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBytes) Must() Bytes {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Bytes)(&_Bytes{})
var _ schema.TypedNode = (Bytes)(&_Bytes{})

func (Bytes) Kind() ipld.Kind {
	return ipld.Kind_Bytes
}
func (Bytes) LookupByString(string) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.LookupByString("")
}
func (Bytes) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.LookupByNode(nil)
}
func (Bytes) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.LookupByIndex(0)
}
func (Bytes) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.LookupBySegment(seg)
}
func (Bytes) MapIterator() ipld.MapIterator {
	return nil
}
func (Bytes) ListIterator() ipld.ListIterator {
	return nil
}
func (Bytes) Length() int64 {
	return -1
}
func (Bytes) IsAbsent() bool {
	return false
}
func (Bytes) IsNull() bool {
	return false
}
func (Bytes) AsBool() (bool, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.AsBool()
}
func (Bytes) AsInt() (int64, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.AsInt()
}
func (Bytes) AsFloat() (float64, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.AsFloat()
}
func (Bytes) AsString() (string, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.AsString()
}
func (n Bytes) AsBytes() ([]byte, error) {
	return n.x, nil
}
func (Bytes) AsLink() (ipld.Link, error) {
	return mixins.Bytes{TypeName: "dagpb.Bytes"}.AsLink()
}
func (Bytes) Prototype() ipld.NodePrototype {
	return _Bytes__Prototype{}
}

type _Bytes__Prototype struct{}

func (_Bytes__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Bytes__Builder
	nb.Reset()
	return &nb
}

type _Bytes__Builder struct {
	_Bytes__Assembler
}

func (nb *_Bytes__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Bytes__Builder) Reset() {
	var w _Bytes
	var m schema.Maybe
	*nb = _Bytes__Builder{_Bytes__Assembler{w: &w, m: &m}}
}

type _Bytes__Assembler struct {
	w *_Bytes
	m *schema.Maybe
}

func (na *_Bytes__Assembler) reset() {}
func (_Bytes__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.BeginMap(0)
}
func (_Bytes__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.BeginList(0)
}
func (na *_Bytes__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Bytes__Assembler) AssignBool(bool) error {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.AssignBool(false)
}
func (_Bytes__Assembler) AssignInt(int64) error {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.AssignInt(0)
}
func (_Bytes__Assembler) AssignFloat(float64) error {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.AssignFloat(0)
}
func (_Bytes__Assembler) AssignString(string) error {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.AssignString("")
}
func (na *_Bytes__Assembler) AssignBytes(v []byte) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Bytes__Assembler) AssignLink(ipld.Link) error {
	return mixins.BytesAssembler{TypeName: "dagpb.Bytes"}.AssignLink(nil)
}
func (na *_Bytes__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Bytes); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsBytes(); err != nil {
		return err
	} else {
		return na.AssignBytes(v2)
	}
}
func (_Bytes__Assembler) Prototype() ipld.NodePrototype {
	return _Bytes__Prototype{}
}
func (Bytes) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Bytes) Representation() ipld.Node {
	return (*_Bytes__Repr)(n)
}

type _Bytes__Repr = _Bytes

var _ ipld.Node = &_Bytes__Repr{}

type _Bytes__ReprPrototype = _Bytes__Prototype
type _Bytes__ReprAssembler = _Bytes__Assembler

func (n Int) Int() int64 {
	return n.x
}
func (_Int__Prototype) FromInt(v int64) (Int, error) {
	n := _Int{v}
	return &n, nil
}

type _Int__Maybe struct {
	m schema.Maybe
	v _Int
}
type MaybeInt = *_Int__Maybe

func (m MaybeInt) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeInt) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeInt) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeInt) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeInt) Must() Int {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Int)(&_Int{})
var _ schema.TypedNode = (Int)(&_Int{})

func (Int) Kind() ipld.Kind {
	return ipld.Kind_Int
}
func (Int) LookupByString(string) (ipld.Node, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.LookupByString("")
}
func (Int) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.LookupByNode(nil)
}
func (Int) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.LookupByIndex(0)
}
func (Int) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.LookupBySegment(seg)
}
func (Int) MapIterator() ipld.MapIterator {
	return nil
}
func (Int) ListIterator() ipld.ListIterator {
	return nil
}
func (Int) Length() int64 {
	return -1
}
func (Int) IsAbsent() bool {
	return false
}
func (Int) IsNull() bool {
	return false
}
func (Int) AsBool() (bool, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.AsBool()
}
func (n Int) AsInt() (int64, error) {
	return n.x, nil
}
func (Int) AsFloat() (float64, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.AsFloat()
}
func (Int) AsString() (string, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.AsString()
}
func (Int) AsBytes() ([]byte, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.AsBytes()
}
func (Int) AsLink() (ipld.Link, error) {
	return mixins.Int{TypeName: "dagpb.Int"}.AsLink()
}
func (Int) Prototype() ipld.NodePrototype {
	return _Int__Prototype{}
}

type _Int__Prototype struct{}

func (_Int__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Int__Builder
	nb.Reset()
	return &nb
}

type _Int__Builder struct {
	_Int__Assembler
}

func (nb *_Int__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Int__Builder) Reset() {
	var w _Int
	var m schema.Maybe
	*nb = _Int__Builder{_Int__Assembler{w: &w, m: &m}}
}

type _Int__Assembler struct {
	w *_Int
	m *schema.Maybe
}

func (na *_Int__Assembler) reset() {}
func (_Int__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.BeginMap(0)
}
func (_Int__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.BeginList(0)
}
func (na *_Int__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.IntAssembler{TypeName: "dagpb.Int"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Int__Assembler) AssignBool(bool) error {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.AssignBool(false)
}
func (na *_Int__Assembler) AssignInt(v int64) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Int__Assembler) AssignFloat(float64) error {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.AssignFloat(0)
}
func (_Int__Assembler) AssignString(string) error {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.AssignString("")
}
func (_Int__Assembler) AssignBytes([]byte) error {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.AssignBytes(nil)
}
func (_Int__Assembler) AssignLink(ipld.Link) error {
	return mixins.IntAssembler{TypeName: "dagpb.Int"}.AssignLink(nil)
}
func (na *_Int__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Int); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsInt(); err != nil {
		return err
	} else {
		return na.AssignInt(v2)
	}
}
func (_Int__Assembler) Prototype() ipld.NodePrototype {
	return _Int__Prototype{}
}
func (Int) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Int) Representation() ipld.Node {
	return (*_Int__Repr)(n)
}

type _Int__Repr = _Int

var _ ipld.Node = &_Int__Repr{}

type _Int__ReprPrototype = _Int__Prototype
type _Int__ReprAssembler = _Int__Assembler

func (n Link) Link() ipld.Link {
	return n.x
}
func (_Link__Prototype) FromLink(v ipld.Link) (Link, error) {
	n := _Link{v}
	return &n, nil
}

type _Link__Maybe struct {
	m schema.Maybe
	v _Link
}
type MaybeLink = *_Link__Maybe

func (m MaybeLink) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeLink) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeLink) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeLink) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeLink) Must() Link {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Link)(&_Link{})
var _ schema.TypedNode = (Link)(&_Link{})

func (Link) Kind() ipld.Kind {
	return ipld.Kind_Link
}
func (Link) LookupByString(string) (ipld.Node, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.LookupByString("")
}
func (Link) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.LookupByNode(nil)
}
func (Link) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.LookupByIndex(0)
}
func (Link) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.LookupBySegment(seg)
}
func (Link) MapIterator() ipld.MapIterator {
	return nil
}
func (Link) ListIterator() ipld.ListIterator {
	return nil
}
func (Link) Length() int64 {
	return -1
}
func (Link) IsAbsent() bool {
	return false
}
func (Link) IsNull() bool {
	return false
}
func (Link) AsBool() (bool, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.AsBool()
}
func (Link) AsInt() (int64, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.AsInt()
}
func (Link) AsFloat() (float64, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.AsFloat()
}
func (Link) AsString() (string, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.AsString()
}
func (Link) AsBytes() ([]byte, error) {
	return mixins.Link{TypeName: "dagpb.Link"}.AsBytes()
}
func (n Link) AsLink() (ipld.Link, error) {
	return n.x, nil
}
func (Link) Prototype() ipld.NodePrototype {
	return _Link__Prototype{}
}

type _Link__Prototype struct{}

func (_Link__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Link__Builder
	nb.Reset()
	return &nb
}

type _Link__Builder struct {
	_Link__Assembler
}

func (nb *_Link__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Link__Builder) Reset() {
	var w _Link
	var m schema.Maybe
	*nb = _Link__Builder{_Link__Assembler{w: &w, m: &m}}
}

type _Link__Assembler struct {
	w *_Link
	m *schema.Maybe
}

func (na *_Link__Assembler) reset() {}
func (_Link__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.BeginMap(0)
}
func (_Link__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.BeginList(0)
}
func (na *_Link__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.LinkAssembler{TypeName: "dagpb.Link"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Link__Assembler) AssignBool(bool) error {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.AssignBool(false)
}
func (_Link__Assembler) AssignInt(int64) error {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.AssignInt(0)
}
func (_Link__Assembler) AssignFloat(float64) error {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.AssignFloat(0)
}
func (_Link__Assembler) AssignString(string) error {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.AssignString("")
}
func (_Link__Assembler) AssignBytes([]byte) error {
	return mixins.LinkAssembler{TypeName: "dagpb.Link"}.AssignBytes(nil)
}
func (na *_Link__Assembler) AssignLink(v ipld.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (na *_Link__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Link); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsLink(); err != nil {
		return err
	} else {
		return na.AssignLink(v2)
	}
}
func (_Link__Assembler) Prototype() ipld.NodePrototype {
	return _Link__Prototype{}
}
func (Link) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Link) Representation() ipld.Node {
	return (*_Link__Repr)(n)
}

type _Link__Repr = _Link

var _ ipld.Node = &_Link__Repr{}

type _Link__ReprPrototype = _Link__Prototype
type _Link__ReprAssembler = _Link__Assembler

func (n _PBLink) FieldHash() Link {
	return &n.Hash
}
func (n _PBLink) FieldName() MaybeString {
	return &n.Name
}
func (n _PBLink) FieldTsize() MaybeInt {
	return &n.Tsize
}

type _PBLink__Maybe struct {
	m schema.Maybe
	v PBLink
}
type MaybePBLink = *_PBLink__Maybe

func (m MaybePBLink) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybePBLink) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybePBLink) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybePBLink) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybePBLink) Must() PBLink {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__PBLink_Hash  = _String{"Hash"}
	fieldName__PBLink_Name  = _String{"Name"}
	fieldName__PBLink_Tsize = _String{"Tsize"}
)
var _ ipld.Node = (PBLink)(&_PBLink{})
var _ schema.TypedNode = (PBLink)(&_PBLink{})

func (PBLink) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n PBLink) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "Hash":
		return &n.Hash, nil
	case "Name":
		if n.Name.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.Name.v, nil
	case "Tsize":
		if n.Tsize.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.Tsize.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n PBLink) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (PBLink) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.LookupByIndex(0)
}
func (n PBLink) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n PBLink) MapIterator() ipld.MapIterator {
	return &_PBLink__MapItr{n, 0}
}

type _PBLink__MapItr struct {
	n   PBLink
	idx int
}

func (itr *_PBLink__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 3 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__PBLink_Hash
		v = &itr.n.Hash
	case 1:
		k = &fieldName__PBLink_Name
		if itr.n.Name.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.Name.v
	case 2:
		k = &fieldName__PBLink_Tsize
		if itr.n.Tsize.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.Tsize.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_PBLink__MapItr) Done() bool {
	return itr.idx >= 3
}

func (PBLink) ListIterator() ipld.ListIterator {
	return nil
}
func (PBLink) Length() int64 {
	return 3
}
func (PBLink) IsAbsent() bool {
	return false
}
func (PBLink) IsNull() bool {
	return false
}
func (PBLink) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.AsBool()
}
func (PBLink) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.AsInt()
}
func (PBLink) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.AsFloat()
}
func (PBLink) AsString() (string, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.AsString()
}
func (PBLink) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.AsBytes()
}
func (PBLink) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "dagpb.PBLink"}.AsLink()
}
func (PBLink) Prototype() ipld.NodePrototype {
	return _PBLink__Prototype{}
}

type _PBLink__Prototype struct{}

func (_PBLink__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _PBLink__Builder
	nb.Reset()
	return &nb
}

type _PBLink__Builder struct {
	_PBLink__Assembler
}

func (nb *_PBLink__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PBLink__Builder) Reset() {
	var w _PBLink
	var m schema.Maybe
	*nb = _PBLink__Builder{_PBLink__Assembler{w: &w, m: &m}}
}

type _PBLink__Assembler struct {
	w     *_PBLink
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm       schema.Maybe
	ca_Hash  _Link__Assembler
	ca_Name  _String__Assembler
	ca_Tsize _Int__Assembler
}

func (na *_PBLink__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Hash.reset()
	na.ca_Name.reset()
	na.ca_Tsize.reset()
}

var (
	fieldBit__PBLink_Hash        = 1 << 0
	fieldBit__PBLink_Name        = 1 << 1
	fieldBit__PBLink_Tsize       = 1 << 2
	fieldBits__PBLink_sufficient = 0 + 1<<0
)

func (na *_PBLink__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_PBLink{}
	}
	return na, nil
}
func (_PBLink__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.BeginList(0)
}
func (na *_PBLink__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PBLink__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignBool(false)
}
func (_PBLink__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignInt(0)
}
func (_PBLink__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignFloat(0)
}
func (_PBLink__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignString("")
}
func (_PBLink__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignBytes(nil)
}
func (_PBLink__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink"}.AssignLink(nil)
}
func (na *_PBLink__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PBLink); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "dagpb.PBLink", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PBLink__Assembler) Prototype() ipld.NodePrototype {
	return _PBLink__Prototype{}
}
func (ma *_PBLink__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_Hash.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.Name.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.Tsize.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_PBLink__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Hash":
		if ma.s&fieldBit__PBLink_Hash != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Hash}
		}
		ma.s += fieldBit__PBLink_Hash
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Hash.w = &ma.w.Hash
		ma.ca_Hash.m = &ma.cm
		return &ma.ca_Hash, nil
	case "Name":
		if ma.s&fieldBit__PBLink_Name != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Name}
		}
		ma.s += fieldBit__PBLink_Name
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Name.w = &ma.w.Name.v
		ma.ca_Name.m = &ma.w.Name.m
		return &ma.ca_Name, nil
	case "Tsize":
		if ma.s&fieldBit__PBLink_Tsize != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Tsize}
		}
		ma.s += fieldBit__PBLink_Tsize
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_Tsize.w = &ma.w.Tsize.v
		ma.ca_Tsize.m = &ma.w.Tsize.m
		return &ma.ca_Tsize, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "dagpb.PBLink", Key: &_String{k}}
}
func (ma *_PBLink__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_PBLink__KeyAssembler)(ma)
}
func (ma *_PBLink__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Hash.w = &ma.w.Hash
		ma.ca_Hash.m = &ma.cm
		return &ma.ca_Hash
	case 1:
		ma.ca_Name.w = &ma.w.Name.v
		ma.ca_Name.m = &ma.w.Name.m
		return &ma.ca_Name
	case 2:
		ma.ca_Tsize.w = &ma.w.Tsize.v
		ma.ca_Tsize.m = &ma.w.Tsize.m
		return &ma.ca_Tsize
	default:
		panic("unreachable")
	}
}
func (ma *_PBLink__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__PBLink_sufficient != fieldBits__PBLink_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__PBLink_Hash == 0 {
			err.Missing = append(err.Missing, "Hash")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_PBLink__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_PBLink__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _PBLink__KeyAssembler _PBLink__Assembler

func (_PBLink__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.BeginMap(0)
}
func (_PBLink__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.BeginList(0)
}
func (na *_PBLink__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.AssignNull()
}
func (_PBLink__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.AssignBool(false)
}
func (_PBLink__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.AssignInt(0)
}
func (_PBLink__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.AssignFloat(0)
}
func (ka *_PBLink__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Hash":
		if ka.s&fieldBit__PBLink_Hash != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Hash}
		}
		ka.s += fieldBit__PBLink_Hash
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Name":
		if ka.s&fieldBit__PBLink_Name != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Name}
		}
		ka.s += fieldBit__PBLink_Name
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "Tsize":
		if ka.s&fieldBit__PBLink_Tsize != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Tsize}
		}
		ka.s += fieldBit__PBLink_Tsize
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	default:
		return ipld.ErrInvalidKey{TypeName: "dagpb.PBLink", Key: &_String{k}}
	}
}
func (_PBLink__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.AssignBytes(nil)
}
func (_PBLink__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.KeyAssembler"}.AssignLink(nil)
}
func (ka *_PBLink__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_PBLink__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (PBLink) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n PBLink) Representation() ipld.Node {
	return (*_PBLink__Repr)(n)
}

type _PBLink__Repr _PBLink

var (
	fieldName__PBLink_Hash_serial  = _String{"Hash"}
	fieldName__PBLink_Name_serial  = _String{"Name"}
	fieldName__PBLink_Tsize_serial = _String{"Tsize"}
)
var _ ipld.Node = &_PBLink__Repr{}

func (_PBLink__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_PBLink__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "Hash":
		return n.Hash.Representation(), nil
	case "Name":
		if n.Name.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Name.v.Representation(), nil
	case "Tsize":
		if n.Tsize.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Tsize.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_PBLink__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_PBLink__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.LookupByIndex(0)
}
func (n _PBLink__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_PBLink__Repr) MapIterator() ipld.MapIterator {
	end := 3
	if n.Tsize.m == schema.Maybe_Absent {
		end = 2
	} else {
		goto done
	}
	if n.Name.m == schema.Maybe_Absent {
		end = 1
	} else {
		goto done
	}
done:
	return &_PBLink__ReprMapItr{n, 0, end}
}

type _PBLink__ReprMapItr struct {
	n   *_PBLink__Repr
	idx int
	end int
}

func (itr *_PBLink__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
advance:
	if itr.idx >= 3 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__PBLink_Hash_serial
		v = itr.n.Hash.Representation()
	case 1:
		k = &fieldName__PBLink_Name_serial
		if itr.n.Name.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Name.v.Representation()
	case 2:
		k = &fieldName__PBLink_Tsize_serial
		if itr.n.Tsize.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Tsize.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_PBLink__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_PBLink__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_PBLink__Repr) Length() int64 {
	l := 3
	if rn.Name.m == schema.Maybe_Absent {
		l--
	}
	if rn.Tsize.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_PBLink__Repr) IsAbsent() bool {
	return false
}
func (_PBLink__Repr) IsNull() bool {
	return false
}
func (_PBLink__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.AsBool()
}
func (_PBLink__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.AsInt()
}
func (_PBLink__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.AsFloat()
}
func (_PBLink__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.AsString()
}
func (_PBLink__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.AsBytes()
}
func (_PBLink__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "dagpb.PBLink.Repr"}.AsLink()
}
func (_PBLink__Repr) Prototype() ipld.NodePrototype {
	return _PBLink__ReprPrototype{}
}

type _PBLink__ReprPrototype struct{}

func (_PBLink__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _PBLink__ReprBuilder
	nb.Reset()
	return &nb
}

type _PBLink__ReprBuilder struct {
	_PBLink__ReprAssembler
}

func (nb *_PBLink__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PBLink__ReprBuilder) Reset() {
	var w _PBLink
	var m schema.Maybe
	*nb = _PBLink__ReprBuilder{_PBLink__ReprAssembler{w: &w, m: &m}}
}

type _PBLink__ReprAssembler struct {
	w     *_PBLink
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm       schema.Maybe
	ca_Hash  _Link__ReprAssembler
	ca_Name  _String__ReprAssembler
	ca_Tsize _Int__ReprAssembler
}

func (na *_PBLink__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Hash.reset()
	na.ca_Name.reset()
	na.ca_Tsize.reset()
}
func (na *_PBLink__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_PBLink{}
	}
	return na, nil
}
func (_PBLink__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.BeginList(0)
}
func (na *_PBLink__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PBLink__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.AssignBool(false)
}
func (_PBLink__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.AssignInt(0)
}
func (_PBLink__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.AssignFloat(0)
}
func (_PBLink__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.AssignString("")
}
func (_PBLink__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.AssignBytes(nil)
}
func (_PBLink__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBLink.Repr"}.AssignLink(nil)
}
func (na *_PBLink__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PBLink); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "dagpb.PBLink.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PBLink__ReprAssembler) Prototype() ipld.NodePrototype {
	return _PBLink__ReprPrototype{}
}
func (ma *_PBLink__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.Name.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.Tsize.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_PBLink__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Hash":
		if ma.s&fieldBit__PBLink_Hash != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Hash_serial}
		}
		ma.s += fieldBit__PBLink_Hash
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Hash.w = &ma.w.Hash
		ma.ca_Hash.m = &ma.cm
		return &ma.ca_Hash, nil
	case "Name":
		if ma.s&fieldBit__PBLink_Name != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Name_serial}
		}
		ma.s += fieldBit__PBLink_Name
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Name.w = &ma.w.Name.v
		ma.ca_Name.m = &ma.w.Name.m

		return &ma.ca_Name, nil
	case "Tsize":
		if ma.s&fieldBit__PBLink_Tsize != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Tsize_serial}
		}
		ma.s += fieldBit__PBLink_Tsize
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_Tsize.w = &ma.w.Tsize.v
		ma.ca_Tsize.m = &ma.w.Tsize.m

		return &ma.ca_Tsize, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "dagpb.PBLink.Repr", Key: &_String{k}}
}
func (ma *_PBLink__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_PBLink__ReprKeyAssembler)(ma)
}
func (ma *_PBLink__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Hash.w = &ma.w.Hash
		ma.ca_Hash.m = &ma.cm
		return &ma.ca_Hash
	case 1:
		ma.ca_Name.w = &ma.w.Name.v
		ma.ca_Name.m = &ma.w.Name.m

		return &ma.ca_Name
	case 2:
		ma.ca_Tsize.w = &ma.w.Tsize.v
		ma.ca_Tsize.m = &ma.w.Tsize.m

		return &ma.ca_Tsize
	default:
		panic("unreachable")
	}
}
func (ma *_PBLink__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__PBLink_sufficient != fieldBits__PBLink_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__PBLink_Hash == 0 {
			err.Missing = append(err.Missing, "Hash")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_PBLink__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_PBLink__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _PBLink__ReprKeyAssembler _PBLink__ReprAssembler

func (_PBLink__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.BeginMap(0)
}
func (_PBLink__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_PBLink__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.AssignNull()
}
func (_PBLink__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.AssignBool(false)
}
func (_PBLink__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.AssignInt(0)
}
func (_PBLink__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_PBLink__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Hash":
		if ka.s&fieldBit__PBLink_Hash != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Hash_serial}
		}
		ka.s += fieldBit__PBLink_Hash
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Name":
		if ka.s&fieldBit__PBLink_Name != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Name_serial}
		}
		ka.s += fieldBit__PBLink_Name
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "Tsize":
		if ka.s&fieldBit__PBLink_Tsize != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBLink_Tsize_serial}
		}
		ka.s += fieldBit__PBLink_Tsize
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "dagpb.PBLink.Repr", Key: &_String{k}}
}
func (_PBLink__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_PBLink__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBLink.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_PBLink__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_PBLink__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n *_PBLinks) Lookup(idx int64) PBLink {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_PBLinks) LookupMaybe(idx int64) MaybePBLink {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_PBLink__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _PBLinks__valueAbsent = _PBLink__Maybe{m: schema.Maybe_Absent}

func (n PBLinks) Iterator() *PBLinks__Itr {
	return &PBLinks__Itr{n, 0}
}

type PBLinks__Itr struct {
	n   PBLinks
	idx int
}

func (itr *PBLinks__Itr) Next() (idx int64, v PBLink) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *PBLinks__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _PBLinks__Maybe struct {
	m schema.Maybe
	v _PBLinks
}
type MaybePBLinks = *_PBLinks__Maybe

func (m MaybePBLinks) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybePBLinks) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybePBLinks) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybePBLinks) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybePBLinks) Must() PBLinks {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (PBLinks)(&_PBLinks{})
var _ schema.TypedNode = (PBLinks)(&_PBLinks{})

func (PBLinks) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (PBLinks) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.LookupByString("")
}
func (n PBLinks) LookupByNode(k ipld.Node) (ipld.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n PBLinks) LookupByIndex(idx int64) (ipld.Node, error) {
	if n.Length() <= idx {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n PBLinks) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "dagpb.PBLinks", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (PBLinks) MapIterator() ipld.MapIterator {
	return nil
}
func (n PBLinks) ListIterator() ipld.ListIterator {
	return &_PBLinks__ListItr{n, 0}
}

type _PBLinks__ListItr struct {
	n   PBLinks
	idx int
}

func (itr *_PBLinks__ListItr) Next() (idx int64, v ipld.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, ipld.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_PBLinks__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n PBLinks) Length() int64 {
	return int64(len(n.x))
}
func (PBLinks) IsAbsent() bool {
	return false
}
func (PBLinks) IsNull() bool {
	return false
}
func (PBLinks) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.AsBool()
}
func (PBLinks) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.AsInt()
}
func (PBLinks) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.AsFloat()
}
func (PBLinks) AsString() (string, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.AsString()
}
func (PBLinks) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.AsBytes()
}
func (PBLinks) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "dagpb.PBLinks"}.AsLink()
}
func (PBLinks) Prototype() ipld.NodePrototype {
	return _PBLinks__Prototype{}
}

type _PBLinks__Prototype struct{}

func (_PBLinks__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _PBLinks__Builder
	nb.Reset()
	return &nb
}

type _PBLinks__Builder struct {
	_PBLinks__Assembler
}

func (nb *_PBLinks__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PBLinks__Builder) Reset() {
	var w _PBLinks
	var m schema.Maybe
	*nb = _PBLinks__Builder{_PBLinks__Assembler{w: &w, m: &m}}
}

type _PBLinks__Assembler struct {
	w     *_PBLinks
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _PBLink__Assembler
}

func (na *_PBLinks__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_PBLinks__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.BeginMap(0)
}
func (na *_PBLinks__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_PBLink, 0, sizeHint)
	}
	return na, nil
}
func (na *_PBLinks__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PBLinks__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignBool(false)
}
func (_PBLinks__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignInt(0)
}
func (_PBLinks__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignFloat(0)
}
func (_PBLinks__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignString("")
}
func (_PBLinks__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignBytes(nil)
}
func (_PBLinks__Assembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks"}.AssignLink(nil)
}
func (na *_PBLinks__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PBLinks); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "dagpb.PBLinks", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PBLinks__Assembler) Prototype() ipld.NodePrototype {
	return _PBLinks__Prototype{}
}
func (la *_PBLinks__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_PBLinks__Assembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _PBLink{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_PBLinks__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_PBLinks__Assembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _PBLink__Prototype{}
}
func (PBLinks) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n PBLinks) Representation() ipld.Node {
	return (*_PBLinks__Repr)(n)
}

type _PBLinks__Repr _PBLinks

var _ ipld.Node = &_PBLinks__Repr{}

func (_PBLinks__Repr) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (_PBLinks__Repr) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.LookupByString("")
}
func (nr *_PBLinks__Repr) LookupByNode(k ipld.Node) (ipld.Node, error) {
	v, err := (PBLinks)(nr).LookupByNode(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(PBLink).Representation(), nil
}
func (nr *_PBLinks__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	v, err := (PBLinks)(nr).LookupByIndex(idx)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(PBLink).Representation(), nil
}
func (n _PBLinks__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "dagpb.PBLinks.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_PBLinks__Repr) MapIterator() ipld.MapIterator {
	return nil
}
func (nr *_PBLinks__Repr) ListIterator() ipld.ListIterator {
	return &_PBLinks__ReprListItr{(PBLinks)(nr), 0}
}

type _PBLinks__ReprListItr _PBLinks__ListItr

func (itr *_PBLinks__ReprListItr) Next() (idx int64, v ipld.Node, err error) {
	idx, v, err = (*_PBLinks__ListItr)(itr).Next()
	if err != nil || v == ipld.Null {
		return
	}
	return idx, v.(PBLink).Representation(), nil
}
func (itr *_PBLinks__ReprListItr) Done() bool {
	return (*_PBLinks__ListItr)(itr).Done()
}

func (rn *_PBLinks__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_PBLinks__Repr) IsAbsent() bool {
	return false
}
func (_PBLinks__Repr) IsNull() bool {
	return false
}
func (_PBLinks__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.AsBool()
}
func (_PBLinks__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.AsInt()
}
func (_PBLinks__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.AsFloat()
}
func (_PBLinks__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.AsString()
}
func (_PBLinks__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.AsBytes()
}
func (_PBLinks__Repr) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "dagpb.PBLinks.Repr"}.AsLink()
}
func (_PBLinks__Repr) Prototype() ipld.NodePrototype {
	return _PBLinks__ReprPrototype{}
}

type _PBLinks__ReprPrototype struct{}

func (_PBLinks__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _PBLinks__ReprBuilder
	nb.Reset()
	return &nb
}

type _PBLinks__ReprBuilder struct {
	_PBLinks__ReprAssembler
}

func (nb *_PBLinks__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PBLinks__ReprBuilder) Reset() {
	var w _PBLinks
	var m schema.Maybe
	*nb = _PBLinks__ReprBuilder{_PBLinks__ReprAssembler{w: &w, m: &m}}
}

type _PBLinks__ReprAssembler struct {
	w     *_PBLinks
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _PBLink__ReprAssembler
}

func (na *_PBLinks__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_PBLinks__ReprAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.BeginMap(0)
}
func (na *_PBLinks__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_PBLink, 0, sizeHint)
	}
	return na, nil
}
func (na *_PBLinks__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PBLinks__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.AssignBool(false)
}
func (_PBLinks__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.AssignInt(0)
}
func (_PBLinks__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.AssignFloat(0)
}
func (_PBLinks__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.AssignString("")
}
func (_PBLinks__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.AssignBytes(nil)
}
func (_PBLinks__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "dagpb.PBLinks.Repr"}.AssignLink(nil)
}
func (na *_PBLinks__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PBLinks); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "dagpb.PBLinks.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PBLinks__ReprAssembler) Prototype() ipld.NodePrototype {
	return _PBLinks__ReprPrototype{}
}
func (la *_PBLinks__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_PBLinks__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _PBLink{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_PBLinks__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_PBLinks__ReprAssembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _PBLink__ReprPrototype{}
}

func (n _PBNode) FieldLinks() PBLinks {
	return &n.Links
}
func (n _PBNode) FieldData() MaybeBytes {
	return &n.Data
}

type _PBNode__Maybe struct {
	m schema.Maybe
	v PBNode
}
type MaybePBNode = *_PBNode__Maybe

func (m MaybePBNode) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybePBNode) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybePBNode) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybePBNode) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybePBNode) Must() PBNode {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__PBNode_Links = _String{"Links"}
	fieldName__PBNode_Data  = _String{"Data"}
)
var _ ipld.Node = (PBNode)(&_PBNode{})
var _ schema.TypedNode = (PBNode)(&_PBNode{})

func (PBNode) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n PBNode) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "Links":
		return &n.Links, nil
	case "Data":
		if n.Data.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.Data.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n PBNode) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (PBNode) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.LookupByIndex(0)
}
func (n PBNode) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n PBNode) MapIterator() ipld.MapIterator {
	return &_PBNode__MapItr{n, 0}
}

type _PBNode__MapItr struct {
	n   PBNode
	idx int
}

func (itr *_PBNode__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__PBNode_Links
		v = &itr.n.Links
	case 1:
		k = &fieldName__PBNode_Data
		if itr.n.Data.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.Data.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_PBNode__MapItr) Done() bool {
	return itr.idx >= 2
}

func (PBNode) ListIterator() ipld.ListIterator {
	return nil
}
func (PBNode) Length() int64 {
	return 2
}
func (PBNode) IsAbsent() bool {
	return false
}
func (PBNode) IsNull() bool {
	return false
}
func (PBNode) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.AsBool()
}
func (PBNode) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.AsInt()
}
func (PBNode) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.AsFloat()
}
func (PBNode) AsString() (string, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.AsString()
}
func (PBNode) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.AsBytes()
}
func (PBNode) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "dagpb.PBNode"}.AsLink()
}
func (PBNode) Prototype() ipld.NodePrototype {
	return _PBNode__Prototype{}
}

type _PBNode__Prototype struct{}

func (_PBNode__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _PBNode__Builder
	nb.Reset()
	return &nb
}

type _PBNode__Builder struct {
	_PBNode__Assembler
}

func (nb *_PBNode__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PBNode__Builder) Reset() {
	var w _PBNode
	var m schema.Maybe
	*nb = _PBNode__Builder{_PBNode__Assembler{w: &w, m: &m}}
}

type _PBNode__Assembler struct {
	w     *_PBNode
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm       schema.Maybe
	ca_Links _PBLinks__Assembler
	ca_Data  _Bytes__Assembler
}

func (na *_PBNode__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Links.reset()
	na.ca_Data.reset()
}

var (
	fieldBit__PBNode_Links       = 1 << 0
	fieldBit__PBNode_Data        = 1 << 1
	fieldBits__PBNode_sufficient = 0 + 1<<0
)

func (na *_PBNode__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_PBNode{}
	}
	return na, nil
}
func (_PBNode__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.BeginList(0)
}
func (na *_PBNode__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PBNode__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignBool(false)
}
func (_PBNode__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignInt(0)
}
func (_PBNode__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignFloat(0)
}
func (_PBNode__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignString("")
}
func (_PBNode__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignBytes(nil)
}
func (_PBNode__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode"}.AssignLink(nil)
}
func (na *_PBNode__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PBNode); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "dagpb.PBNode", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PBNode__Assembler) Prototype() ipld.NodePrototype {
	return _PBNode__Prototype{}
}
func (ma *_PBNode__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_Links.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.Data.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_PBNode__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Links":
		if ma.s&fieldBit__PBNode_Links != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Links}
		}
		ma.s += fieldBit__PBNode_Links
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Links.w = &ma.w.Links
		ma.ca_Links.m = &ma.cm
		return &ma.ca_Links, nil
	case "Data":
		if ma.s&fieldBit__PBNode_Data != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Data}
		}
		ma.s += fieldBit__PBNode_Data
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m
		return &ma.ca_Data, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "dagpb.PBNode", Key: &_String{k}}
}
func (ma *_PBNode__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_PBNode__KeyAssembler)(ma)
}
func (ma *_PBNode__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Links.w = &ma.w.Links
		ma.ca_Links.m = &ma.cm
		return &ma.ca_Links
	case 1:
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m
		return &ma.ca_Data
	default:
		panic("unreachable")
	}
}
func (ma *_PBNode__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__PBNode_sufficient != fieldBits__PBNode_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__PBNode_Links == 0 {
			err.Missing = append(err.Missing, "Links")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_PBNode__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_PBNode__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _PBNode__KeyAssembler _PBNode__Assembler

func (_PBNode__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.BeginMap(0)
}
func (_PBNode__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.BeginList(0)
}
func (na *_PBNode__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.AssignNull()
}
func (_PBNode__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.AssignBool(false)
}
func (_PBNode__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.AssignInt(0)
}
func (_PBNode__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.AssignFloat(0)
}
func (ka *_PBNode__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Links":
		if ka.s&fieldBit__PBNode_Links != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Links}
		}
		ka.s += fieldBit__PBNode_Links
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Data":
		if ka.s&fieldBit__PBNode_Data != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Data}
		}
		ka.s += fieldBit__PBNode_Data
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	default:
		return ipld.ErrInvalidKey{TypeName: "dagpb.PBNode", Key: &_String{k}}
	}
}
func (_PBNode__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.AssignBytes(nil)
}
func (_PBNode__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.KeyAssembler"}.AssignLink(nil)
}
func (ka *_PBNode__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_PBNode__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (PBNode) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n PBNode) Representation() ipld.Node {
	return (*_PBNode__Repr)(n)
}

type _PBNode__Repr _PBNode

var (
	fieldName__PBNode_Links_serial = _String{"Links"}
	fieldName__PBNode_Data_serial  = _String{"Data"}
)
var _ ipld.Node = &_PBNode__Repr{}

func (_PBNode__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_PBNode__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "Links":
		return n.Links.Representation(), nil
	case "Data":
		if n.Data.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Data.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_PBNode__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_PBNode__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.LookupByIndex(0)
}
func (n _PBNode__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_PBNode__Repr) MapIterator() ipld.MapIterator {
	end := 2
	if n.Data.m == schema.Maybe_Absent {
		end = 1
	} else {
		goto done
	}
done:
	return &_PBNode__ReprMapItr{n, 0, end}
}

type _PBNode__ReprMapItr struct {
	n   *_PBNode__Repr
	idx int
	end int
}

func (itr *_PBNode__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
advance:
	if itr.idx >= 2 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__PBNode_Links_serial
		v = itr.n.Links.Representation()
	case 1:
		k = &fieldName__PBNode_Data_serial
		if itr.n.Data.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Data.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_PBNode__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_PBNode__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_PBNode__Repr) Length() int64 {
	l := 2
	if rn.Data.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_PBNode__Repr) IsAbsent() bool {
	return false
}
func (_PBNode__Repr) IsNull() bool {
	return false
}
func (_PBNode__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.AsBool()
}
func (_PBNode__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.AsInt()
}
func (_PBNode__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.AsFloat()
}
func (_PBNode__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.AsString()
}
func (_PBNode__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.AsBytes()
}
func (_PBNode__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "dagpb.PBNode.Repr"}.AsLink()
}
func (_PBNode__Repr) Prototype() ipld.NodePrototype {
	return _PBNode__ReprPrototype{}
}

type _PBNode__ReprPrototype struct{}

func (_PBNode__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _PBNode__ReprBuilder
	nb.Reset()
	return &nb
}

type _PBNode__ReprBuilder struct {
	_PBNode__ReprAssembler
}

func (nb *_PBNode__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_PBNode__ReprBuilder) Reset() {
	var w _PBNode
	var m schema.Maybe
	*nb = _PBNode__ReprBuilder{_PBNode__ReprAssembler{w: &w, m: &m}}
}

type _PBNode__ReprAssembler struct {
	w     *_PBNode
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm       schema.Maybe
	ca_Links _PBLinks__ReprAssembler
	ca_Data  _Bytes__ReprAssembler
}

func (na *_PBNode__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Links.reset()
	na.ca_Data.reset()
}
func (na *_PBNode__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_PBNode{}
	}
	return na, nil
}
func (_PBNode__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.BeginList(0)
}
func (na *_PBNode__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_PBNode__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.AssignBool(false)
}
func (_PBNode__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.AssignInt(0)
}
func (_PBNode__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.AssignFloat(0)
}
func (_PBNode__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.AssignString("")
}
func (_PBNode__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.AssignBytes(nil)
}
func (_PBNode__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "dagpb.PBNode.Repr"}.AssignLink(nil)
}
func (na *_PBNode__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_PBNode); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "dagpb.PBNode.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_PBNode__ReprAssembler) Prototype() ipld.NodePrototype {
	return _PBNode__ReprPrototype{}
}
func (ma *_PBNode__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.Data.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_PBNode__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Links":
		if ma.s&fieldBit__PBNode_Links != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Links_serial}
		}
		ma.s += fieldBit__PBNode_Links
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Links.w = &ma.w.Links
		ma.ca_Links.m = &ma.cm
		return &ma.ca_Links, nil
	case "Data":
		if ma.s&fieldBit__PBNode_Data != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Data_serial}
		}
		ma.s += fieldBit__PBNode_Data
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m

		return &ma.ca_Data, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "dagpb.PBNode.Repr", Key: &_String{k}}
}
func (ma *_PBNode__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_PBNode__ReprKeyAssembler)(ma)
}
func (ma *_PBNode__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Links.w = &ma.w.Links
		ma.ca_Links.m = &ma.cm
		return &ma.ca_Links
	case 1:
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m

		return &ma.ca_Data
	default:
		panic("unreachable")
	}
}
func (ma *_PBNode__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__PBNode_sufficient != fieldBits__PBNode_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__PBNode_Links == 0 {
			err.Missing = append(err.Missing, "Links")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_PBNode__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_PBNode__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _PBNode__ReprKeyAssembler _PBNode__ReprAssembler

func (_PBNode__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.BeginMap(0)
}
func (_PBNode__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_PBNode__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.AssignNull()
}
func (_PBNode__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.AssignBool(false)
}
func (_PBNode__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.AssignInt(0)
}
func (_PBNode__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_PBNode__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Links":
		if ka.s&fieldBit__PBNode_Links != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Links_serial}
		}
		ka.s += fieldBit__PBNode_Links
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Data":
		if ka.s&fieldBit__PBNode_Data != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__PBNode_Data_serial}
		}
		ka.s += fieldBit__PBNode_Data
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "dagpb.PBNode.Repr", Key: &_String{k}}
}
func (_PBNode__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_PBNode__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "dagpb.PBNode.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_PBNode__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_PBNode__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n String) String() string {
	return n.x
}
func (_String__Prototype) fromString(w *_String, v string) error {
	*w = _String{v}
	return nil
}
func (_String__Prototype) FromString(v string) (String, error) {
	n := _String{v}
	return &n, nil
}

type _String__Maybe struct {
	m schema.Maybe
	v _String
}
type MaybeString = *_String__Maybe

func (m MaybeString) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeString) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeString) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeString) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeString) Must() String {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (String)(&_String{})
var _ schema.TypedNode = (String)(&_String{})

func (String) Kind() ipld.Kind {
	return ipld.Kind_String
}
func (String) LookupByString(string) (ipld.Node, error) {
	return mixins.String{TypeName: "dagpb.String"}.LookupByString("")
}
func (String) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.String{TypeName: "dagpb.String"}.LookupByNode(nil)
}
func (String) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.String{TypeName: "dagpb.String"}.LookupByIndex(0)
}
func (String) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.String{TypeName: "dagpb.String"}.LookupBySegment(seg)
}
func (String) MapIterator() ipld.MapIterator {
	return nil
}
func (String) ListIterator() ipld.ListIterator {
	return nil
}
func (String) Length() int64 {
	return -1
}
func (String) IsAbsent() bool {
	return false
}
func (String) IsNull() bool {
	return false
}
func (String) AsBool() (bool, error) {
	return mixins.String{TypeName: "dagpb.String"}.AsBool()
}
func (String) AsInt() (int64, error) {
	return mixins.String{TypeName: "dagpb.String"}.AsInt()
}
func (String) AsFloat() (float64, error) {
	return mixins.String{TypeName: "dagpb.String"}.AsFloat()
}
func (n String) AsString() (string, error) {
	return n.x, nil
}
func (String) AsBytes() ([]byte, error) {
	return mixins.String{TypeName: "dagpb.String"}.AsBytes()
}
func (String) AsLink() (ipld.Link, error) {
	return mixins.String{TypeName: "dagpb.String"}.AsLink()
}
func (String) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

type _String__Prototype struct{}

func (_String__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _String__Builder
	nb.Reset()
	return &nb
}

type _String__Builder struct {
	_String__Assembler
}

func (nb *_String__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String__Builder) Reset() {
	var w _String
	var m schema.Maybe
	*nb = _String__Builder{_String__Assembler{w: &w, m: &m}}
}

type _String__Assembler struct {
	w *_String
	m *schema.Maybe
}

func (na *_String__Assembler) reset() {}
func (_String__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.BeginMap(0)
}
func (_String__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.BeginList(0)
}
func (na *_String__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.StringAssembler{TypeName: "dagpb.String"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_String__Assembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.AssignBool(false)
}
func (_String__Assembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.AssignInt(0)
}
func (_String__Assembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.AssignFloat(0)
}
func (na *_String__Assembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_String__Assembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.AssignBytes(nil)
}
func (_String__Assembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "dagpb.String"}.AssignLink(nil)
}
func (na *_String__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return na.AssignString(v2)
	}
}
func (_String__Assembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (String) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n String) Representation() ipld.Node {
	return (*_String__Repr)(n)
}

type _String__Repr = _String

var _ ipld.Node = &_String__Repr{}

type _String__ReprPrototype = _String__Prototype
type _String__ReprAssembler = _String__Assembler
