// GENERATED FILE - DO NOT EDIT.
// Generated by generate_tests.py
//
// Copyright (c) 2022 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "../diff_test_utils.h"

#include "gtest/gtest.h"

namespace spvtools {
namespace diff {
namespace {

// Test where variable set/binding/location decorations are different between
// src and dst vertex shaders.
constexpr char kSrc[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %20 %25
OpSource GLSL 450
OpName %4 "_ub"
OpName %5 "_uc"
OpName %6 "_ud"
OpName %8 "_ue"
OpName %9 "defaultUniformsVS"
OpMemberName %9 0 "_ua"
OpName %11 ""
OpName %16 "ANGLEDepthRangeParams"
OpMemberName %16 0 "near"
OpMemberName %16 1 "far"
OpMemberName %16 2 "diff"
OpMemberName %16 3 "reserved"
OpName %17 "ANGLEUniformBlock"
OpMemberName %17 0 "viewport"
OpMemberName %17 1 "clipDistancesEnabled"
OpMemberName %17 2 "xfbActiveUnpaused"
OpMemberName %17 3 "xfbVerticesPerInstance"
OpMemberName %17 4 "numSamples"
OpMemberName %17 5 "xfbBufferOffsets"
OpMemberName %17 6 "acbBufferOffsets"
OpMemberName %17 7 "depthRange"
OpName %19 "ANGLEUniforms"
OpName %20 "ANGLEXfbPosition"
OpName %23 "gl_PerVertex"
OpMemberName %23 0 "gl_Position"
OpMemberName %23 1 "gl_PointSize"
OpMemberName %23 2 "gl_ClipDistance"
OpMemberName %23 3 "gl_CullDistance"
OpName %25 ""
OpName %29 "_ua"
OpName %28 "_uf"
OpName %33 "_uf"
OpName %32 "_ug"
OpName %40 "main"
OpName %42 "param"
OpName %50 "param"
OpName %53 "param"
OpDecorate %4 Location 0
OpDecorate %5 Location 1
OpDecorate %6 Location 2
OpDecorate %8 Location 0
OpMemberDecorate %9 0 Offset 0
OpDecorate %9 Block
OpDecorate %11 DescriptorSet 0
OpDecorate %11 Binding 0
OpMemberDecorate %16 0 Offset 0
OpMemberDecorate %16 1 Offset 4
OpMemberDecorate %16 2 Offset 8
OpMemberDecorate %16 3 Offset 12
OpMemberDecorate %17 0 Offset 0
OpMemberDecorate %17 1 Offset 16
OpMemberDecorate %17 2 Offset 20
OpMemberDecorate %17 3 Offset 24
OpMemberDecorate %17 4 Offset 28
OpMemberDecorate %17 5 Offset 32
OpMemberDecorate %17 6 Offset 48
OpMemberDecorate %17 7 Offset 64
OpMemberDecorate %17 2 RelaxedPrecision
OpMemberDecorate %17 4 RelaxedPrecision
OpDecorate %17 Block
OpDecorate %19 DescriptorSet 0
OpDecorate %19 Binding 1
OpDecorate %20 Location 1
OpMemberDecorate %23 0 BuiltIn Position
OpMemberDecorate %23 1 BuiltIn PointSize
OpMemberDecorate %23 2 BuiltIn ClipDistance
OpMemberDecorate %23 3 BuiltIn CullDistance
OpDecorate %23 Block
OpDecorate %28 RelaxedPrecision
OpDecorate %29 RelaxedPrecision
OpDecorate %31 RelaxedPrecision
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %35 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %44 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%9 = OpTypeStruct %2
%12 = OpTypeInt 32 0
%13 = OpTypeInt 32 1
%14 = OpTypeVector %13 4
%15 = OpTypeVector %12 4
%16 = OpTypeStruct %1 %1 %1 %1
%17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
%21 = OpConstant %12 8
%22 = OpTypeArray %1 %21
%23 = OpTypeStruct %2 %1 %22 %22
%38 = OpTypeVoid
%45 = OpConstant %12 0
%3 = OpTypePointer Input %2
%7 = OpTypePointer Output %2
%10 = OpTypePointer Uniform %9
%18 = OpTypePointer Uniform %17
%24 = OpTypePointer Output %23
%26 = OpTypePointer Function %2
%46 = OpTypePointer Uniform %2
%27 = OpTypeFunction %2 %26
%39 = OpTypeFunction %38
%4 = OpVariable %3 Input
%5 = OpVariable %3 Input
%6 = OpVariable %3 Input
%8 = OpVariable %7 Output
%11 = OpVariable %10 Uniform
%19 = OpVariable %18 Uniform
%20 = OpVariable %7 Output
%25 = OpVariable %24 Output
%28 = OpFunction %2 None %27
%29 = OpFunctionParameter %26
%30 = OpLabel
%31 = OpLoad %2 %29
OpReturnValue %31
OpFunctionEnd
%32 = OpFunction %2 None %27
%33 = OpFunctionParameter %26
%34 = OpLabel
%35 = OpLoad %2 %33
%36 = OpLoad %2 %33
%37 = OpFAdd %2 %35 %36
OpReturnValue %37
OpFunctionEnd
%40 = OpFunction %38 None %39
%41 = OpLabel
%42 = OpVariable %26 Function
%50 = OpVariable %26 Function
%53 = OpVariable %26 Function
%43 = OpLoad %2 %4
OpStore %42 %43
%44 = OpFunctionCall %2 %28 %42
%47 = OpAccessChain %46 %11 %45
%48 = OpLoad %2 %47
%49 = OpFAdd %2 %44 %48
OpStore %8 %49
%51 = OpLoad %2 %5
OpStore %50 %51
%52 = OpFunctionCall %2 %32 %50
%54 = OpLoad %2 %6
OpStore %53 %54
%55 = OpFunctionCall %2 %28 %53
%56 = OpFAdd %2 %52 %55
%57 = OpAccessChain %7 %25 %45
OpStore %57 %56
OpReturn
OpFunctionEnd
)";
constexpr char kDst[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %25
OpSource GLSL 450
OpName %4 "_ub"
OpName %5 "_uc"
OpName %6 "_ud"
OpName %8 "_ue"
OpName %9 "defaultUniformsVS"
OpMemberName %9 0 "_ua"
OpName %11 ""
OpName %16 "ANGLEDepthRangeParams"
OpMemberName %16 0 "near"
OpMemberName %16 1 "far"
OpMemberName %16 2 "diff"
OpMemberName %16 3 "reserved"
OpName %17 "ANGLEUniformBlock"
OpMemberName %17 0 "viewport"
OpMemberName %17 1 "clipDistancesEnabled"
OpMemberName %17 2 "xfbActiveUnpaused"
OpMemberName %17 3 "xfbVerticesPerInstance"
OpMemberName %17 4 "numSamples"
OpMemberName %17 5 "xfbBufferOffsets"
OpMemberName %17 6 "acbBufferOffsets"
OpMemberName %17 7 "depthRange"
OpName %19 "ANGLEUniforms"
OpName %23 "gl_PerVertex"
OpMemberName %23 0 "gl_Position"
OpName %25 ""
OpName %29 "_ua"
OpName %28 "_uf"
OpName %33 "_uf"
OpName %32 "_ug"
OpName %40 "main"
OpName %42 "param"
OpName %50 "param"
OpName %53 "param"
OpDecorate %4 Location 1
OpDecorate %5 Location 2
OpDecorate %6 Location 0
OpDecorate %8 Location 1
OpMemberDecorate %9 0 Offset 0
OpDecorate %9 Block
OpDecorate %11 DescriptorSet 0
OpDecorate %11 Binding 1
OpMemberDecorate %16 0 Offset 0
OpMemberDecorate %16 1 Offset 4
OpMemberDecorate %16 2 Offset 8
OpMemberDecorate %16 3 Offset 12
OpMemberDecorate %17 0 Offset 0
OpMemberDecorate %17 1 Offset 16
OpMemberDecorate %17 2 Offset 20
OpMemberDecorate %17 3 Offset 24
OpMemberDecorate %17 4 Offset 28
OpMemberDecorate %17 5 Offset 32
OpMemberDecorate %17 6 Offset 48
OpMemberDecorate %17 7 Offset 64
OpMemberDecorate %17 2 RelaxedPrecision
OpMemberDecorate %17 4 RelaxedPrecision
OpDecorate %17 Block
OpDecorate %19 DescriptorSet 2
OpDecorate %19 Binding 0
OpMemberDecorate %23 0 BuiltIn Position
OpDecorate %23 Block
OpDecorate %28 RelaxedPrecision
OpDecorate %29 RelaxedPrecision
OpDecorate %31 RelaxedPrecision
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %35 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %44 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%9 = OpTypeStruct %2
%12 = OpTypeInt 32 0
%13 = OpTypeInt 32 1
%14 = OpTypeVector %13 4
%15 = OpTypeVector %12 4
%16 = OpTypeStruct %1 %1 %1 %1
%17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
%21 = OpConstant %12 8
%22 = OpTypeArray %1 %21
%23 = OpTypeStruct %2
%38 = OpTypeVoid
%45 = OpConstant %12 0
%58 = OpTypePointer Private %2
%3 = OpTypePointer Input %2
%59 = OpTypePointer Private %2
%7 = OpTypePointer Output %2
%10 = OpTypePointer Uniform %9
%18 = OpTypePointer Uniform %17
%24 = OpTypePointer Output %23
%26 = OpTypePointer Function %2
%46 = OpTypePointer Uniform %2
%27 = OpTypeFunction %2 %26
%39 = OpTypeFunction %38
%4 = OpVariable %3 Input
%5 = OpVariable %3 Input
%6 = OpVariable %3 Input
%8 = OpVariable %7 Output
%11 = OpVariable %10 Uniform
%19 = OpVariable %18 Uniform
%20 = OpVariable %59 Private
%25 = OpVariable %24 Output
%60 = OpConstant %13 0
%61 = OpConstant %1 0.5
%28 = OpFunction %2 None %27
%29 = OpFunctionParameter %26
%30 = OpLabel
%31 = OpLoad %2 %29
OpReturnValue %31
OpFunctionEnd
%32 = OpFunction %2 None %27
%33 = OpFunctionParameter %26
%34 = OpLabel
%35 = OpLoad %2 %33
%36 = OpLoad %2 %33
%37 = OpFAdd %2 %35 %36
OpReturnValue %37
OpFunctionEnd
%40 = OpFunction %38 None %39
%41 = OpLabel
%42 = OpVariable %26 Function
%50 = OpVariable %26 Function
%53 = OpVariable %26 Function
%43 = OpLoad %2 %4
OpStore %42 %43
%44 = OpFunctionCall %2 %28 %42
%47 = OpAccessChain %46 %11 %45
%48 = OpLoad %2 %47
%49 = OpFAdd %2 %44 %48
OpStore %8 %49
%51 = OpLoad %2 %5
OpStore %50 %51
%52 = OpFunctionCall %2 %32 %50
%54 = OpLoad %2 %6
OpStore %53 %54
%55 = OpFunctionCall %2 %28 %53
%56 = OpFAdd %2 %52 %55
%57 = OpAccessChain %7 %25 %45
OpStore %57 %56
%62 = OpAccessChain %7 %25 %60
%63 = OpLoad %2 %62
%64 = OpCompositeExtract %1 %63 0
%65 = OpCompositeExtract %1 %63 1
%66 = OpCompositeExtract %1 %63 2
%67 = OpCompositeExtract %1 %63 3
%69 = OpFNegate %1 %64
%70 = OpFAdd %1 %66 %67
%71 = OpFMul %1 %70 %61
%68 = OpCompositeConstruct %2 %65 %69 %71 %67
OpStore %62 %68
OpReturn
OpFunctionEnd
)";

TEST(DiffTest, DifferentDecorationsVertex) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 58
+; Bound: 73
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
-OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %20 %25
+OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %25
 OpSource GLSL 450
 OpName %4 "_ub"
 OpName %5 "_uc"
 OpName %6 "_ud"
 OpName %8 "_ue"
 OpName %9 "defaultUniformsVS"
 OpMemberName %9 0 "_ua"
 OpName %11 ""
 OpName %16 "ANGLEDepthRangeParams"
 OpMemberName %16 0 "near"
 OpMemberName %16 1 "far"
 OpMemberName %16 2 "diff"
 OpMemberName %16 3 "reserved"
 OpName %17 "ANGLEUniformBlock"
 OpMemberName %17 0 "viewport"
 OpMemberName %17 1 "clipDistancesEnabled"
 OpMemberName %17 2 "xfbActiveUnpaused"
 OpMemberName %17 3 "xfbVerticesPerInstance"
 OpMemberName %17 4 "numSamples"
 OpMemberName %17 5 "xfbBufferOffsets"
 OpMemberName %17 6 "acbBufferOffsets"
 OpMemberName %17 7 "depthRange"
 OpName %19 "ANGLEUniforms"
-OpName %20 "ANGLEXfbPosition"
 OpName %23 "gl_PerVertex"
 OpMemberName %23 0 "gl_Position"
-OpMemberName %23 1 "gl_PointSize"
-OpMemberName %23 2 "gl_ClipDistance"
-OpMemberName %23 3 "gl_CullDistance"
 OpName %25 ""
 OpName %29 "_ua"
 OpName %28 "_uf"
 OpName %33 "_uf"
 OpName %32 "_ug"
 OpName %40 "main"
 OpName %42 "param"
 OpName %50 "param"
 OpName %53 "param"
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
-OpDecorate %5 Location 1
+OpDecorate %5 Location 2
-OpDecorate %6 Location 2
+OpDecorate %6 Location 0
-OpDecorate %8 Location 0
+OpDecorate %8 Location 1
 OpMemberDecorate %9 0 Offset 0
 OpDecorate %9 Block
 OpDecorate %11 DescriptorSet 0
-OpDecorate %11 Binding 0
+OpDecorate %11 Binding 1
 OpMemberDecorate %16 0 Offset 0
 OpMemberDecorate %16 1 Offset 4
 OpMemberDecorate %16 2 Offset 8
 OpMemberDecorate %16 3 Offset 12
 OpMemberDecorate %17 0 Offset 0
 OpMemberDecorate %17 1 Offset 16
 OpMemberDecorate %17 2 Offset 20
 OpMemberDecorate %17 3 Offset 24
 OpMemberDecorate %17 4 Offset 28
 OpMemberDecorate %17 5 Offset 32
 OpMemberDecorate %17 6 Offset 48
 OpMemberDecorate %17 7 Offset 64
 OpMemberDecorate %17 2 RelaxedPrecision
 OpMemberDecorate %17 4 RelaxedPrecision
 OpDecorate %17 Block
-OpDecorate %19 DescriptorSet 0
+OpDecorate %19 DescriptorSet 2
-OpDecorate %19 Binding 1
+OpDecorate %19 Binding 0
-OpDecorate %20 Location 1
 OpMemberDecorate %23 0 BuiltIn Position
-OpMemberDecorate %23 1 BuiltIn PointSize
-OpMemberDecorate %23 2 BuiltIn ClipDistance
-OpMemberDecorate %23 3 BuiltIn CullDistance
 OpDecorate %23 Block
 OpDecorate %28 RelaxedPrecision
 OpDecorate %29 RelaxedPrecision
 OpDecorate %31 RelaxedPrecision
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %35 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %44 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %9 = OpTypeStruct %2
 %12 = OpTypeInt 32 0
 %13 = OpTypeInt 32 1
 %14 = OpTypeVector %13 4
 %15 = OpTypeVector %12 4
 %16 = OpTypeStruct %1 %1 %1 %1
 %17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
 %21 = OpConstant %12 8
 %22 = OpTypeArray %1 %21
-%23 = OpTypeStruct %2 %1 %22 %22
+%23 = OpTypeStruct %2
 %38 = OpTypeVoid
 %45 = OpConstant %12 0
+%59 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
+%60 = OpTypePointer Private %2
 %7 = OpTypePointer Output %2
 %10 = OpTypePointer Uniform %9
 %18 = OpTypePointer Uniform %17
 %24 = OpTypePointer Output %23
 %26 = OpTypePointer Function %2
 %46 = OpTypePointer Uniform %2
 %27 = OpTypeFunction %2 %26
 %39 = OpTypeFunction %38
 %4 = OpVariable %3 Input
 %5 = OpVariable %3 Input
 %6 = OpVariable %3 Input
 %8 = OpVariable %7 Output
 %11 = OpVariable %10 Uniform
 %19 = OpVariable %18 Uniform
-%20 = OpVariable %7 Output
+%58 = OpVariable %60 Private
 %25 = OpVariable %24 Output
+%61 = OpConstant %13 0
+%62 = OpConstant %1 0.5
 %28 = OpFunction %2 None %27
 %29 = OpFunctionParameter %26
 %30 = OpLabel
 %31 = OpLoad %2 %29
 OpReturnValue %31
 OpFunctionEnd
 %32 = OpFunction %2 None %27
 %33 = OpFunctionParameter %26
 %34 = OpLabel
 %35 = OpLoad %2 %33
 %36 = OpLoad %2 %33
 %37 = OpFAdd %2 %35 %36
 OpReturnValue %37
 OpFunctionEnd
 %40 = OpFunction %38 None %39
 %41 = OpLabel
 %42 = OpVariable %26 Function
 %50 = OpVariable %26 Function
 %53 = OpVariable %26 Function
 %43 = OpLoad %2 %4
 OpStore %42 %43
 %44 = OpFunctionCall %2 %28 %42
 %47 = OpAccessChain %46 %11 %45
 %48 = OpLoad %2 %47
 %49 = OpFAdd %2 %44 %48
 OpStore %8 %49
 %51 = OpLoad %2 %5
 OpStore %50 %51
 %52 = OpFunctionCall %2 %32 %50
 %54 = OpLoad %2 %6
 OpStore %53 %54
 %55 = OpFunctionCall %2 %28 %53
 %56 = OpFAdd %2 %52 %55
 %57 = OpAccessChain %7 %25 %45
 OpStore %57 %56
+%63 = OpAccessChain %7 %25 %61
+%64 = OpLoad %2 %63
+%65 = OpCompositeExtract %1 %64 0
+%66 = OpCompositeExtract %1 %64 1
+%67 = OpCompositeExtract %1 %64 2
+%68 = OpCompositeExtract %1 %64 3
+%70 = OpFNegate %1 %65
+%71 = OpFAdd %1 %67 %68
+%72 = OpFMul %1 %71 %62
+%69 = OpCompositeConstruct %2 %66 %70 %72 %68
+OpStore %63 %69
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, DifferentDecorationsVertexNoDebug) {
  constexpr char kSrcNoDebug[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %20 %25
OpSource GLSL 450
OpDecorate %4 Location 0
OpDecorate %5 Location 1
OpDecorate %6 Location 2
OpDecorate %8 Location 0
OpMemberDecorate %9 0 Offset 0
OpDecorate %9 Block
OpDecorate %11 DescriptorSet 0
OpDecorate %11 Binding 0
OpMemberDecorate %16 0 Offset 0
OpMemberDecorate %16 1 Offset 4
OpMemberDecorate %16 2 Offset 8
OpMemberDecorate %16 3 Offset 12
OpMemberDecorate %17 0 Offset 0
OpMemberDecorate %17 1 Offset 16
OpMemberDecorate %17 2 Offset 20
OpMemberDecorate %17 3 Offset 24
OpMemberDecorate %17 4 Offset 28
OpMemberDecorate %17 5 Offset 32
OpMemberDecorate %17 6 Offset 48
OpMemberDecorate %17 7 Offset 64
OpMemberDecorate %17 2 RelaxedPrecision
OpMemberDecorate %17 4 RelaxedPrecision
OpDecorate %17 Block
OpDecorate %19 DescriptorSet 0
OpDecorate %19 Binding 1
OpDecorate %20 Location 1
OpMemberDecorate %23 0 BuiltIn Position
OpMemberDecorate %23 1 BuiltIn PointSize
OpMemberDecorate %23 2 BuiltIn ClipDistance
OpMemberDecorate %23 3 BuiltIn CullDistance
OpDecorate %23 Block
OpDecorate %28 RelaxedPrecision
OpDecorate %29 RelaxedPrecision
OpDecorate %31 RelaxedPrecision
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %35 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %44 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%9 = OpTypeStruct %2
%12 = OpTypeInt 32 0
%13 = OpTypeInt 32 1
%14 = OpTypeVector %13 4
%15 = OpTypeVector %12 4
%16 = OpTypeStruct %1 %1 %1 %1
%17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
%21 = OpConstant %12 8
%22 = OpTypeArray %1 %21
%23 = OpTypeStruct %2 %1 %22 %22
%38 = OpTypeVoid
%45 = OpConstant %12 0
%3 = OpTypePointer Input %2
%7 = OpTypePointer Output %2
%10 = OpTypePointer Uniform %9
%18 = OpTypePointer Uniform %17
%24 = OpTypePointer Output %23
%26 = OpTypePointer Function %2
%46 = OpTypePointer Uniform %2
%27 = OpTypeFunction %2 %26
%39 = OpTypeFunction %38
%4 = OpVariable %3 Input
%5 = OpVariable %3 Input
%6 = OpVariable %3 Input
%8 = OpVariable %7 Output
%11 = OpVariable %10 Uniform
%19 = OpVariable %18 Uniform
%20 = OpVariable %7 Output
%25 = OpVariable %24 Output
%28 = OpFunction %2 None %27
%29 = OpFunctionParameter %26
%30 = OpLabel
%31 = OpLoad %2 %29
OpReturnValue %31
OpFunctionEnd
%32 = OpFunction %2 None %27
%33 = OpFunctionParameter %26
%34 = OpLabel
%35 = OpLoad %2 %33
%36 = OpLoad %2 %33
%37 = OpFAdd %2 %35 %36
OpReturnValue %37
OpFunctionEnd
%40 = OpFunction %38 None %39
%41 = OpLabel
%42 = OpVariable %26 Function
%50 = OpVariable %26 Function
%53 = OpVariable %26 Function
%43 = OpLoad %2 %4
OpStore %42 %43
%44 = OpFunctionCall %2 %28 %42
%47 = OpAccessChain %46 %11 %45
%48 = OpLoad %2 %47
%49 = OpFAdd %2 %44 %48
OpStore %8 %49
%51 = OpLoad %2 %5
OpStore %50 %51
%52 = OpFunctionCall %2 %32 %50
%54 = OpLoad %2 %6
OpStore %53 %54
%55 = OpFunctionCall %2 %28 %53
%56 = OpFAdd %2 %52 %55
%57 = OpAccessChain %7 %25 %45
OpStore %57 %56
OpReturn
OpFunctionEnd

)";
  constexpr char kDstNoDebug[] = R"(OpCapability Shader
OpMemoryModel Logical GLSL450
OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %25
OpSource GLSL 450
OpDecorate %4 Location 1
OpDecorate %5 Location 2
OpDecorate %6 Location 0
OpDecorate %8 Location 1
OpMemberDecorate %9 0 Offset 0
OpDecorate %9 Block
OpDecorate %11 DescriptorSet 0
OpDecorate %11 Binding 1
OpMemberDecorate %16 0 Offset 0
OpMemberDecorate %16 1 Offset 4
OpMemberDecorate %16 2 Offset 8
OpMemberDecorate %16 3 Offset 12
OpMemberDecorate %17 0 Offset 0
OpMemberDecorate %17 1 Offset 16
OpMemberDecorate %17 2 Offset 20
OpMemberDecorate %17 3 Offset 24
OpMemberDecorate %17 4 Offset 28
OpMemberDecorate %17 5 Offset 32
OpMemberDecorate %17 6 Offset 48
OpMemberDecorate %17 7 Offset 64
OpMemberDecorate %17 2 RelaxedPrecision
OpMemberDecorate %17 4 RelaxedPrecision
OpDecorate %17 Block
OpDecorate %19 DescriptorSet 2
OpDecorate %19 Binding 0
OpMemberDecorate %23 0 BuiltIn Position
OpDecorate %23 Block
OpDecorate %28 RelaxedPrecision
OpDecorate %29 RelaxedPrecision
OpDecorate %31 RelaxedPrecision
OpDecorate %32 RelaxedPrecision
OpDecorate %33 RelaxedPrecision
OpDecorate %35 RelaxedPrecision
OpDecorate %36 RelaxedPrecision
OpDecorate %37 RelaxedPrecision
OpDecorate %44 RelaxedPrecision
OpDecorate %52 RelaxedPrecision
OpDecorate %55 RelaxedPrecision
OpDecorate %56 RelaxedPrecision
%1 = OpTypeFloat 32
%2 = OpTypeVector %1 4
%9 = OpTypeStruct %2
%12 = OpTypeInt 32 0
%13 = OpTypeInt 32 1
%14 = OpTypeVector %13 4
%15 = OpTypeVector %12 4
%16 = OpTypeStruct %1 %1 %1 %1
%17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
%21 = OpConstant %12 8
%22 = OpTypeArray %1 %21
%23 = OpTypeStruct %2
%38 = OpTypeVoid
%45 = OpConstant %12 0
%58 = OpTypePointer Private %2
%3 = OpTypePointer Input %2
%59 = OpTypePointer Private %2
%7 = OpTypePointer Output %2
%10 = OpTypePointer Uniform %9
%18 = OpTypePointer Uniform %17
%24 = OpTypePointer Output %23
%26 = OpTypePointer Function %2
%46 = OpTypePointer Uniform %2
%27 = OpTypeFunction %2 %26
%39 = OpTypeFunction %38
%4 = OpVariable %3 Input
%5 = OpVariable %3 Input
%6 = OpVariable %3 Input
%8 = OpVariable %7 Output
%11 = OpVariable %10 Uniform
%19 = OpVariable %18 Uniform
%20 = OpVariable %59 Private
%25 = OpVariable %24 Output
%60 = OpConstant %13 0
%61 = OpConstant %1 0.5
%28 = OpFunction %2 None %27
%29 = OpFunctionParameter %26
%30 = OpLabel
%31 = OpLoad %2 %29
OpReturnValue %31
OpFunctionEnd
%32 = OpFunction %2 None %27
%33 = OpFunctionParameter %26
%34 = OpLabel
%35 = OpLoad %2 %33
%36 = OpLoad %2 %33
%37 = OpFAdd %2 %35 %36
OpReturnValue %37
OpFunctionEnd
%40 = OpFunction %38 None %39
%41 = OpLabel
%42 = OpVariable %26 Function
%50 = OpVariable %26 Function
%53 = OpVariable %26 Function
%43 = OpLoad %2 %4
OpStore %42 %43
%44 = OpFunctionCall %2 %28 %42
%47 = OpAccessChain %46 %11 %45
%48 = OpLoad %2 %47
%49 = OpFAdd %2 %44 %48
OpStore %8 %49
%51 = OpLoad %2 %5
OpStore %50 %51
%52 = OpFunctionCall %2 %32 %50
%54 = OpLoad %2 %6
OpStore %53 %54
%55 = OpFunctionCall %2 %28 %53
%56 = OpFAdd %2 %52 %55
%57 = OpAccessChain %7 %25 %45
OpStore %57 %56
%62 = OpAccessChain %7 %25 %60
%63 = OpLoad %2 %62
%64 = OpCompositeExtract %1 %63 0
%65 = OpCompositeExtract %1 %63 1
%66 = OpCompositeExtract %1 %63 2
%67 = OpCompositeExtract %1 %63 3
%69 = OpFNegate %1 %64
%70 = OpFAdd %1 %66 %67
%71 = OpFMul %1 %70 %61
%68 = OpCompositeConstruct %2 %65 %69 %71 %67
OpStore %62 %68
OpReturn
OpFunctionEnd
)";
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 58
+; Bound: 77
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
-OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %20 %25
+OpEntryPoint Vertex %40 "main" %5 %6 %4 %20 %25
 OpSource GLSL 450
 OpDecorate %4 Location 0
 OpDecorate %5 Location 1
 OpDecorate %6 Location 2
-OpDecorate %8 Location 0
 OpMemberDecorate %9 0 Offset 0
 OpDecorate %9 Block
-OpDecorate %11 DescriptorSet 0
+OpDecorate %11 DescriptorSet 2
 OpDecorate %11 Binding 0
 OpMemberDecorate %16 0 Offset 0
 OpMemberDecorate %16 1 Offset 4
 OpMemberDecorate %16 2 Offset 8
 OpMemberDecorate %16 3 Offset 12
 OpMemberDecorate %17 0 Offset 0
 OpMemberDecorate %17 1 Offset 16
 OpMemberDecorate %17 2 Offset 20
 OpMemberDecorate %17 3 Offset 24
 OpMemberDecorate %17 4 Offset 28
 OpMemberDecorate %17 5 Offset 32
 OpMemberDecorate %17 6 Offset 48
 OpMemberDecorate %17 7 Offset 64
 OpMemberDecorate %17 2 RelaxedPrecision
 OpMemberDecorate %17 4 RelaxedPrecision
 OpDecorate %17 Block
 OpDecorate %19 DescriptorSet 0
 OpDecorate %19 Binding 1
 OpDecorate %20 Location 1
 OpMemberDecorate %23 0 BuiltIn Position
-OpMemberDecorate %23 1 BuiltIn PointSize
-OpMemberDecorate %23 2 BuiltIn ClipDistance
-OpMemberDecorate %23 3 BuiltIn CullDistance
 OpDecorate %23 Block
 OpDecorate %28 RelaxedPrecision
 OpDecorate %29 RelaxedPrecision
 OpDecorate %31 RelaxedPrecision
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %35 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %44 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %9 = OpTypeStruct %2
 %12 = OpTypeInt 32 0
 %13 = OpTypeInt 32 1
 %14 = OpTypeVector %13 4
 %15 = OpTypeVector %12 4
 %16 = OpTypeStruct %1 %1 %1 %1
 %17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
 %21 = OpConstant %12 8
 %22 = OpTypeArray %1 %21
-%23 = OpTypeStruct %2 %1 %22 %22
+%23 = OpTypeStruct %2
 %38 = OpTypeVoid
 %45 = OpConstant %12 0
+%63 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
+%64 = OpTypePointer Private %2
 %7 = OpTypePointer Output %2
 %10 = OpTypePointer Uniform %9
 %18 = OpTypePointer Uniform %17
 %24 = OpTypePointer Output %23
 %26 = OpTypePointer Function %2
 %46 = OpTypePointer Uniform %2
 %27 = OpTypeFunction %2 %26
 %39 = OpTypeFunction %38
 %4 = OpVariable %3 Input
 %5 = OpVariable %3 Input
 %6 = OpVariable %3 Input
-%8 = OpVariable %7 Output
-%11 = OpVariable %10 Uniform
+%11 = OpVariable %18 Uniform
-%19 = OpVariable %18 Uniform
+%19 = OpVariable %10 Uniform
 %20 = OpVariable %7 Output
+%58 = OpVariable %64 Private
 %25 = OpVariable %24 Output
+%65 = OpConstant %13 0
+%66 = OpConstant %1 0.5
 %28 = OpFunction %2 None %27
 %29 = OpFunctionParameter %26
 %30 = OpLabel
 %31 = OpLoad %2 %29
 OpReturnValue %31
 OpFunctionEnd
 %32 = OpFunction %2 None %27
 %33 = OpFunctionParameter %26
 %34 = OpLabel
 %35 = OpLoad %2 %33
 %36 = OpLoad %2 %33
 %37 = OpFAdd %2 %35 %36
 OpReturnValue %37
 OpFunctionEnd
 %40 = OpFunction %38 None %39
 %41 = OpLabel
 %42 = OpVariable %26 Function
 %50 = OpVariable %26 Function
 %53 = OpVariable %26 Function
-%43 = OpLoad %2 %4
+%59 = OpLoad %2 %5
-OpStore %42 %43
+OpStore %42 %59
 %44 = OpFunctionCall %2 %28 %42
-%47 = OpAccessChain %46 %11 %45
+%60 = OpAccessChain %46 %19 %45
-%48 = OpLoad %2 %47
+%48 = OpLoad %2 %60
 %49 = OpFAdd %2 %44 %48
-OpStore %8 %49
+OpStore %20 %49
-%51 = OpLoad %2 %5
+%61 = OpLoad %2 %6
-OpStore %50 %51
+OpStore %50 %61
 %52 = OpFunctionCall %2 %32 %50
-%54 = OpLoad %2 %6
+%62 = OpLoad %2 %4
-OpStore %53 %54
+OpStore %53 %62
 %55 = OpFunctionCall %2 %28 %53
 %56 = OpFAdd %2 %52 %55
 %57 = OpAccessChain %7 %25 %45
 OpStore %57 %56
+%67 = OpAccessChain %7 %25 %65
+%68 = OpLoad %2 %67
+%69 = OpCompositeExtract %1 %68 0
+%70 = OpCompositeExtract %1 %68 1
+%71 = OpCompositeExtract %1 %68 2
+%72 = OpCompositeExtract %1 %68 3
+%74 = OpFNegate %1 %69
+%75 = OpFAdd %1 %71 %72
+%76 = OpFMul %1 %75 %66
+%73 = OpCompositeConstruct %2 %70 %74 %76 %72
+OpStore %67 %73
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrcNoDebug, kDstNoDebug, kDiff, options);
}

TEST(DiffTest, DifferentDecorationsVertexIgnoreSetBinding) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 58
+; Bound: 73
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
-OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %20 %25
+OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %25
 OpSource GLSL 450
 OpName %4 "_ub"
 OpName %5 "_uc"
 OpName %6 "_ud"
 OpName %8 "_ue"
 OpName %9 "defaultUniformsVS"
 OpMemberName %9 0 "_ua"
 OpName %11 ""
 OpName %16 "ANGLEDepthRangeParams"
 OpMemberName %16 0 "near"
 OpMemberName %16 1 "far"
 OpMemberName %16 2 "diff"
 OpMemberName %16 3 "reserved"
 OpName %17 "ANGLEUniformBlock"
 OpMemberName %17 0 "viewport"
 OpMemberName %17 1 "clipDistancesEnabled"
 OpMemberName %17 2 "xfbActiveUnpaused"
 OpMemberName %17 3 "xfbVerticesPerInstance"
 OpMemberName %17 4 "numSamples"
 OpMemberName %17 5 "xfbBufferOffsets"
 OpMemberName %17 6 "acbBufferOffsets"
 OpMemberName %17 7 "depthRange"
 OpName %19 "ANGLEUniforms"
-OpName %20 "ANGLEXfbPosition"
 OpName %23 "gl_PerVertex"
 OpMemberName %23 0 "gl_Position"
-OpMemberName %23 1 "gl_PointSize"
-OpMemberName %23 2 "gl_ClipDistance"
-OpMemberName %23 3 "gl_CullDistance"
 OpName %25 ""
 OpName %29 "_ua"
 OpName %28 "_uf"
 OpName %33 "_uf"
 OpName %32 "_ug"
 OpName %40 "main"
 OpName %42 "param"
 OpName %50 "param"
 OpName %53 "param"
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
-OpDecorate %5 Location 1
+OpDecorate %5 Location 2
-OpDecorate %6 Location 2
+OpDecorate %6 Location 0
-OpDecorate %8 Location 0
+OpDecorate %8 Location 1
 OpMemberDecorate %9 0 Offset 0
 OpDecorate %9 Block
 OpDecorate %11 DescriptorSet 0
-OpDecorate %11 Binding 0
+OpDecorate %11 Binding 1
 OpMemberDecorate %16 0 Offset 0
 OpMemberDecorate %16 1 Offset 4
 OpMemberDecorate %16 2 Offset 8
 OpMemberDecorate %16 3 Offset 12
 OpMemberDecorate %17 0 Offset 0
 OpMemberDecorate %17 1 Offset 16
 OpMemberDecorate %17 2 Offset 20
 OpMemberDecorate %17 3 Offset 24
 OpMemberDecorate %17 4 Offset 28
 OpMemberDecorate %17 5 Offset 32
 OpMemberDecorate %17 6 Offset 48
 OpMemberDecorate %17 7 Offset 64
 OpMemberDecorate %17 2 RelaxedPrecision
 OpMemberDecorate %17 4 RelaxedPrecision
 OpDecorate %17 Block
-OpDecorate %19 DescriptorSet 0
+OpDecorate %19 DescriptorSet 2
-OpDecorate %19 Binding 1
+OpDecorate %19 Binding 0
-OpDecorate %20 Location 1
 OpMemberDecorate %23 0 BuiltIn Position
-OpMemberDecorate %23 1 BuiltIn PointSize
-OpMemberDecorate %23 2 BuiltIn ClipDistance
-OpMemberDecorate %23 3 BuiltIn CullDistance
 OpDecorate %23 Block
 OpDecorate %28 RelaxedPrecision
 OpDecorate %29 RelaxedPrecision
 OpDecorate %31 RelaxedPrecision
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %35 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %44 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %9 = OpTypeStruct %2
 %12 = OpTypeInt 32 0
 %13 = OpTypeInt 32 1
 %14 = OpTypeVector %13 4
 %15 = OpTypeVector %12 4
 %16 = OpTypeStruct %1 %1 %1 %1
 %17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
 %21 = OpConstant %12 8
 %22 = OpTypeArray %1 %21
-%23 = OpTypeStruct %2 %1 %22 %22
+%23 = OpTypeStruct %2
 %38 = OpTypeVoid
 %45 = OpConstant %12 0
+%59 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
+%60 = OpTypePointer Private %2
 %7 = OpTypePointer Output %2
 %10 = OpTypePointer Uniform %9
 %18 = OpTypePointer Uniform %17
 %24 = OpTypePointer Output %23
 %26 = OpTypePointer Function %2
 %46 = OpTypePointer Uniform %2
 %27 = OpTypeFunction %2 %26
 %39 = OpTypeFunction %38
 %4 = OpVariable %3 Input
 %5 = OpVariable %3 Input
 %6 = OpVariable %3 Input
 %8 = OpVariable %7 Output
 %11 = OpVariable %10 Uniform
 %19 = OpVariable %18 Uniform
-%20 = OpVariable %7 Output
+%58 = OpVariable %60 Private
 %25 = OpVariable %24 Output
+%61 = OpConstant %13 0
+%62 = OpConstant %1 0.5
 %28 = OpFunction %2 None %27
 %29 = OpFunctionParameter %26
 %30 = OpLabel
 %31 = OpLoad %2 %29
 OpReturnValue %31
 OpFunctionEnd
 %32 = OpFunction %2 None %27
 %33 = OpFunctionParameter %26
 %34 = OpLabel
 %35 = OpLoad %2 %33
 %36 = OpLoad %2 %33
 %37 = OpFAdd %2 %35 %36
 OpReturnValue %37
 OpFunctionEnd
 %40 = OpFunction %38 None %39
 %41 = OpLabel
 %42 = OpVariable %26 Function
 %50 = OpVariable %26 Function
 %53 = OpVariable %26 Function
 %43 = OpLoad %2 %4
 OpStore %42 %43
 %44 = OpFunctionCall %2 %28 %42
 %47 = OpAccessChain %46 %11 %45
 %48 = OpLoad %2 %47
 %49 = OpFAdd %2 %44 %48
 OpStore %8 %49
 %51 = OpLoad %2 %5
 OpStore %50 %51
 %52 = OpFunctionCall %2 %32 %50
 %54 = OpLoad %2 %6
 OpStore %53 %54
 %55 = OpFunctionCall %2 %28 %53
 %56 = OpFAdd %2 %52 %55
 %57 = OpAccessChain %7 %25 %45
 OpStore %57 %56
+%63 = OpAccessChain %7 %25 %61
+%64 = OpLoad %2 %63
+%65 = OpCompositeExtract %1 %64 0
+%66 = OpCompositeExtract %1 %64 1
+%67 = OpCompositeExtract %1 %64 2
+%68 = OpCompositeExtract %1 %64 3
+%70 = OpFNegate %1 %65
+%71 = OpFAdd %1 %67 %68
+%72 = OpFMul %1 %71 %62
+%69 = OpCompositeConstruct %2 %66 %70 %72 %68
+OpStore %63 %69
 OpReturn
 OpFunctionEnd
)";
  Options options;
  options.ignore_set_binding = true;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, DifferentDecorationsVertexIgnoreSetBindingLocation) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 58
+; Bound: 73
 ; Schema: 0
 OpCapability Shader
 OpMemoryModel Logical GLSL450
-OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %20 %25
+OpEntryPoint Vertex %40 "main" %4 %5 %6 %8 %25
 OpSource GLSL 450
 OpName %4 "_ub"
 OpName %5 "_uc"
 OpName %6 "_ud"
 OpName %8 "_ue"
 OpName %9 "defaultUniformsVS"
 OpMemberName %9 0 "_ua"
 OpName %11 ""
 OpName %16 "ANGLEDepthRangeParams"
 OpMemberName %16 0 "near"
 OpMemberName %16 1 "far"
 OpMemberName %16 2 "diff"
 OpMemberName %16 3 "reserved"
 OpName %17 "ANGLEUniformBlock"
 OpMemberName %17 0 "viewport"
 OpMemberName %17 1 "clipDistancesEnabled"
 OpMemberName %17 2 "xfbActiveUnpaused"
 OpMemberName %17 3 "xfbVerticesPerInstance"
 OpMemberName %17 4 "numSamples"
 OpMemberName %17 5 "xfbBufferOffsets"
 OpMemberName %17 6 "acbBufferOffsets"
 OpMemberName %17 7 "depthRange"
 OpName %19 "ANGLEUniforms"
-OpName %20 "ANGLEXfbPosition"
 OpName %23 "gl_PerVertex"
 OpMemberName %23 0 "gl_Position"
-OpMemberName %23 1 "gl_PointSize"
-OpMemberName %23 2 "gl_ClipDistance"
-OpMemberName %23 3 "gl_CullDistance"
 OpName %25 ""
 OpName %29 "_ua"
 OpName %28 "_uf"
 OpName %33 "_uf"
 OpName %32 "_ug"
 OpName %40 "main"
 OpName %42 "param"
 OpName %50 "param"
 OpName %53 "param"
-OpDecorate %4 Location 0
+OpDecorate %4 Location 1
-OpDecorate %5 Location 1
+OpDecorate %5 Location 2
-OpDecorate %6 Location 2
+OpDecorate %6 Location 0
-OpDecorate %8 Location 0
+OpDecorate %8 Location 1
 OpMemberDecorate %9 0 Offset 0
 OpDecorate %9 Block
 OpDecorate %11 DescriptorSet 0
-OpDecorate %11 Binding 0
+OpDecorate %11 Binding 1
 OpMemberDecorate %16 0 Offset 0
 OpMemberDecorate %16 1 Offset 4
 OpMemberDecorate %16 2 Offset 8
 OpMemberDecorate %16 3 Offset 12
 OpMemberDecorate %17 0 Offset 0
 OpMemberDecorate %17 1 Offset 16
 OpMemberDecorate %17 2 Offset 20
 OpMemberDecorate %17 3 Offset 24
 OpMemberDecorate %17 4 Offset 28
 OpMemberDecorate %17 5 Offset 32
 OpMemberDecorate %17 6 Offset 48
 OpMemberDecorate %17 7 Offset 64
 OpMemberDecorate %17 2 RelaxedPrecision
 OpMemberDecorate %17 4 RelaxedPrecision
 OpDecorate %17 Block
-OpDecorate %19 DescriptorSet 0
+OpDecorate %19 DescriptorSet 2
-OpDecorate %19 Binding 1
+OpDecorate %19 Binding 0
-OpDecorate %20 Location 1
 OpMemberDecorate %23 0 BuiltIn Position
-OpMemberDecorate %23 1 BuiltIn PointSize
-OpMemberDecorate %23 2 BuiltIn ClipDistance
-OpMemberDecorate %23 3 BuiltIn CullDistance
 OpDecorate %23 Block
 OpDecorate %28 RelaxedPrecision
 OpDecorate %29 RelaxedPrecision
 OpDecorate %31 RelaxedPrecision
 OpDecorate %32 RelaxedPrecision
 OpDecorate %33 RelaxedPrecision
 OpDecorate %35 RelaxedPrecision
 OpDecorate %36 RelaxedPrecision
 OpDecorate %37 RelaxedPrecision
 OpDecorate %44 RelaxedPrecision
 OpDecorate %52 RelaxedPrecision
 OpDecorate %55 RelaxedPrecision
 OpDecorate %56 RelaxedPrecision
 %1 = OpTypeFloat 32
 %2 = OpTypeVector %1 4
 %9 = OpTypeStruct %2
 %12 = OpTypeInt 32 0
 %13 = OpTypeInt 32 1
 %14 = OpTypeVector %13 4
 %15 = OpTypeVector %12 4
 %16 = OpTypeStruct %1 %1 %1 %1
 %17 = OpTypeStruct %2 %12 %12 %13 %13 %14 %15 %16
 %21 = OpConstant %12 8
 %22 = OpTypeArray %1 %21
-%23 = OpTypeStruct %2 %1 %22 %22
+%23 = OpTypeStruct %2
 %38 = OpTypeVoid
 %45 = OpConstant %12 0
+%59 = OpTypePointer Private %2
 %3 = OpTypePointer Input %2
+%60 = OpTypePointer Private %2
 %7 = OpTypePointer Output %2
 %10 = OpTypePointer Uniform %9
 %18 = OpTypePointer Uniform %17
 %24 = OpTypePointer Output %23
 %26 = OpTypePointer Function %2
 %46 = OpTypePointer Uniform %2
 %27 = OpTypeFunction %2 %26
 %39 = OpTypeFunction %38
 %4 = OpVariable %3 Input
 %5 = OpVariable %3 Input
 %6 = OpVariable %3 Input
 %8 = OpVariable %7 Output
 %11 = OpVariable %10 Uniform
 %19 = OpVariable %18 Uniform
-%20 = OpVariable %7 Output
+%58 = OpVariable %60 Private
 %25 = OpVariable %24 Output
+%61 = OpConstant %13 0
+%62 = OpConstant %1 0.5
 %28 = OpFunction %2 None %27
 %29 = OpFunctionParameter %26
 %30 = OpLabel
 %31 = OpLoad %2 %29
 OpReturnValue %31
 OpFunctionEnd
 %32 = OpFunction %2 None %27
 %33 = OpFunctionParameter %26
 %34 = OpLabel
 %35 = OpLoad %2 %33
 %36 = OpLoad %2 %33
 %37 = OpFAdd %2 %35 %36
 OpReturnValue %37
 OpFunctionEnd
 %40 = OpFunction %38 None %39
 %41 = OpLabel
 %42 = OpVariable %26 Function
 %50 = OpVariable %26 Function
 %53 = OpVariable %26 Function
 %43 = OpLoad %2 %4
 OpStore %42 %43
 %44 = OpFunctionCall %2 %28 %42
 %47 = OpAccessChain %46 %11 %45
 %48 = OpLoad %2 %47
 %49 = OpFAdd %2 %44 %48
 OpStore %8 %49
 %51 = OpLoad %2 %5
 OpStore %50 %51
 %52 = OpFunctionCall %2 %32 %50
 %54 = OpLoad %2 %6
 OpStore %53 %54
 %55 = OpFunctionCall %2 %28 %53
 %56 = OpFAdd %2 %52 %55
 %57 = OpAccessChain %7 %25 %45
 OpStore %57 %56
+%63 = OpAccessChain %7 %25 %61
+%64 = OpLoad %2 %63
+%65 = OpCompositeExtract %1 %64 0
+%66 = OpCompositeExtract %1 %64 1
+%67 = OpCompositeExtract %1 %64 2
+%68 = OpCompositeExtract %1 %64 3
+%70 = OpFNegate %1 %65
+%71 = OpFAdd %1 %67 %68
+%72 = OpFMul %1 %71 %62
+%69 = OpCompositeConstruct %2 %66 %70 %72 %68
+OpStore %63 %69
 OpReturn
 OpFunctionEnd
)";
  Options options;
  options.ignore_set_binding = true;
  options.ignore_location = true;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

}  // namespace
}  // namespace diff
}  // namespace spvtools
