/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

/**
 * The context in which the evaluate request is used.
 * <p>
 * Possible values include - but not limited to those defined in {@link EvaluateArgumentsContext}
 */
@SuppressWarnings("all")
public interface EvaluateArgumentsContext {
  /**
   * evaluate is called from a watch view context.
   */
  static final String WATCH = "watch";

  /**
   * evaluate is called from a REPL context.
   */
  static final String REPL = "repl";

  /**
   * evaluate is called to generate the debug hover contents.
   * This value should only be used if the corresponding capability
   * {@link Capabilities#getSupportsEvaluateForHovers} is true.
   */
  static final String HOVER = "hover";

  /**
   * evaluate is called to generate clipboard contents.
   * This value should only be used if the corresponding capability
   * {@link Capabilities#getSupportsClipboardContext} is true.
   */
  static final String CLIPBOARD = "clipboard";

  /**
   * evaluate is called from a variables view context.
   * <p>
   * Since 1.55
   */
  static final String VARIABLES = "variables";
}
