### Projecting inline documentation impl

So, there are four different ways to implement inline documentation now.

1. Use the IDEA platform-only implementation. Java and Kotlin implement it this way. It works fine for languages that have the full
frontend PSI. Technical name: *frontend-only*.

2. Use the RDCT fully backend-delegating implementation. It works like a charm in the RDCT thin client scenarios, where all language
processing is done on a remote server somewhere in the cloud. Technical name: *frontend-backend*.

3. The RIDER and CLION NOVA ways. Here, we reuse the RDCT models, but the ultimate goal is different: we want *adaptive* implementations.
We have some languages that the frontend (the platform) has authority over, and then some languages that are backend-enabled.
The authority over the backend-enabled languages is shared between the platform and the backend (R#/R#Cpp), and hence there might be many 
ways to implement a language feature (such as inline documentation) across them.

    One of those ways is to *project* the R#/R#Cpp inline documentation directly from the backend to the platform. The other one is to *mix* the 
texts generated by the platform and the R#/R#Cpp. The implementations are spread out between here (the platform module) and RIDER, since 
CLION NOVA only imports the platform and RD modules, leaving the RIDER stuff out.