/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.IJModuleModel;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.java.JpsBuildFileProvider;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J4\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0014\u0010\u000e\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u001e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000b2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/packageChecker/java/IntellijModuleProjectDependenciesModel;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/java/IJModuleModel;", "Lcom/intellij/openapi/project/ModuleListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modulesAdded", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "modulesRenamed", "oldNameProvider", "Lcom/intellij/util/Function;", "", "createModule", "module", "collectDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "moduleRemoved", "copyModule", "newDependencies", "", "getAllModules", "supports", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nIntellijModuleProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijModuleProjectDependenciesModel.kt\ncom/intellij/packageChecker/java/IntellijModuleProjectDependenciesModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n3829#2:134\n4344#2,2:135\n12637#2,2:141\n1563#3:137\n1634#3,3:138\n*S KotlinDebug\n*F\n+ 1 IntellijModuleProjectDependenciesModel.kt\ncom/intellij/packageChecker/java/IntellijModuleProjectDependenciesModel\n*L\n92#1:134\n92#1:135,2\n102#1:141,2\n94#1:137\n94#1:138,3\n*E\n"})
public final class IntellijModuleProjectDependenciesModel
extends ProjectDependenciesModelBase<IJModuleModel>
implements ModuleListener {
    @NotNull
    private final Project project;

    public IntellijModuleProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = IntellijModuleProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        this.init();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
    }

    public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        for (Module module : modules) {
            if (!this.supports(module)) continue;
            IJModuleModel module2 = this.createModule(module);
            this.addModule((MutableModuleModel)module2);
        }
    }

    public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
        this.refresh();
    }

    private final IJModuleModel createModule(Module module) {
        Set<Dependency> dependencies = this.collectDependencies(module);
        return new IJModuleModel(module.getName() + " IJ module", module, dependencies, this.project);
    }

    private final Set<Dependency> collectDependencies(Module module) {
        Set set;
        if (module.isDisposed()) {
            return SetsKt.emptySet();
        }
        Set $this$collectDependencies_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> IntellijModuleProjectDependenciesModel.collectDependencies$lambda$2$lambda$1(arg_0 -> IntellijModuleProjectDependenciesModel.collectDependencies$lambda$2$lambda$0(this, $this$collectDependencies_u24lambda_u242, module, arg_0), arg_0));
        return SetsKt.build((Set)set);
    }

    public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.refresh();
    }

    @Override
    @NotNull
    protected IJModuleModel copyModule(@NotNull IJModuleModel module, @NotNull Iterable<? extends Dependency> newDependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(newDependencies, (String)"newDependencies");
        return new IJModuleModel(module.getId(), module.getPlatformModule(), CollectionsKt.toSet(newDependencies), this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<IJModuleModel> getAllModules() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this.project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Module element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!this.supports((Module)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module element$iv$iv;
            element$iv$iv = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createModule((Module)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Module[] $this$any$iv = ModuleManager.Companion.getInstance(project).getModules();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Module element$iv;
                Module it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!this.supports(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).supports(module);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project)).declaredDependencies(psiFile);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                JpsBuildFileProvider jpsFileProvider = (JpsBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(JpsBuildFileProvider.class, (AreaInstance)this.project);
                object = jpsFileProvider.moduleScript(module);
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                List<PackageDeclaration> list = jpsFileProvider.declaredPackages(it, module);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean collectDependencies$lambda$2$lambda$0(IntellijModuleProjectDependenciesModel this$0, Set $this_buildSet, Module $module, Library library) {
        Intrinsics.checkNotNull((Object)library);
        Package package_ = JavaPackageUtilKt.createPackage(library, this$0.project);
        if (package_ == null) {
            return true;
        }
        Package pkg = package_;
        return $this_buildSet.add(new Dependency(pkg, SetsKt.emptySet(), new DependencyContext(this$0.project, $module, null, library, null, 16, null)));
    }

    private static final boolean collectDependencies$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

