/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection.fix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.toolwindow.dialog.IgnoreVulnerabilitiesDialog;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/packageChecker/inspection/fix/IgnoreDependencyQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pkg", "Lcom/intellij/packageChecker/model/Package;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/packageChecker/model/Package;Lcom/intellij/openapi/module/Module;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.packageChecker"})
public final class IgnoreDependencyQuickFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Package pkg;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Module module;

    public IgnoreDependencyQuickFix(@NotNull Package pkg, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.pkg = pkg;
        this.module = module;
    }

    @NotNull
    public String getFamilyName() {
        String string = PackageCheckerBundle.message("ignoreVulnerabilities.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.PROJECT_MODEL);
        String string = this.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        new IgnoreVulnerabilitiesDialog(project, this.pkg, string).show();
    }
}

