/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.variables.introspect;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.variables.introspect.JupyterIntrospectionManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\nH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/variables/introspect/JupyterIntrospectionPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "text", "", "<init>", "(Ljava/lang/String;)V", "scrollPane", "Ljavax/swing/JScrollPane;", "showIntrospectionInfo", "", "scrollToStart", "createContent", "Lcom/intellij/ui/content/Content;", "dispose", "intellij.jupyter.core"})
final class JupyterIntrospectionPanel
extends SimpleToolWindowPanel
implements Disposable {
    @Nullable
    private JScrollPane scrollPane;

    public JupyterIntrospectionPanel(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(false);
        this.showIntrospectionInfo(text);
    }

    public final void showIntrospectionInfo(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.removeAll();
        JBTextArea initLabel = new JBTextArea();
        initLabel.setText(JupyterIntrospectionManagerKt.reformatIntrospectionText(text));
        initLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 0));
        initLabel.setEditable(false);
        this.scrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)initLabel), (boolean)true);
        this.add(this.scrollPane);
        this.repaint();
    }

    public final void scrollToStart() {
        block0: {
            JComponent jComponent = this.scrollPane;
            if (jComponent == null || (jComponent = ((JScrollPane)jComponent).getVerticalScrollBar()) == null) break block0;
            ((JScrollBar)jComponent).setValue(0);
        }
    }

    @NotNull
    public final Content createContent() {
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content = contentFactory.createContent((JComponent)((Object)this), JupyterBundle.message("jupyter.introspection", new Object[0]), true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setComponent((JComponent)((Object)this));
        content2.setShouldDisposeContent(true);
        Disposer.register((Disposable)this, (Disposable)((Disposable)content2));
        return content2;
    }

    public void dispose() {
    }
}

