/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.jupyter.editor.JupyterEditorInitializationFlagKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.editor.Editor;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"selectAllCellsInCommandMode", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
public final class JupyterSelectAllCellsActionHandlerKt {
    public static final boolean selectAllCellsInCommandMode(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!JupyterEditorInitializationFlagKt.isJupyterInitialized(editor) || NotebookEditorModeKt.getCurrentMode((Editor)editor) != NotebookEditorMode.COMMAND) {
            return false;
        }
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor);
        if (notebookCellSelectionModel == null) {
            return false;
        }
        NotebookCellSelectionModel model = notebookCellSelectionModel;
        Set selectedNow = CollectionsKt.toSet((Iterable)model.getSelectedCells());
        for (NotebookCellLines.Interval cell : NotebookCellLines.Companion.get(editor).getIntervals()) {
            if (selectedNow.contains(cell)) continue;
            NotebookCellSelectionModel.selectCell$default((NotebookCellSelectionModel)model, (NotebookCellLines.Interval)cell, (boolean)false, (int)2, null);
        }
        return true;
    }
}

