/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel.filtering;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.scientific.tables.panel.filtering.DSFilterController;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.util.UiSizeUtilKt;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSOpenFilterAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "getOrCreateFilterController", "Lcom/intellij/scientific/tables/panel/filtering/DSFilterController;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "findFilterViewPanelNew", "context", "intellij.scientific.tables"})
public final class DSOpenFilterAction
extends DumbAwareToggleAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        DSTableDataRetrieverFromDataSource tableDataRetriever;
        DSTable table;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DSTable dSTable = table = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = tableDataRetriever = dSTable != null ? dSTable.getTableDataRetrieverFromDataSource() : null;
        boolean isDynamicTable = dSTableDataRetrieverFromDataSource != null ? dSTableDataRetrieverFromDataSource.isDynamicTable() : false;
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource2 = tableDataRetriever;
        if (dSTableDataRetrieverFromDataSource2 == null) {
            return;
        }
        boolean isFiltersSupported = dSTableDataRetrieverFromDataSource2.isFiltersSupported();
        boolean isEnabled = isDynamicTable && table instanceof DSTableWithStatistics && isFiltersSupported;
        e.getPresentation().setEnabledAndVisible(isEnabled);
        if (!isEnabled) {
            return;
        }
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!e.getPresentation().isEnabledAndVisible()) {
            return false;
        }
        DSTable dSTable = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        if (dSTable == null) {
            return false;
        }
        DSTable table = dSTable;
        DSTableWithStatistics dSTableWithStatistics = table instanceof DSTableWithStatistics ? (DSTableWithStatistics)table : null;
        if (dSTableWithStatistics == null || (dSTableWithStatistics = dSTableWithStatistics.getGrid()) == null) {
            return false;
        }
        DSTableWithStatistics grid2 = dSTableWithStatistics;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DSFilterController controller = this.getOrCreateFilterController(dataContext, (DataGrid)grid2);
        return controller.isFiltersApplied();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!e.getPresentation().isEnabledAndVisible()) {
            return;
        }
        DSTable dSTable = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        if (dSTable == null) {
            return;
        }
        DSTable table = dSTable;
        DSTableWithStatistics dSTableWithStatistics = table instanceof DSTableWithStatistics ? (DSTableWithStatistics)table : null;
        if (dSTableWithStatistics == null || (dSTableWithStatistics = dSTableWithStatistics.getGrid()) == null) {
            return;
        }
        DSTableWithStatistics grid2 = dSTableWithStatistics;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DSFilterController controller = this.getOrCreateFilterController(dataContext, (DataGrid)grid2);
        JBPopup jBPopup = controller.createFiltersPopup();
        if (jBPopup == null) {
            return;
        }
        JBPopup popup = jBPopup;
        Component component = grid2.getPanel().getTopComponent();
        int heightDelta = component != null ? component.getHeight() : 10;
        Component component2 = (Component)grid2.getPanel().getComponent();
        int n = grid2.getPanel().getComponent().getSize().width;
        JComponent jComponent = popup.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContent(...)");
        RelativePoint relativePointToTable = new RelativePoint(component2, new Point(n - UiSizeUtilKt.getPreferredWidth((JComponent)jComponent), heightDelta));
        popup.show(relativePointToTable);
    }

    private final DSFilterController getOrCreateFilterController(DataContext dataContext, DataGrid grid2) {
        DSFilterController controller = this.findFilterViewPanelNew(dataContext);
        if (controller == null) {
            controller = new DSFilterController(grid2);
        }
        return controller;
    }

    private final DSFilterController findFilterViewPanelNew(DataContext context) {
        DataGrid dataGrid = (DataGrid)context.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return null;
        }
        DataGrid grid2 = dataGrid;
        return (DSFilterController)grid2.getUserData(DSFilterController.DS_TABLES_FILTER_CONTROLLER);
    }
}

