/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.rt.execution.junit.MapSerializerUtil;
import org.junit.runner.Description;

public interface JUnitTestTreeNodeManager {
    public static final String JUNIT_TEST_TREE_NODE_MANAGER_ARGUMENT = "nodeNamesHandler";
    public static final JUnitTestTreeNodeManager JAVA_NODE_NAMES_MANAGER = new JUnitTestTreeNodeManager(){

        @Override
        public TestNodePresentation getRootNodePresentation(String fullName) {
            if (fullName == null) {
                return new TestNodePresentation(null, null);
            }
            int lastPointIdx = fullName.lastIndexOf(46);
            String name = fullName;
            String comment = null;
            if (lastPointIdx >= 0) {
                name = fullName.substring(lastPointIdx + 1);
                comment = fullName.substring(0, lastPointIdx);
            }
            return new TestNodePresentation(name, comment);
        }

        @Override
        public String getNodeName(String fqName, boolean splitBySlash) {
            int classEnd;
            if (fqName == null) {
                return null;
            }
            int idx = fqName.indexOf("[");
            if (idx == 0) {
                return fqName;
            }
            String fqNameWithoutParams = idx > 0 && fqName.endsWith("]") ? fqName.substring(0, idx) : fqName;
            int n = classEnd = splitBySlash ? fqNameWithoutParams.indexOf(47) : -1;
            if (classEnd >= 0) {
                return fqName.substring(classEnd + 1);
            }
            int dotInClassFQNIdx = fqNameWithoutParams.lastIndexOf(46);
            return dotInClassFQNIdx > -1 ? fqName.substring(dotInClassFQNIdx + 1) : fqName;
        }

        @Override
        public String getTestLocation(Description description, String className, String methodName) {
            return "locationHint='java:test://" + MapSerializerUtil.escapeStr((String)(className + "/" + this.getNodeName(methodName, true)), (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER) + "'";
        }
    };

    public TestNodePresentation getRootNodePresentation(String var1);

    public String getNodeName(String var1, boolean var2);

    public String getTestLocation(Description var1, String var2, String var3);

    public static class TestNodePresentation {
        private final String myName;
        private final String myComment;

        public TestNodePresentation(String name, String comment) {
            this.myName = name;
            this.myComment = comment;
        }

        public String getName() {
            return this.myName;
        }

        public String getComment() {
            return this.myComment;
        }
    }
}

