/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.StandaloneVmHelperKt;
import org.jetbrains.rpc.MessageProcessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/debugger/AttachStateManager;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "channel", "Lio/netty/channel/Channel;", "<init>", "(Lorg/jetbrains/rpc/MessageProcessor;Lio/netty/channel/Channel;)V", "getChannelIfActive", "write", "", "content", "", "isAttached", "()Z", "detach", "Lorg/jetbrains/concurrency/Promise;", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public class StandaloneVmHelper
implements AttachStateManager {
    @NotNull
    private final MessageProcessor messageProcessor;
    @Nullable
    private volatile Channel channel;

    public StandaloneVmHelper(@NotNull MessageProcessor messageProcessor, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)messageProcessor, (String)"messageProcessor");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.messageProcessor = messageProcessor;
        this.channel = channel;
    }

    @Nullable
    public final Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? null : currentChannel;
    }

    public final boolean write(@NotNull Object content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Channel channel = this.getChannelIfActive();
        if (channel != null) {
            return !channel.writeAndFlush(content).isCancelled();
        }
        ReferenceCountUtil.release((Object)content);
        return false;
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<?> detach() {
        Channel channel = this.channel;
        if (channel == null) {
            return Promises.nullPromise();
        }
        Channel currentChannel = channel;
        this.messageProcessor.cancelWaitingRequests();
        AsyncPromise promise = new AsyncPromise();
        this.messageProcessor.closed();
        this.channel = null;
        this.closeChannel(currentChannel, (AsyncPromise<Object>)promise);
        return (Promise)promise;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Object> promise) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        StandaloneVmHelperKt.doCloseChannel(channel, promise);
    }
}

