/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class Html5SchemaProvider {
    private static final Logger LOG = Logger.getInstance(Html5SchemaProvider.class);
    private static final Supplier<String> HTML5_SCHEMA_LOCATION = new SynchronizedClearableLazy(() -> Html5SchemaProvider.loadLocation(Html5SchemaProvider.getInstance().getHtmlSchemaLocation(), "HTML5_SCHEMA"));
    private static final Supplier<String> XHTML5_SCHEMA_LOCATION = new SynchronizedClearableLazy(() -> Html5SchemaProvider.loadLocation(Html5SchemaProvider.getInstance().getXhtmlSchemaLocation(), "XHTML5_SCHEMA"));
    private static final Supplier<String> CHARS_DTD_LOCATION = new SynchronizedClearableLazy(() -> Html5SchemaProvider.loadLocation(Html5SchemaProvider.getInstance().getCharsLocation(), "CHARS_DTD"));

    private static String loadLocation(URL url, String id) {
        String location = VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)url.toExternalForm())));
        LOG.info(id + "_LOCATION = " + location);
        return location;
    }

    public static String getHtml5SchemaLocation() {
        return HTML5_SCHEMA_LOCATION.get();
    }

    public static String getXhtml5SchemaLocation() {
        return XHTML5_SCHEMA_LOCATION.get();
    }

    public static String getCharsDtdLocation() {
        return CHARS_DTD_LOCATION.get();
    }

    @NotNull
    private static Html5SchemaProvider getInstance() {
        Html5SchemaProvider html5SchemaProvider = (Html5SchemaProvider)ApplicationManager.getApplication().getService(Html5SchemaProvider.class);
        if (html5SchemaProvider == null) {
            Html5SchemaProvider.$$$reportNull$$$0(0);
        }
        return html5SchemaProvider;
    }

    @NotNull
    public abstract URL getHtmlSchemaLocation();

    @NotNull
    public abstract URL getXhtmlSchemaLocation();

    @NotNull
    public abstract URL getCharsLocation();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/Html5SchemaProvider", "getInstance"));
    }
}

