/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.SofterCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImplementationClassCache {
    private static final Comparator<Class<?>> CLASS_COMPARATOR = (o1, o2) -> {
        if (o1.isAssignableFrom((Class<?>)o2)) {
            return 1;
        }
        if (o2.isAssignableFrom((Class<?>)o1)) {
            return -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        throw new AssertionError((Object)("Incompatible implementation classes: " + String.valueOf(o1) + " & " + String.valueOf(o2)));
    };
    private final MultiMap<String, DomImplementationClassEP> myImplementationClasses = new MultiMap();
    private final SofterCache<Class<?>, Class<?>> myCache = new SofterCache<Class, Class>(concreteInterface -> {
        TreeSet set = new TreeSet(CLASS_COMPARATOR);
        this.findImplementationClassDFS((Class<?>)concreteInterface, set);
        if (!set.isEmpty()) {
            return set.first();
        }
        return concreteInterface;
    });

    ImplementationClassCache(ExtensionPointName<DomImplementationClassEP> epName) {
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        epName.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DomImplementationClassEP>(){

            public void extensionAdded(@NotNull DomImplementationClassEP ep, @NotNull PluginDescriptor pluginDescriptor) {
                if (ep == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ImplementationClassCache.this.myImplementationClasses.putValue((Object)ep.interfaceName, (Object)ep);
                ImplementationClassCache.this.clearCache();
            }

            public void extensionRemoved(@NotNull DomImplementationClassEP ep, @NotNull PluginDescriptor pluginDescriptor) {
                if (ep == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ImplementationClassCache.this.myImplementationClasses.remove((Object)ep.interfaceName, (Object)ep);
                ImplementationClassCache.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ep";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/xml/impl/ImplementationClassCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, null);
    }

    private void findImplementationClassDFS(@NotNull Class<?> concreteInterface, SortedSet<? super Class<?>> results) {
        if (concreteInterface == null) {
            ImplementationClassCache.$$$reportNull$$$0(0);
        }
        Collection values = this.myImplementationClasses.get((Object)concreteInterface.getName());
        for (DomImplementationClassEP value : values) {
            if (value.getInterfaceClass() != concreteInterface) continue;
            results.add(value.getImplementationClass());
            return;
        }
        for (Class<?> aClass1 : concreteInterface.getInterfaces()) {
            this.findImplementationClassDFS(aClass1, results);
        }
    }

    void registerImplementation(final Class<?> domElementClass, final Class<?> implementationClass, @Nullable Disposable parentDisposable) {
        DomImplementationClassEP ep = new DomImplementationClassEP(){

            @Override
            public Class<?> getInterfaceClass() {
                return domElementClass;
            }

            @Override
            public Class<?> getImplementationClass() {
                return implementationClass;
            }
        };
        this.myImplementationClasses.putValue((Object)domElementClass.getName(), (Object)ep);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ImplementationClassCache.this.myImplementationClasses.remove((Object)domElementClass.getName());
                }
            });
        }
        this.myCache.clearCache();
    }

    @Nullable
    Class<?> get(Class<?> key) {
        Class<?> impl = this.myCache.getCachedValue(key);
        return impl == key ? null : impl;
    }

    void clearCache() {
        this.myCache.clearCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "concreteInterface", "com/intellij/util/xml/impl/ImplementationClassCache", "findImplementationClassDFS"));
    }
}

