/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveDomElementQuickFix
implements LocalQuickFix {
    private final boolean myIsTag;
    private final String myName;

    public RemoveDomElementQuickFix(@NotNull DomElement element) {
        if (element == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(0);
        }
        this.myIsTag = element.getXmlElement() instanceof XmlTag;
        this.myName = element.getXmlElementName();
    }

    @NotNull
    public String getName() {
        String string = XmlDomBundle.message(this.myIsTag ? "dom.quickfix.remove.element.name" : "dom.quickfix.remove.attribute.name", this.myName);
        if (string == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlDomBundle.message("dom.quickfix.remove.element.family", new Object[0]);
        if (string == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(4);
        }
        if (this.myIsTag) {
            RemoveDomElementQuickFix.removeXmlTag((XmlTag)descriptor.getPsiElement(), project);
        } else {
            GenericAttributeValue<?> domElement = DomManager.getDomManager(project).getDomElement((XmlAttribute)descriptor.getPsiElement());
            assert (domElement != null);
            domElement.undefine();
        }
    }

    public static void removeXmlTag(@NotNull XmlTag tag, @NotNull Project project) {
        if (tag == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(5);
        }
        if (project == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(6);
        }
        XmlTag parentTag = tag.getParentTag();
        DomElement domElement = DomManager.getDomManager(project).getDomElement(tag);
        assert (domElement != null);
        domElement.undefine();
        if (parentTag != null && parentTag.isValid()) {
            parentTag.collapseIfEmpty();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeXmlTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

