/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlDeprecationOwnerDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DefaultXmlTagNameProvider
implements XmlTagNameProvider {
    private static final Logger LOG = Logger.getInstance(DefaultXmlTagNameProvider.class);

    DefaultXmlTagNameProvider() {
    }

    @Override
    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        ArrayList<String> namespaces;
        if (tag == null) {
            DefaultXmlTagNameProvider.$$$reportNull$$$0(0);
        }
        if (prefix.isEmpty()) {
            namespaces = new ArrayList<String>(Arrays.asList(tag.knownNamespaces()));
            namespaces.add("");
        } else {
            namespaces = new ArrayList<String>(Collections.singletonList(tag.getNamespace()));
        }
        PsiFile psiFile = tag.getContainingFile();
        XmlExtension xmlExtension = XmlExtension.getExtension(psiFile);
        List<XmlElementDescriptor> variants = TagNameVariantCollector.getTagDescriptors(tag, namespaces, null);
        if (psiFile instanceof XmlFile && ((XmlFile)psiFile).getRootTag() == tag) {
            DefaultXmlTagNameProvider.addXmlProcessingInstructions(elements, tag);
            if (variants.isEmpty()) {
                DefaultXmlTagNameProvider.getRootTagsVariants(tag, elements);
                return;
            }
        }
        HashSet<String> visited = new HashSet<String>();
        for (XmlElementDescriptor descriptor : variants) {
            boolean deprecated;
            PsiElement declaration;
            String qname = descriptor.getName((PsiElement)tag);
            if (!visited.add(qname)) continue;
            if (!prefix.isEmpty() && qname.startsWith(prefix + ":")) {
                qname = qname.substring(prefix.length() + 1);
            }
            if ((declaration = descriptor.getDeclaration()) != null && !declaration.isValid()) {
                LOG.error(String.valueOf(descriptor) + " contains invalid declaration: " + String.valueOf(declaration));
            }
            LookupElementBuilder lookupElement = declaration == null ? LookupElementBuilder.create((String)qname) : LookupElementBuilder.create((Object)declaration, (String)qname);
            int separator = qname.indexOf(58);
            if (separator > 0) {
                lookupElement = lookupElement.withLookupString(qname.substring(separator + 1));
            }
            Icon icon = AllIcons.Nodes.Tag;
            if (descriptor instanceof PsiPresentableMetaData) {
                icon = ((PsiPresentableMetaData)descriptor).getIcon();
            }
            lookupElement = lookupElement.withIcon(icon);
            if (xmlExtension.useXmlTagInsertHandler()) {
                lookupElement = lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
            }
            boolean bl = deprecated = descriptor instanceof XmlDeprecationOwnerDescriptor && ((XmlDeprecationOwnerDescriptor)descriptor).isDeprecated();
            if (deprecated) {
                lookupElement = lookupElement.withStrikeoutness(true);
            }
            lookupElement = lookupElement.withCaseSensitivity(!(descriptor instanceof HtmlElementDescriptorImpl));
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)(deprecated ? -1.0 : (separator > 0 ? 0.0 : 1.0))));
        }
    }

    private static void addXmlProcessingInstructions(@NotNull List<LookupElement> elements, @NotNull XmlTag tag) {
        PsiElement file;
        PsiElement prolog;
        if (elements == null) {
            DefaultXmlTagNameProvider.$$$reportNull$$$0(1);
        }
        if (tag == null) {
            DefaultXmlTagNameProvider.$$$reportNull$$$0(2);
        }
        if ((prolog = (file = tag.getParent()).getFirstChild()).getTextLength() != 0) {
            return;
        }
        if (ContainerUtil.exists((Object[])tag.getChildren(), OuterLanguageElement.class::isInstance)) {
            return;
        }
        LookupElementBuilder xmlDeclaration = LookupElementBuilder.create((String)"?xml version=\"1.0\" encoding=\"\" ?>").withPresentableText("<?xml version=\"1.0\" encoding=\"\" ?>").withInsertHandler((context, item) -> {
            int offset = context.getEditor().getCaretModel().getOffset();
            context.getEditor().getCaretModel().moveToOffset(offset - 4);
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        });
        elements.add((LookupElement)xmlDeclaration);
    }

    private static void getRootTagsVariants(final XmlTag tag, final List<? super LookupElement> elements) {
        FileBasedIndex fbi = FileBasedIndex.getInstance();
        ArrayList result = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        fbi.processAllKeys(XmlNamespaceIndex.NAME, processor, tag.getProject());
        GlobalSearchScope scope = GlobalSearchScope.everythingScope((Project)tag.getProject());
        for (final String ns : result) {
            if (ns.isEmpty()) continue;
            fbi.processValues(XmlNamespaceIndex.NAME, (Object)ns, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<XsdNamespaceBuilder>(){

                public boolean process(@NotNull VirtualFile file, XsdNamespaceBuilder value) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<String> tags = value.getRootTags();
                    for (String s : tags) {
                        elements.add(LookupElementBuilder.create((String)s).withIcon(AllIcons.Nodes.Tag).withTypeText(ns).withInsertHandler((InsertHandler)new XmlTagInsertHandler(){

                            @Override
                            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                                if (context == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (item == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                Editor editor = context.getEditor();
                                Document document = context.getDocument();
                                int caretOffset = editor.getCaretModel().getOffset();
                                RangeMarker caretMarker = document.createRangeMarker(caretOffset, caretOffset);
                                caretMarker.setGreedyToRight(true);
                                XmlFile psiFile = (XmlFile)context.getFile();
                                boolean incomplete = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null;
                                XmlNamespaceHelper.getHelper((PsiFile)psiFile).insertNamespaceDeclaration(psiFile, editor, Collections.singleton(ns), null, null);
                                editor.getCaretModel().moveToOffset(caretMarker.getEndOffset());
                                XmlTag rootTag = psiFile.getRootTag();
                                if (incomplete) {
                                    XmlToken token = XmlUtil.getTokenOfType((PsiElement)rootTag, XmlTokenType.XML_EMPTY_ELEMENT_END);
                                    if (token != null) {
                                        token.delete();
                                    }
                                    PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
                                    super.handleInsert(context, item);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "context";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "item";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider$1$1";
                                objectArray[2] = "handleInsert";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }));
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider$1", "process"));
                }
            }, scope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTagNameVariants";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addXmlProcessingInstructions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

