/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.collaboration.api.dto.GraphQLRequestDTO;
import com.intellij.collaboration.api.dto.GraphQLResponseDTO;
import com.intellij.collaboration.api.util.LinkHttpHeaderValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.api.GHGQLQueryLoader;
import org.jetbrains.plugins.github.api.GithubApiContentHelper;
import org.jetbrains.plugins.github.api.GithubApiRequestOperation;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchResult;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLError;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRateLimit;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 )*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\b\"#$%&'()B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017\u0082\u0001\u0003*+,\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "T", "", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "operation", "Lorg/jetbrains/plugins/github/api/GithubApiRequestOperation;", "getOperation", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestOperation;", "setOperation", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestOperation;)V", "value", "operationName", "getOperationName", "acceptMimeType", "getAcceptMimeType", "headers", "", "getHeaders", "()Ljava/util/Map;", "additionalHeaders", "", "getAdditionalHeaders", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "withOperation", "withOperationName", "name", "Get", "Head", "WithBody", "Post", "Put", "Patch", "Delete", "Companion", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Head;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "intellij.vcs.github"})
public abstract class GithubApiRequest<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private GithubApiRequestOperation operation;
    @Nullable
    private String operationName;
    @NotNull
    private final Map<String, String> headers;

    private GithubApiRequest(String url) {
        this.url = url;
        this.operation = GithubApiRequestOperation.Unknown;
        this.headers = new LinkedHashMap();
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final GithubApiRequestOperation getOperation() {
        return this.operation;
    }

    public final void setOperation(@NotNull GithubApiRequestOperation githubApiRequestOperation) {
        Intrinsics.checkNotNullParameter((Object)((Object)githubApiRequestOperation), (String)"<set-?>");
        this.operation = githubApiRequestOperation;
    }

    @Nullable
    public final String getOperationName() {
        return this.operationName;
    }

    @Nullable
    public abstract String getAcceptMimeType();

    @NotNull
    protected final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Map<String, String> getAdditionalHeaders() {
        return this.headers;
    }

    public abstract T extractResult(@NotNull GithubApiResponse var1) throws IOException;

    @NotNull
    public final GithubApiRequest<T> withOperation(@NotNull GithubApiRequestOperation operation) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        this.operation = operation;
        return this;
    }

    @NotNull
    public final GithubApiRequest<T> withOperationName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.operationName = name;
        return this;
    }

    public /* synthetic */ GithubApiRequest(String url, DefaultConstructorMarker $constructor_marker) {
        this(url);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\f\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002J(\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0001\u0010\u0005\"\u0004\b\u0002\u0010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0011\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002J4\u0010\u0012\u001a\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00140\u0013\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\tH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Companion;", "", "<init>", "()V", "parseJsonObject", "T", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "clazz", "Ljava/lang/Class;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;Ljava/lang/Class;)Ljava/lang/Object;", "parseJsonList", "", "parseJsonMap", "", "U", "parseJsonSearchPage", "Lorg/jetbrains/plugins/github/api/data/GithubSearchResult;", "parseGQLResponse", "Lcom/intellij/collaboration/api/dto/GraphQLResponseDTO;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLError;", "dataClass", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T parseJsonObject(GithubApiResponse response, Class<T> clazz) {
            return response.readBody(arg_0 -> Companion.parseJsonObject$lambda$0(clazz, arg_0));
        }

        private final <T> List<T> parseJsonList(GithubApiResponse response, Class<T> clazz) {
            Object t = response.readBody(arg_0 -> Companion.parseJsonList$lambda$1(clazz, arg_0));
            Intrinsics.checkNotNullExpressionValue(t, (String)"readBody(...)");
            return (List)t;
        }

        private final <T, U> Map<T, U> parseJsonMap(GithubApiResponse response) {
            Object t = response.readBody(Companion::parseJsonMap$lambda$2);
            Intrinsics.checkNotNullExpressionValue(t, (String)"readBody(...)");
            return (Map)t;
        }

        private final <T> GithubSearchResult<T> parseJsonSearchPage(GithubApiResponse response, Class<T> clazz) {
            Object t = response.readBody(arg_0 -> Companion.parseJsonSearchPage$lambda$3(clazz, arg_0));
            Intrinsics.checkNotNullExpressionValue(t, (String)"readBody(...)");
            return (GithubSearchResult)t;
        }

        private final <T> GraphQLResponseDTO<? extends T, GHGQLError> parseGQLResponse(GithubApiResponse response, Class<? extends T> dataClass) {
            Object t = response.readBody(arg_0 -> Companion.parseGQLResponse$lambda$4(dataClass, arg_0));
            Intrinsics.checkNotNullExpressionValue(t, (String)"readBody(...)");
            return (GraphQLResponseDTO)t;
        }

        private static final Object parseJsonObject$lambda$0(Class $clazz, Reader it) {
            Intrinsics.checkNotNull((Object)it);
            return GithubApiContentHelper.readJsonObject$default(it, $clazz, new Class[0], false, 8, null);
        }

        private static final List parseJsonList$lambda$1(Class $clazz, Reader it) {
            Intrinsics.checkNotNull((Object)it);
            return GithubApiContentHelper.readJsonList(it, $clazz);
        }

        private static final Map parseJsonMap$lambda$2(Reader it) {
            Intrinsics.checkNotNull((Object)it);
            return GithubApiContentHelper.readJsonMap$default(it, false, 2, null);
        }

        private static final GithubSearchResult parseJsonSearchPage$lambda$3(Class $clazz, Reader it) {
            Intrinsics.checkNotNull((Object)it);
            Class[] classArray = new Class[]{$clazz};
            Object object = GithubApiContentHelper.readJsonObject$default(it, GithubSearchResult.class, classArray, false, 8, null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.api.data.GithubSearchResult<T of org.jetbrains.plugins.github.api.GithubApiRequest.Companion.parseJsonSearchPage>");
            return (GithubSearchResult)object;
        }

        private static final GraphQLResponseDTO parseGQLResponse$lambda$4(Class $dataClass, Reader it) {
            Intrinsics.checkNotNull((Object)it);
            Class[] classArray = new Class[]{$dataClass, GHGQLError.class};
            GraphQLResponseDTO graphQLResponseDTO = GithubApiContentHelper.readJsonObject(it, GraphQLResponseDTO.class, classArray, true);
            Intrinsics.checkNotNull((Object)graphQLResponseDTO, (String)"null cannot be cast to non-null type com.intellij.collaboration.api.dto.GraphQLResponseDTO<T of org.jetbrains.plugins.github.api.GithubApiRequest.Companion.parseGQLResponse, org.jetbrains.plugins.github.api.data.graphql.GHGQLError>");
            return graphQLResponseDTO;
        }

        public static final /* synthetic */ GraphQLResponseDTO access$parseGQLResponse(Companion $this, GithubApiResponse response, Class dataClass) {
            return $this.parseGQLResponse(response, dataClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b&\u0018\u0000 \f*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\f\rB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "bodyMimeType", "", "url", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBodyMimeType", "()Ljava/lang/String;", "getAcceptMimeType", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Delete<T>
    extends WithBody<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;

        @JvmOverloads
        public Delete(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Delete(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Delete(@NotNull String bodyMimeType, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0086\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Companion;", "", "<init>", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <T> Delete<T> json(String url, Object body) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class);
            }

            public static /* synthetic */ Delete json$default(Companion $this, String url, Object body, int n, Object object) {
                if ((n & 2) != 0) {
                    body = null;
                }
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Json\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
        public static class Json<T>
        extends Delete<T> {
            @Nullable
            private final Object bodyObject;
            @NotNull
            private final Class<T> clazz;

            public Json(@NotNull String url, @Nullable Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, "application/vnd.github.v3+json");
                this.bodyObject = bodyObject;
                this.clazz = clazz;
                if (this.bodyObject == null) {
                    this.getHeaders().put("Content-Length", "0");
                }
            }

            public /* synthetic */ Json(String string, Object object, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    object = null;
                }
                this(string, object, clazz);
            }

            @Override
            @Nullable
            public String getBody() {
                String string;
                Object object = this.bodyObject;
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    string = GithubApiContentHelper.toJson$default(it, false, 2, null);
                } else {
                    string = null;
                }
                return string;
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u0000 \u000b*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0006\n\u000b\f\r\u000e\u000fB\u001d\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "Optional", "Companion", "Json", "JsonMap", "JsonPage", "JsonSearchPage", "intellij.vcs.github"})
    public static abstract class Get<T>
    extends GithubApiRequest<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String acceptMimeType;

        @JvmOverloads
        public Get(@NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, null);
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Get(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Get(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this(url, null, 2, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0086\bJ1\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000b0\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0086\bJ1\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000b0\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0086\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion;", "", "<init>", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "T", "url", "", "acceptMimeType", "jsonPage", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "jsonSearchPage", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <T> Get<T> json(String url, String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Get json$default(Companion $this, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, Object.class, acceptMimeType);
            }

            public final /* synthetic */ <T> Get<GithubResponsePage<T>> jsonPage(String url, String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$jsonPage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonPage<Object>(url, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Get jsonPage$default(Companion $this, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$jsonPage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonPage<Object>(url, Object.class, acceptMimeType);
            }

            public final /* synthetic */ <T> Get<GithubResponsePage<T>> jsonSearchPage(String url, String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$jsonSearchPage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonSearchPage<Object>(url, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Get jsonSearchPage$default(Companion $this, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$jsonSearchPage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonSearchPage<Object>(url, Object.class, acceptMimeType);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00028\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Get<T> {
            @NotNull
            private final Class<T> clazz;

            public Json(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ Json(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonMap;", "T", "U", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "", "url", "", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonMap<T, U>
        extends Get<Map<T, ? extends U>> {
            public JsonMap(@NotNull String url, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(url, acceptMimeType);
            }

            public /* synthetic */ JsonMap(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, string2);
            }

            @Override
            @NotNull
            public Map<T, U> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return GithubApiRequest.Companion.parseJsonMap(response);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonPage;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonPage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
        public static class JsonPage<T>
        extends Get<GithubResponsePage<T>> {
            @NotNull
            private final Class<T> clazz;

            public JsonPage(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ JsonPage(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }

            @Override
            @NotNull
            public GithubResponsePage<T> extractResult(@NotNull GithubApiResponse response) {
                LinkHttpHeaderValue linkHttpHeaderValue;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                List list = GithubApiRequest.Companion.parseJsonList(response, this.clazz);
                String string = response.findHeader("Link");
                if (string != null) {
                    String string2 = string;
                    LinkHttpHeaderValue.Companion companion = LinkHttpHeaderValue.Companion;
                    String p0 = string2;
                    boolean bl = false;
                    linkHttpHeaderValue = companion.parse(p0);
                } else {
                    linkHttpHeaderValue = null;
                }
                LinkHttpHeaderValue linkHeader = linkHttpHeaderValue;
                return new GithubResponsePage(list, linkHeader);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonSearchPage;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonSearchPage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
        public static class JsonSearchPage<T>
        extends Get<GithubResponsePage<T>> {
            @NotNull
            private final Class<T> clazz;

            public JsonSearchPage(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.clazz = clazz;
            }

            public /* synthetic */ JsonSearchPage(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }

            @Override
            @NotNull
            public GithubResponsePage<T> extractResult(@NotNull GithubApiResponse response) {
                LinkHttpHeaderValue linkHttpHeaderValue;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                GithubSearchResult page = GithubApiRequest.Companion.parseJsonSearchPage(response, this.clazz);
                String string = response.findHeader("Link");
                if (string != null) {
                    String string2 = string;
                    LinkHttpHeaderValue.Companion companion = LinkHttpHeaderValue.Companion;
                    String p0 = string2;
                    boolean bl = false;
                    linkHttpHeaderValue = companion.parse(p0);
                } else {
                    linkHttpHeaderValue = null;
                }
                LinkHttpHeaderValue linkHeader = linkHttpHeaderValue;
                List list = page.getItems();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getItems(...)");
                return new GithubResponsePage(list, linkHeader);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 \b*\u0004\b\u0002\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0002\b\tB\u001d\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "url", "", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "Json", "intellij.vcs.github"})
        public static abstract class Optional<T>
        extends Get<T> {
            @NotNull
            public static final Companion Companion = new Companion(null);

            @JvmOverloads
            public Optional(@NotNull String url, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(url, acceptMimeType);
            }

            public /* synthetic */ Optional(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @JvmOverloads
            public Optional(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this(url, null, 2, null);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0006\b\u0003\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0086\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Companion;", "", "<init>", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "T", "url", "", "acceptMimeType", "intellij.vcs.github"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ <T> Optional<T> json(String url, String acceptMimeType) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    boolean $i$f$json = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    return new Json<Object>(url, Object.class, acceptMimeType);
                }

                public static /* synthetic */ Optional json$default(Companion $this, String url, String acceptMimeType, int n, Object object) {
                    if ((n & 2) != 0) {
                        acceptMimeType = null;
                    }
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    boolean $i$f$json = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    return new Json<Object>(url, Object.class, acceptMimeType);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00028\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
            public static class Json<T>
            extends Optional<T> {
                @NotNull
                private final Class<T> clazz;

                public Json(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    super(url, acceptMimeType);
                    this.clazz = clazz;
                }

                public /* synthetic */ Json(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 4) != 0) {
                        string2 = "application/vnd.github.v3+json";
                    }
                    this(string, clazz, string2);
                }

                @Override
                public T extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Head;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "intellij.vcs.github"})
    public static abstract class Head<T>
    extends GithubApiRequest<T> {
        @Nullable
        private final String acceptMimeType;

        @JvmOverloads
        public Head(@NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, null);
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Head(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Head(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this(url, null, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u0000 \u000e*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u000e\u000fB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\n\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "bodyMimeType", "", "url", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBodyMimeType", "()Ljava/lang/String;", "getAcceptMimeType", "setAcceptMimeType", "(Ljava/lang/String;)V", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Patch<T>
    extends Post<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private String acceptMimeType;

        @JvmOverloads
        public Patch(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(bodyMimeType, url, acceptMimeType);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Patch(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @Override
        public void setAcceptMimeType(@Nullable String string) {
            this.acceptMimeType = string;
        }

        @JvmOverloads
        public Patch(@NotNull String bodyMimeType, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0086\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Companion;", "", "<init>", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <T> Post<T> json(String url, Object body) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Json;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "intellij.vcs.github"})
        public static class Json<T>
        extends Post.Json<T> {
            public Json(@NotNull String url, @NotNull Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)bodyObject, (String)"bodyObject");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(url, bodyObject, clazz, null, 8, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b&\u0018\u0000 \u000e*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u000e\u000f\u0010B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\n\"\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "bodyMimeType", "", "url", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBodyMimeType", "()Ljava/lang/String;", "getAcceptMimeType", "setAcceptMimeType", "(Ljava/lang/String;)V", "Companion", "Json", "GQLQuery", "intellij.vcs.github"})
    public static abstract class Post<T>
    extends WithBody<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private String acceptMimeType;

        @JvmOverloads
        public Post(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Post(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        public void setAcceptMimeType(@Nullable String string) {
            this.acceptMimeType = string;
        }

        @JvmOverloads
        public Post(@NotNull String bodyMimeType, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u0086\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion;", "", "<init>", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "url", "", "body", "acceptMimeType", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <T> Post<T> json(String url, Object body, String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class, acceptMimeType);
            }

            public static /* synthetic */ Post json$default(Companion $this, String url, Object body, String acceptMimeType, int n, Object object) {
                if ((n & 4) != 0) {
                    acceptMimeType = null;
                }
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class, acceptMimeType);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0006\b\u0002\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0005)*+,-B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J\u001e\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH&J\u0015\u0010\u001f\u001a\u00028\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010 J4\u0010!\u001a\u0012\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001b\"\u0004\b\u0003\u0010\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0010H\u0004JI\u0010!\u001a\u0012\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001b\"\u0004\b\u0003\u0010\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00102\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040#H\u0004\u00a2\u0006\u0002\u0010$JO\u0010!\u001a\u0012\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001b\"\u0004\b\u0003\u0010\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H\u00010&H\u0004\u00a2\u0006\u0002\u0010(R\u0016\u0010\u0005\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00108aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "url", "", "queryName", "variablesObject", "", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getQueryName$intellij_vcs_github", "()Ljava/lang/String;", "getVariablesObject$intellij_vcs_github", "()Ljava/util/Map;", "clazz", "Ljava/lang/Class;", "getClazz$intellij_vcs_github", "()Ljava/lang/Class;", "body", "getBody", "throwException", "", "errors", "", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLError;", "extractResultWithCost", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRateLimit;", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "extractResult", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "parseResponse", "pathFromData", "", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;Ljava/lang/Class;[Ljava/lang/String;)Lkotlin/Pair;", "deserialize", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "Parsed", "Traversed", "TraversedParsed", "OptionalTraversedParsed", "OptionalTraversedParsedList", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 GithubApiContentHelper.kt\norg/jetbrains/plugins/github/api/GithubApiContentHelper\n*L\n1#1,378:1\n1761#2,3:379\n1#3:382\n56#4:383\n*S KotlinDebug\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery\n*L\n162#1:379,3\n265#1:383\n*E\n"})
        public static abstract class GQLQuery<T>
        extends Post<T> {
            @VisibleForTesting
            @NotNull
            private final String queryName;
            @VisibleForTesting
            @NotNull
            private final Map<String, Object> variablesObject;

            public GQLQuery(@NotNull String url, @NotNull String queryName, @NotNull Map<String, ? extends Object> variablesObject) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)queryName, (String)"queryName");
                Intrinsics.checkNotNullParameter(variablesObject, (String)"variablesObject");
                super("application/json", url, null, 4, null);
                this.queryName = queryName;
                this.variablesObject = variablesObject;
            }

            @NotNull
            public final String getQueryName$intellij_vcs_github() {
                return this.queryName;
            }

            @NotNull
            public final Map<String, Object> getVariablesObject$intellij_vcs_github() {
                return this.variablesObject;
            }

            @VisibleForTesting
            @NotNull
            public abstract Class<?> getClazz$intellij_vcs_github();

            @Override
            @NotNull
            public String getBody() {
                String query = GHGQLQueryLoader.INSTANCE.loadQuery(this.queryName);
                GraphQLRequestDTO request2 = new GraphQLRequestDTO(query, this.variablesObject);
                return GithubApiContentHelper.toJson(request2, true);
            }

            @NotNull
            protected final Void throwException(@NotNull List<GHGQLError> errors) {
                boolean bl;
                block5: {
                    Intrinsics.checkNotNullParameter(errors, (String)"errors");
                    Iterable $this$any$iv = errors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            GHGQLError it = (GHGQLError)((Object)element$iv);
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it.getType(), (String)"INSUFFICIENT_SCOPES", (boolean)true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw new GithubAuthenticationException("Access token has not been granted the required scopes.");
                }
                if (errors.size() == 1) {
                    throw new GithubConfusingException(((GHGQLError)((Object)CollectionsKt.single(errors))).toString());
                }
                throw new GithubConfusingException(errors.toString());
            }

            @NotNull
            public abstract Pair<T, GHGQLRateLimit> extractResultWithCost(@NotNull GithubApiResponse var1);

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)this.extractResultWithCost(response).getFirst();
            }

            @Nullable
            protected final <T> Pair<T, GHGQLRateLimit> parseResponse(@NotNull GithubApiResponse response, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                return this.parseResponse(response, new String[0], arg_0 -> GQLQuery.parseResponse$lambda$1(clazz, arg_0));
            }

            @Nullable
            protected final <T> Pair<T, GHGQLRateLimit> parseResponse(@NotNull GithubApiResponse response, @NotNull Class<T> clazz, @NotNull String[] pathFromData) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                return this.parseResponse(response, pathFromData, arg_0 -> GQLQuery.parseResponse$lambda$2(clazz, arg_0));
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            protected final <T> Pair<T, GHGQLRateLimit> parseResponse(@NotNull GithubApiResponse response, @NotNull String[] pathFromData, @NotNull Function1<? super JsonNode, ? extends T> deserialize) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    Intrinsics.checkNotNullParameter(deserialize, (String)"deserialize");
                    result = org.jetbrains.plugins.github.api.GithubApiRequest$Companion.access$parseGQLResponse(GithubApiRequest.Companion, response, JsonNode.class);
                    data = (JsonNode)result.getData();
                    if (data == null || data.isNull()) break block4;
                    node = data;
                    for (String path : pathFromData) {
                        if (node.get(path) == null) break;
                    }
                    if (node.isNull()) break block4;
                    result = deserialize.invoke((Object)node);
                    var9_11 = data.get("rateLimit");
                    if (var9_11 == null) ** GOTO lbl-1000
                    it = var11_12 = var9_11;
                    $i$a$-takeIf-GithubApiRequest$Post$GQLQuery$parseResponse$rates$1 = false;
                    v0 /* !! */  = var10_15 = it.isNull() == false != false ? var11_12 : null;
                    if (var10_15 != null) {
                        it = var10_15;
                        $i$a$-let-GithubApiRequest$Post$GQLQuery$parseResponse$rates$2 = false;
                        var14_16 = GithubApiContentHelper.INSTANCE;
                        v1 = it.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                        var15_17 = v1;
                        gqlNaming$iv = true;
                        $i$f$fromJson$intellij_vcs_github = false;
                        v2 = GithubApiContentHelper.fromJson((String)string$iv, GHGQLRateLimit.class, gqlNaming$iv);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                    rates = v2;
                    return TuplesKt.to((Object)result, rates);
                }
                if ((errors = result.getErrors()) == null) {
                    return null;
                }
                this.throwException(errors);
                throw new KotlinNothingValueException();
            }

            private static final Object parseResponse$lambda$1(Class $clazz, JsonNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return GithubApiContentHelper.fromJson(string, $clazz, true);
            }

            private static final Object parseResponse$lambda$2(Class $clazz, JsonNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return GithubApiContentHelper.fromJson(string, $clazz, true);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0003\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\n\u0012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\f\"\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$OptionalTraversedParsed;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$Traversed;", "url", "", "requestFilePath", "variablesObject", "", "", "clazz", "Ljava/lang/Class;", "pathFromData", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;[Ljava/lang/String;)V", "getClazz$intellij_vcs_github", "()Ljava/lang/Class;", "extractResultWithCost", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRateLimit;", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
            public static final class OptionalTraversedParsed<T>
            extends Traversed<T> {
                @NotNull
                private final Class<? extends T> clazz;

                public OptionalTraversedParsed(@NotNull String url, @NotNull String requestFilePath, @NotNull Map<String, ? extends Object> variablesObject, @NotNull Class<? extends T> clazz, String ... pathFromData) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter(variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    super(url, requestFilePath, variablesObject, pathFromData);
                    this.clazz = clazz;
                }

                @Override
                @NotNull
                public Class<? extends T> getClazz$intellij_vcs_github() {
                    return this.clazz;
                }

                @Override
                @NotNull
                public Pair<T, GHGQLRateLimit> extractResultWithCost(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Pair pair = this.parseResponse(response, this.getClazz$intellij_vcs_github(), this.getPathFromData$intellij_vcs_github());
                    if (pair == null) {
                        pair = TuplesKt.to(null, null);
                    }
                    return pair;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0003\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00030\u0002BQ\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\u000b\u0012\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\r\"\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ&\u0010\u0012\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\u000bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$OptionalTraversedParsedList;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$Traversed;", "", "url", "", "requestFilePath", "variablesObject", "", "", "clazz", "Ljava/lang/Class;", "pathFromData", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;[Ljava/lang/String;)V", "getClazz$intellij_vcs_github", "()Ljava/lang/Class;", "extractResultWithCost", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRateLimit;", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
            public static final class OptionalTraversedParsedList<T>
            extends Traversed<List<? extends T>> {
                @NotNull
                private final Class<? extends T> clazz;

                public OptionalTraversedParsedList(@NotNull String url, @NotNull String requestFilePath, @NotNull Map<String, ? extends Object> variablesObject, @NotNull Class<? extends T> clazz, String ... pathFromData) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter(variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    super(url, requestFilePath, variablesObject, pathFromData);
                    this.clazz = clazz;
                }

                @Override
                @NotNull
                public Class<? extends T> getClazz$intellij_vcs_github() {
                    return this.clazz;
                }

                @Override
                @NotNull
                public Pair<List<T>, GHGQLRateLimit> extractResultWithCost(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Pair pair = this.parseResponse(response, this.getPathFromData$intellij_vcs_github(), arg_0 -> OptionalTraversedParsedList.extractResultWithCost$lambda$0(this, arg_0));
                    if (pair == null) {
                        pair = TuplesKt.to(null, null);
                    }
                    return pair;
                }

                private static final List extractResultWithCost$lambda$0(OptionalTraversedParsedList this$0, JsonNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = string;
                    return GithubApiContentHelper.readJsonList(new StringReader(string2), this$0.getClazz$intellij_vcs_github());
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0006\b\u0003\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$Parsed;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "url", "", "requestFilePath", "variablesObject", "", "", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;)V", "getClazz$intellij_vcs_github", "()Ljava/lang/Class;", "extractResultWithCost", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRateLimit;", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
            public static final class Parsed<T>
            extends GQLQuery<T> {
                @NotNull
                private final Class<? extends T> clazz;

                public Parsed(@NotNull String url, @NotNull String requestFilePath, @NotNull Map<String, ? extends Object> variablesObject, @NotNull Class<? extends T> clazz) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter(variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    super(url, requestFilePath, variablesObject);
                    this.clazz = clazz;
                }

                @Override
                @NotNull
                public Class<? extends T> getClazz$intellij_vcs_github() {
                    return this.clazz;
                }

                @Override
                @NotNull
                public Pair<T, GHGQLRateLimit> extractResultWithCost(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Pair<T, GHGQLRateLimit> pair = this.parseResponse(response, this.getClazz$intellij_vcs_github());
                    if (pair == null) {
                        throw new GithubJsonException("Non-nullable entity is null or entity path is invalid");
                    }
                    return pair;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b&\u0018\u0000*\u0006\b\u0003\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\n\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\n8\u0000X\u0081\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$Traversed;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery;", "url", "", "requestFilePath", "variablesObject", "", "", "pathFromData", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;[Ljava/lang/String;)V", "getPathFromData$intellij_vcs_github", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.vcs.github"})
            public static abstract class Traversed<T>
            extends GQLQuery<T> {
                @VisibleForTesting
                @NotNull
                private final String[] pathFromData;

                public Traversed(@NotNull String url, @NotNull String requestFilePath, @NotNull Map<String, ? extends Object> variablesObject, @NotNull String[] pathFromData) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter(variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    super(url, requestFilePath, variablesObject);
                    this.pathFromData = pathFromData;
                }

                @NotNull
                public final String[] getPathFromData$intellij_vcs_github() {
                    return this.pathFromData;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0003\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BQ\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\n\u0012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$TraversedParsed;", "T", "", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$GQLQuery$Traversed;", "url", "", "requestFilePath", "variablesObject", "", "clazz", "Ljava/lang/Class;", "pathFromData", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;[Ljava/lang/String;)V", "getClazz$intellij_vcs_github", "()Ljava/lang/Class;", "extractResultWithCost", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/graphql/GHGQLRateLimit;", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
            public static final class TraversedParsed<T>
            extends Traversed<T> {
                @NotNull
                private final Class<? extends T> clazz;

                public TraversedParsed(@NotNull String url, @NotNull String requestFilePath, @NotNull Map<String, ? extends Object> variablesObject, @NotNull Class<? extends T> clazz, String ... pathFromData) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)requestFilePath, (String)"requestFilePath");
                    Intrinsics.checkNotNullParameter(variablesObject, (String)"variablesObject");
                    Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                    Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
                    super(url, requestFilePath, variablesObject, pathFromData);
                    this.clazz = clazz;
                }

                @Override
                @NotNull
                public Class<? extends T> getClazz$intellij_vcs_github() {
                    return this.clazz;
                }

                @Override
                @NotNull
                public Pair<T, GHGQLRateLimit> extractResultWithCost(@NotNull GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Pair<T, GHGQLRateLimit> pair = this.parseResponse(response, this.getClazz$intellij_vcs_github(), this.getPathFromData$intellij_vcs_github());
                    if (pair == null) {
                        throw new GithubJsonException("Non-nullable entity is null or entity path is invalid");
                    }
                    return pair;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Post<T> {
            @NotNull
            private final Object bodyObject;
            @NotNull
            private final Class<T> clazz;

            public Json(@NotNull String url, @NotNull Object bodyObject, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)bodyObject, (String)"bodyObject");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, acceptMimeType);
                this.bodyObject = bodyObject;
                this.clazz = clazz;
            }

            public /* synthetic */ Json(String string, Object object, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, object, clazz, string2);
            }

            @Override
            @NotNull
            public String getBody() {
                return GithubApiContentHelper.toJson$default(this.bodyObject, false, 2, null);
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \f*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\f\r\u000eB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "bodyMimeType", "", "url", "acceptMimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBodyMimeType", "()Ljava/lang/String;", "getAcceptMimeType", "Companion", "Json", "JsonList", "intellij.vcs.github"})
    public static abstract class Put<T>
    extends WithBody<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;

        @JvmOverloads
        public Put(@NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        public /* synthetic */ Put(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Put(@NotNull String bodyMimeType, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this(bodyMimeType, url, null, 4, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0086\bJ-\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u000b0\u0005\"\u0006\b\u0002\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0086\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$Companion;", "", "<init>", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "T", "url", "", "body", "jsonList", "", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <T> Put<T> json(String url, Object body) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class);
            }

            public static /* synthetic */ Put json$default(Companion $this, String url, Object body, int n, Object object) {
                if ((n & 2) != 0) {
                    body = null;
                }
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body, Object.class);
            }

            public final /* synthetic */ <T> Put<List<T>> jsonList(String url, Object body) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                boolean $i$f$jsonList = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonList<Object>(url, body, Object.class);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Put$Json\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
        public static class Json<T>
        extends Put<T> {
            @Nullable
            private final Object bodyObject;
            @NotNull
            private final Class<T> clazz;

            public Json(@NotNull String url, @Nullable Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, "application/vnd.github.v3+json");
                this.bodyObject = bodyObject;
                this.clazz = clazz;
                if (this.bodyObject == null) {
                    this.getHeaders().put("Content-Length", "0");
                }
            }

            @Override
            @Nullable
            public String getBody() {
                String string;
                Object object = this.bodyObject;
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    string = GithubApiContentHelper.toJson$default(it, false, 2, null);
                } else {
                    string = null;
                }
                return string;
            }

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)GithubApiRequest.Companion.parseJsonObject(response, this.clazz);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$JsonList;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "", "url", "", "bodyObject", "", "clazz", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "body", "getBody", "()Ljava/lang/String;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Put$JsonList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1#2:379\n*E\n"})
        public static class JsonList<T>
        extends Put<List<? extends T>> {
            @Nullable
            private final Object bodyObject;
            @NotNull
            private final Class<T> clazz;

            public JsonList(@NotNull String url, @Nullable Object bodyObject, @NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super("application/json", url, "application/vnd.github.v3+json");
                this.bodyObject = bodyObject;
                this.clazz = clazz;
                if (this.bodyObject == null) {
                    this.getHeaders().put("Content-Length", "0");
                }
            }

            @Override
            @Nullable
            public String getBody() {
                String string;
                Object object = this.bodyObject;
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    string = GithubApiContentHelper.toJson$default(it, false, 2, null);
                } else {
                    string = null;
                }
                return string;
            }

            @Override
            @NotNull
            public List<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return GithubApiRequest.Companion.parseJsonList(response, this.clazz);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "<init>", "(Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "bodyMimeType", "getBodyMimeType", "intellij.vcs.github"})
    public static abstract class WithBody<T>
    extends GithubApiRequest<T> {
        public WithBody(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url, null);
        }

        @Nullable
        public abstract String getBody();

        @NotNull
        public abstract String getBodyMimeType();
    }
}

