/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.grammar.strategy.StrategyUtils;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TextContentImpl
extends UserDataHolderBase
implements TextContent {
    private final TextContent.TextDomain domain;
    public final List<TokenInfo> tokens;
    private volatile String text;
    private volatile int[] tokenOffsets;

    TextContentImpl(TextContent.TextDomain domain, List<TokenInfo> _tokens) {
        this.domain = domain;
        this.tokens = new ArrayList<TokenInfo>(_tokens.size());
        if (_tokens.isEmpty()) {
            throw new IllegalArgumentException("No tokens");
        }
        for (TokenInfo token : _tokens) {
            TokenInfo merged;
            if (!this.tokens.isEmpty() && (merged = TextContentImpl.merge(this.tokens.get(this.tokens.size() - 1), token)) != null) {
                this.tokens.set(this.tokens.size() - 1, merged);
                continue;
            }
            this.tokens.add(token);
        }
        if (this.tokens.get(0) instanceof WSTokenInfo) {
            this.tokens.remove(0);
        }
        if (this.tokens.get(this.tokens.size() - 1) instanceof WSTokenInfo) {
            this.tokens.remove(this.tokens.size() - 1);
        }
        if (this.tokens.isEmpty()) {
            throw new IllegalArgumentException("There should be at least one non-whitespace token");
        }
        List<TextRange> ranges = this.getRangesInFile();
        if (!ContainerUtil.sorted(ranges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET).equals(ranges)) {
            throw new IllegalArgumentException("TextContent fragments should be ordered by the offset ascending: " + String.valueOf(ranges));
        }
    }

    private int findTokenIndex(int textOffset, int[] tokenOffsets, boolean leanForward) {
        if (textOffset < 0 || textOffset > this.length()) {
            throw new IllegalArgumentException("Text offset " + textOffset + " should be between 0 and " + this.length());
        }
        int index = Arrays.binarySearch(tokenOffsets, textOffset);
        if (index < 0) {
            return -index - 2;
        }
        if (leanForward) {
            while (index < this.tokens.size() - 1 && this.tokens.get(index).length() == 0) {
                ++index;
            }
            if (this.tokens.get(index) instanceof WSTokenInfo) {
                --index;
            }
        } else if (index > 0 && !(this.tokens.get(index - 1) instanceof WSTokenInfo)) {
            --index;
        }
        return index;
    }

    private int findPsiTokenIndex(int fileOffset) {
        return ObjectUtils.binarySearch((int)0, (int)this.tokens.size(), mid -> {
            int psiTokenIndex = mid;
            while (!(this.tokens.get(psiTokenIndex) instanceof PsiToken)) {
                --psiTokenIndex;
            }
            TextRange tokenRange = ((PsiToken)this.tokens.get((int)psiTokenIndex)).rangeInFile;
            if (tokenRange.containsOffset(fileOffset)) {
                return mid == psiTokenIndex ? 0 : 1;
            }
            return tokenRange.getEndOffset() < fileOffset ? -1 : 1;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextContentImpl)) {
            return false;
        }
        TextContentImpl that = (TextContentImpl)o;
        return this.domain == that.domain && this.tokens.equals(that.tokens);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domain, this.tokens});
    }

    @Override
    public TextContent.TextDomain getDomain() {
        return this.domain;
    }

    @Override
    public String toString() {
        String text = this.text;
        if (text == null) {
            this.text = text = StringUtil.join(this.tokens, t -> t.text, (String)"");
        }
        return text;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public int textOffsetToFile(int textOffset) {
        String text = this.toString();
        char prev = textOffset <= 0 ? (char)' ' : (char)text.charAt(textOffset - 1);
        char next = textOffset >= text.length() ? (char)' ' : (char)text.charAt(textOffset);
        boolean leanForward = !(!Character.isWhitespace(prev) && Character.isWhitespace(next) || Character.isLetterOrDigit(prev) && !Character.isLetterOrDigit(next));
        return this.textOffsetToFile(textOffset, leanForward);
    }

    @Override
    public int textOffsetToFile(int textOffset, boolean leanForward) {
        int[] offsets = this.getTokenOffsets();
        int tokenIndex = this.findTokenIndex(textOffset, offsets, leanForward);
        return ((PsiToken)this.tokens.get(tokenIndex)).psiStart() + (textOffset - offsets[tokenIndex]);
    }

    @Override
    public Integer fileOffsetToText(int fileOffset) {
        int index = this.findPsiTokenIndex(fileOffset);
        return index < 0 ? null : Integer.valueOf(this.getTokenOffsets()[index] + fileOffset - ((PsiToken)this.tokens.get((int)index)).rangeInFile.getStartOffset());
    }

    @Override
    @Nullable
    public TextRange fileRangeToText(TextRange fileRange) {
        Integer start = this.fileOffsetToText(fileRange.getStartOffset());
        Integer end = this.fileOffsetToText(fileRange.getEndOffset());
        return start == null || end == null ? null : new TextRange(start.intValue(), end.intValue());
    }

    @Override
    @NotNull
    public PsiElement getCommonParent() {
        PsiElement psiElement = Objects.requireNonNull(PsiTreeUtil.findCommonParent(new ArrayList(ContainerUtil.map2SetNotNull(this.tokens, t -> t instanceof PsiToken ? ((PsiToken)t).psi : null))));
        if (psiElement == null) {
            TextContentImpl.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement findPsiElementAt(int textOffset) {
        int fileOffset = this.textOffsetToFile(textOffset);
        PsiFile file = this.getContainingFile();
        PsiElement leaf = file.findElementAt(fileOffset);
        if (leaf == null) {
            if (fileOffset == file.getTextLength()) {
                PsiElement psiElement = PsiTreeUtil.getDeepestLast((PsiElement)file);
                if (psiElement == null) {
                    TextContentImpl.$$$reportNull$$$0(1);
                }
                return psiElement;
            }
            throw new RuntimeException("Cannot find offset " + fileOffset + " in file of " + String.valueOf(file.getClass()) + ", length " + file.getTextLength());
        }
        PsiElement psiElement = leaf;
        if (psiElement == null) {
            TextContentImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public List<TextRange> getRangesInFile() {
        List list = ((StreamEx)StreamEx.of(this.tokens).select(PsiToken.class).map(t -> t.rangeInFile).filter(r -> !r.isEmpty())).toList();
        if (list == null) {
            TextContentImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        for (TokenInfo token : this.tokens) {
            if (!(token instanceof PsiToken)) continue;
            PsiFile psiFile = ((PsiToken)token).psi.getContainingFile();
            if (psiFile == null) {
                TextContentImpl.$$$reportNull$$$0(4);
            }
            return psiFile;
        }
        throw new IllegalStateException("No PSI tokens");
    }

    @Override
    public boolean hasUnknownFragmentsIn(TextRange rangeInText) {
        int[] offsets = this.getTokenOffsets();
        int start = this.findTokenIndex(rangeInText.getStartOffset(), offsets, false);
        int end = this.findTokenIndex(rangeInText.getEndOffset(), offsets, true);
        for (int i = start; i <= end; ++i) {
            TokenInfo token = this.tokens.get(i);
            if (!(token instanceof PsiToken) || ((PsiToken)token).kind != TokenKind.unknown || !rangeInText.containsOffset(offsets[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public TextContent excludeRange(TextRange rangeInText) {
        return rangeInText.getLength() == 0 ? this : this.excludeRanges(List.of(TextContent.Exclusion.exclude(rangeInText)));
    }

    @Override
    public TextContent markUnknown(TextRange rangeInText) {
        return this.excludeRanges(List.of(TextContent.Exclusion.markUnknown(rangeInText)));
    }

    @Override
    public boolean intersectsRange(TextRange rangeInFile) {
        int start = this.findPsiTokenIndex(rangeInFile.getStartOffset());
        if (start < 0) {
            start = -start - 1;
        }
        for (int i = start; i < this.tokens.size(); ++i) {
            TokenInfo token = this.tokens.get(i);
            if (!(token instanceof PsiToken)) continue;
            TextRange tokenRange = ((PsiToken)token).rangeInFile;
            if (tokenRange.intersectsStrict(rangeInFile)) {
                return true;
            }
            if (tokenRange.getStartOffset() >= rangeInFile.getEndOffset()) break;
        }
        return false;
    }

    @Override
    public TextContent excludeRanges(List<TextContent.Exclusion> ranges) {
        ProgressManager.checkCanceled();
        if (ranges.isEmpty()) {
            return this;
        }
        if (ranges.get((int)0).start < 0 || ranges.get((int)(ranges.size() - 1)).end > this.length()) {
            throw new IllegalArgumentException("Text ranges " + String.valueOf(ranges) + " should be between 0 and " + this.length());
        }
        for (int i = 1; i < ranges.size(); ++i) {
            if (ranges.get((int)(i - 1)).end <= ranges.get((int)i).start) continue;
            throw new IllegalArgumentException("Ranges should be sorted and non-intersecting: " + String.valueOf(ranges));
        }
        int[] offsets = this.getTokenOffsets();
        List<TextContent.Exclusion>[] affectingExclusions = this.getAffectingExclusions(ranges, offsets);
        ArrayList<TokenInfo> newTokens = new ArrayList<TokenInfo>();
        for (int i = 0; i < this.tokens.size(); ++i) {
            List<TextContent.Exclusion> affecting = affectingExclusions[i];
            TokenInfo token = this.tokens.get(i);
            if (affecting == null) {
                newTokens.add(token);
                continue;
            }
            if (!(token instanceof PsiToken)) continue;
            newTokens.addAll(((PsiToken)token).splitToken(offsets[i], affecting));
        }
        if (newTokens.isEmpty()) {
            PsiToken first = (PsiToken)this.tokens.get(0);
            TokenKind kind1 = first.kind;
            TokenKind kind2 = ((PsiToken)this.tokens.get((int)(this.tokens.size() - 1))).kind;
            TokenKind mostUnknown = kind1.compareTo(kind2) > 0 ? kind1 : kind2;
            newTokens.add(new PsiToken("", first.psi, TextRange.from((int)first.rangeInPsi.getStartOffset(), (int)0), mostUnknown));
        }
        return new TextContentImpl(this.domain, newTokens);
    }

    private @Nullable List<TextContent.Exclusion> @NotNull [] getAffectingExclusions(List<TextContent.Exclusion> ranges, int[] offsets) {
        List[] affectingExclusions = new List[this.tokens.size()];
        for (TextContent.Exclusion range : ranges) {
            int i2;
            boolean emptyRange;
            boolean bl = emptyRange = range.start == range.end;
            if (emptyRange && range.kind == TextContent.ExclusionKind.exclude) continue;
            int i1 = this.findTokenIndex(range.start, offsets, true);
            for (i2 = this.findTokenIndex(range.end, offsets, emptyRange); i2 > 0 && this.tokens.get(i2).length() == 0 && i2 > i1; --i2) {
            }
            for (int j = i1; j <= i2; ++j) {
                ArrayList<TextContent.Exclusion> affecting = affectingExclusions[j];
                if (affecting == null) {
                    affectingExclusions[j] = affecting = new ArrayList<TextContent.Exclusion>();
                }
                affecting.add(range);
            }
        }
        if (affectingExclusions == null) {
            TextContentImpl.$$$reportNull$$$0(5);
        }
        return affectingExclusions;
    }

    private int[] getTokenOffsets() {
        int[] offsets = this.tokenOffsets;
        if (offsets == null) {
            this.tokenOffsets = offsets = this.calcTokenOffsets();
        }
        return offsets;
    }

    private int[] calcTokenOffsets() {
        int[] offsets = new int[this.tokens.size()];
        int tokenStart = 0;
        for (int i = 0; i < this.tokens.size(); ++i) {
            TokenInfo info = this.tokens.get(i);
            offsets[i] = tokenStart;
            tokenStart += info.length();
        }
        return offsets;
    }

    @Override
    public TextContent trimWhitespace() {
        int start;
        String text = this.toString();
        int end = text.length();
        for (start = 0; start < end && TextContentImpl.isSpace(text, start); ++start) {
        }
        while (start < end && TextContentImpl.isSpace(text, end - 1)) {
            --end;
        }
        if (start >= end) {
            return null;
        }
        if (start > 0 || end < text.length()) {
            return this.excludeRange(new TextRange(end, text.length())).excludeRange(new TextRange(0, start));
        }
        return this;
    }

    @Override
    public TextContent removeIndents(Set<Character> indentChars) {
        LinkedHashSet<IntRange> ranges = StrategyUtils.INSTANCE.indentIndexes(this, indentChars);
        List exclusions = ((StreamEx)StreamEx.of(ranges).sorted(Comparator.comparingInt(IntProgression::getFirst))).map(range -> {
            int end = range.getEndInclusive() + 1;
            return new TextContent.Exclusion((int)range.getStart(), end, this.hasUnknownFragmentsIn(new TextRange(range.getStart().intValue(), end)));
        }).toList();
        return this.excludeRanges(exclusions);
    }

    @Override
    public TextContent removeLineSuffixes(Set<Character> suffixChars) {
        if (suffixChars.isEmpty()) {
            return this;
        }
        Pattern pattern = Pattern.compile("(" + Strings.join(suffixChars, c -> Pattern.quote(String.valueOf(c)), (String)"|") + ")(?=\n)");
        return this.excludeRanges(ContainerUtil.map(Text.allOccurrences(pattern, this), TextContent.Exclusion::exclude));
    }

    @Override
    public int[] markupOffsets() {
        return this.excludedOffsets(TokenKind.markup);
    }

    @Override
    public int[] unknownOffsets() {
        return this.excludedOffsets(TokenKind.unknown);
    }

    private int[] excludedOffsets(TokenKind kind) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int offset = 0;
        for (TokenInfo token : this.tokens) {
            if (token instanceof PsiToken) {
                PsiToken pt = (PsiToken)token;
                if (pt.kind == kind) {
                    result.add(offset);
                }
            }
            offset += token.length();
        }
        return result.stream().mapToInt(i -> i).toArray();
    }

    @Override
    public TextContent.WithMarkup replaceMarkupWith(char c) {
        final StringBuilder sb = new StringBuilder(this.toString());
        final int[] offsets = this.markupOffsets();
        for (int i = offsets.length - 1; i >= 0; --i) {
            sb.insert(offsets[i], c);
        }
        return new TextContent.WithMarkup(){

            @Override
            public int offsetToOriginal(int offsetWithMarkup) {
                int offset;
                int result = offsetWithMarkup;
                int[] nArray = offsets;
                int n = nArray.length;
                for (int i = 0; i < n && (offset = nArray[i]) < result; --result, ++i) {
                }
                return result;
            }

            @Override
            public int length() {
                return sb.length();
            }

            @Override
            public char charAt(int index) {
                return sb.charAt(index);
            }

            @Override
            @NotNull
            public CharSequence subSequence(int start, int end) {
                CharSequence charSequence = sb.subSequence(start, end);
                if (charSequence == null) {
                    1.$$$reportNull$$$0(0);
                }
                return charSequence;
            }

            @Override
            public String toString() {
                return sb.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/grazie/text/TextContentImpl$1", "subSequence"));
            }
        };
    }

    private static boolean isSpace(String text, int start) {
        return Character.isWhitespace(text.charAt(start)) || Character.isSpaceChar(text.charAt(start));
    }

    @Nullable
    private static TokenInfo merge(TokenInfo t1, TokenInfo t2) {
        if (t1 instanceof WSTokenInfo && t2 instanceof WSTokenInfo) {
            return t1;
        }
        if (t1 instanceof PsiToken && t2 instanceof PsiToken) {
            return TextContentImpl.mergePsiTokens((PsiToken)t1, (PsiToken)t2);
        }
        return null;
    }

    private static TokenInfo mergePsiTokens(PsiToken t1, PsiToken t2) {
        if (t1.kind != TokenKind.text && t2.kind != TokenKind.text) {
            return t1.kind.compareTo(t2.kind) > 0 ? t1 : t2;
        }
        if (t1.kind == TokenKind.text && t2.kind == TokenKind.text) {
            if (t1.length() == 0) {
                return t2;
            }
            if (t2.length() == 0) {
                return t1;
            }
            if (t1.psi == t2.psi && t1.rangeInPsi.getStartOffset() + t1.length() == t2.rangeInPsi.getStartOffset()) {
                return new PsiToken(t1.text + t2.text, t1.psi, t1.rangeInPsi.union(t2.rangeInPsi), TokenKind.text);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/grazie/text/TextContentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonParent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findPsiElementAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesInFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectingExclusions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    @ApiStatus.Internal
    public static abstract class TokenInfo {
        final String text;

        TokenInfo(String text) {
            this.text = text;
        }

        int length() {
            return this.text.length();
        }

        public String toString() {
            return this.text;
        }
    }

    static final class WSTokenInfo
    extends TokenInfo {
        WSTokenInfo(char ws) {
            super(String.valueOf(ws));
        }

        public boolean equals(Object obj) {
            return obj instanceof WSTokenInfo && ((WSTokenInfo)obj).text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }
    }

    static final class PsiToken
    extends TokenInfo {
        final PsiElement psi;
        final TextRange rangeInPsi;
        final TextRange rangeInFile;
        final TokenKind kind;

        PsiToken(String text, PsiElement psi, TextRange rangeInPsi, TokenKind kind) {
            super(text);
            this.psi = psi;
            this.rangeInPsi = rangeInPsi;
            this.rangeInFile = rangeInPsi.shiftRight(psi.getTextRange().getStartOffset());
            this.kind = kind;
            assert (rangeInPsi.getLength() == text.length());
            assert (kind == TokenKind.text || rangeInPsi.getLength() == 0);
        }

        private int psiStart() {
            return this.rangeInFile.getStartOffset();
        }

        private PsiToken withRange(TextRange range) {
            assert (range.getLength() > 0);
            assert (this.kind == TokenKind.text);
            return new PsiToken(range.shiftLeft(this.rangeInPsi.getStartOffset()).substring(this.text), this.psi, range, this.kind);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiToken)) {
                return false;
            }
            PsiToken psiToken = (PsiToken)o;
            return this.kind == psiToken.kind && this.psi.equals(psiToken.psi) && (this.kind != TokenKind.text || this.rangeInPsi.equals((Object)psiToken.rangeInPsi));
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.psi, this.rangeInPsi, this.kind});
        }

        @Override
        public String toString() {
            return this.kind == TokenKind.markup ? "*" : (this.kind == TokenKind.unknown ? "?" : super.toString());
        }

        private List<PsiToken> splitToken(int tokenStart, List<TextContent.Exclusion> affecting) {
            int tokenEnd = tokenStart + this.length();
            if (affecting.size() == 1 && affecting.get((int)0).start < tokenStart && affecting.get((int)0).end > tokenEnd) {
                return Collections.emptyList();
            }
            ArrayList<PsiToken> shreds = new ArrayList<PsiToken>();
            int startInPsi = this.rangeInPsi.getStartOffset();
            int prevEnd = tokenStart;
            for (TextContent.Exclusion range : affecting) {
                if (range.start > prevEnd) {
                    shreds.add(this.withRange(TextRange.from((int)(startInPsi + prevEnd - tokenStart), (int)(range.start - prevEnd))));
                }
                if (range.kind != TextContent.ExclusionKind.exclude) {
                    TokenKind tokenKind = range.kind == TextContent.ExclusionKind.markup ? TokenKind.markup : TokenKind.unknown;
                    shreds.add(new PsiToken("", this.psi, TextRange.from((int)(startInPsi + range.start - tokenStart), (int)0), tokenKind));
                }
                prevEnd = range.end;
            }
            TextContent.Exclusion lastRange = affecting.get(affecting.size() - 1);
            if (tokenEnd > lastRange.end) {
                shreds.add(this.withRange(new TextRange(startInPsi + lastRange.end - tokenStart, startInPsi + this.length())));
            }
            return shreds;
        }
    }

    static enum TokenKind {
        text,
        markup,
        unknown;

    }
}

