/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleDependenciesContributor;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleMethodContextContributor;", "<init>", "()V", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "fromDependencyNotation", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "argumentIndex", "", "notation", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Companion", "intellij.gradle.java"})
public final class GradleDependenciesContributor
implements GradleMethodContextContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GroovyClosurePattern dependenciesClosure;
    @NotNull
    private static final GroovyClosurePattern dependencyAddClosure;
    @NotNull
    private static final GroovyClosurePattern dependencyClosure;
    @NotNull
    private static final GroovyClosurePattern moduleClosure;
    @NotNull
    private static final GroovyClosurePattern componentsClosure;
    @NotNull
    private static final GroovyClosurePattern modulesClosure;
    @NotNull
    private static final GroovyClosurePattern modulesModuleClosure;

    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure) {
        String string;
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        ProcessingContext context = new ProcessingContext();
        if (dependenciesClosure.accepts((Object)closure, context)) {
            PsiClassType psiClassType = TypesUtil.createType((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (PsiElement)((PsiElement)closure));
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
            PsiClassType dependencyHandler = psiClassType;
            GradleProjectAwareType gradleProjectAwareType = (GradleProjectAwareType)((Object)context.get(UtilKt.getProjectTypeKey()));
            PsiClassType delegate = gradleProjectAwareType != null && (gradleProjectAwareType = gradleProjectAwareType.setType(dependencyHandler)) != null ? (PsiClassType)gradleProjectAwareType : dependencyHandler;
            return new DelegatesToInfo((PsiType)delegate, 1);
        }
        if (dependencyAddClosure.accepts((Object)closure, context)) {
            string = this.fromDependencyNotation((GrCall)context.get(GroovyPatternsKt.getClosureCallKey()), 1);
            if (string == null) {
                string = "org.gradle.api.artifacts.ModuleDependency";
            }
        } else if (dependencyClosure.accepts((Object)closure, context)) {
            string = this.fromDependencyNotation((GrCall)context.get(GroovyPatternsKt.getClosureCallKey()), 0);
            if (string == null) {
                string = "org.gradle.api.artifacts.ModuleDependency";
            }
        } else if (moduleClosure.accepts((Object)closure)) {
            string = "org.gradle.api.artifacts.ClientModule";
        } else if (componentsClosure.accepts((Object)closure)) {
            string = "org.gradle.api.artifacts.dsl.ComponentMetadataHandler";
        } else if (modulesClosure.accepts((Object)closure)) {
            string = "org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler";
        } else if (modulesModuleClosure.accepts((Object)closure)) {
            string = "org.gradle.api.artifacts.ComponentModuleMetadataDetails";
        } else {
            return null;
        }
        String fqn = string;
        return new DelegatesToInfo((PsiType)TypesUtil.createType((String)fqn, (PsiElement)((PsiElement)closure)), 1);
    }

    private final String fromDependencyNotation(GrCall call, int argumentIndex) {
        if (call == null) {
            return null;
        }
        List list = ArgumentsKt.getArguments((GrCall)call);
        if (list == null) {
            return null;
        }
        List arguments = list;
        if (arguments.size() != argumentIndex + 2) {
            return null;
        }
        return this.fromDependencyNotation((Argument)arguments.get(argumentIndex));
    }

    private final String fromDependencyNotation(Argument notation) {
        PsiType psiType = notation.getType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType type = psiClassType;
        return InheritanceUtil.isInheritor((PsiType)((PsiType)type), (String)"java.lang.CharSequence") || InheritanceUtil.isInheritor((PsiType)((PsiType)type), (String)"java.util.Map") ? "org.gradle.api.artifacts.ExternalModuleDependency" : (InheritanceUtil.isInheritor((PsiType)((PsiType)type), (String)"org.gradle.api.Project") ? "org.gradle.api.artifacts.ProjectDependency" : (InheritanceUtil.isInheritor((PsiType)((PsiType)type), (String)"org.gradle.api.file.FileCollection") ? "org.gradle.api.artifacts.SelfResolvingDependency" : null));
    }

    static {
        GroovyClosurePattern groovyClosurePattern = GroovyPatternsKt.groovyClosure();
        ElementPattern[] elementPatternArray = new ElementPattern[3];
        String[] stringArray = new String[]{"dependencies"};
        elementPatternArray[0] = GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])stringArray);
        stringArray = new String[]{"dependencies"};
        elementPatternArray[1] = GroovyPatternsKt.psiMethod((String)"org.gradle.api.initialization.dsl.ScriptHandler", (String[])stringArray);
        stringArray = new String[]{"getDependencies"};
        elementPatternArray[2] = GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])stringArray);
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(...)");
        dependenciesClosure = groovyClosurePattern.inMethod(elementPattern).inMethodResult(UtilKt.getSaveProjectType());
        String[] stringArray2 = new String[]{"add"};
        dependencyAddClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])stringArray2));
        dependencyClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.withKind((PsiMethodPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])new String[0]), (Object)"gradle:dependencyMethod"));
        stringArray2 = new String[]{"module"};
        moduleClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])stringArray2));
        stringArray2 = new String[]{"components"};
        componentsClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])stringArray2));
        stringArray2 = new String[]{"modules"};
        modulesClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.DependencyHandler", (String[])stringArray2));
        stringArray2 = new String[]{"module"};
        modulesModuleClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler", (String[])stringArray2));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleDependenciesContributor$Companion;", "", "<init>", "()V", "dependenciesClosure", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "getDependenciesClosure", "()Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "dependencyAddClosure", "getDependencyAddClosure", "dependencyClosure", "getDependencyClosure", "moduleClosure", "getModuleClosure", "componentsClosure", "getComponentsClosure", "modulesClosure", "getModulesClosure", "modulesModuleClosure", "getModulesModuleClosure", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GroovyClosurePattern getDependenciesClosure() {
            return dependenciesClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDependencyAddClosure() {
            return dependencyAddClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDependencyClosure() {
            return dependencyClosure;
        }

        @NotNull
        public final GroovyClosurePattern getModuleClosure() {
            return moduleClosure;
        }

        @NotNull
        public final GroovyClosurePattern getComponentsClosure() {
            return componentsClosure;
        }

        @NotNull
        public final GroovyClosurePattern getModulesClosure() {
            return modulesClosure;
        }

        @NotNull
        public final GroovyClosurePattern getModulesModuleClosure() {
            return modulesModuleClosure;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

