/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;

@ApiStatus.Internal
public final class BuildOutputConsumerImpl
implements BuildOutputConsumer {
    private static final Logger LOG = Logger.getInstance(BuildOutputConsumerImpl.class);
    private final BuildTarget<?> myTarget;
    private final CompileContext myContext;
    private final FileGeneratedEvent fileGeneratedEvent;
    private final Collection<File> myOutputs;
    private final Set<String> myRegisteredSources = CollectionFactory.createFilePathSet();

    public BuildOutputConsumerImpl(BuildTarget<?> target, CompileContext context) {
        this.myTarget = target;
        this.myContext = context;
        this.fileGeneratedEvent = new FileGeneratedEvent(target);
        this.myOutputs = this.myTarget.getOutputRoots(context);
    }

    private void registerOutput(File output, boolean isDirectory, Collection<String> sourcePaths) throws IOException {
        String outputPath = FileUtilRt.toSystemIndependentName((String)output.getPath());
        for (File outputRoot : this.myOutputs) {
            String outputRootPath = FileUtilRt.toSystemIndependentName((String)outputRoot.getPath());
            String relativePath = FileUtilRt.getRelativePath((String)outputRootPath, (String)outputPath, (char)'/');
            if (relativePath == null || relativePath.startsWith("../")) continue;
            if (isDirectory) {
                this.addEventsRecursively(output, outputRootPath, relativePath);
                continue;
            }
            this.fileGeneratedEvent.add(outputRootPath, relativePath);
        }
        SourceToOutputMapping mapping = this.myContext.getProjectDescriptor().dataManager.getSourceToOutputMap(this.myTarget);
        for (String sourcePath : sourcePaths) {
            this.myRegisteredSources.add(FileUtilRt.toSystemIndependentName((String)sourcePath));
            mapping.appendOutput(sourcePath, outputPath);
        }
    }

    private void addEventsRecursively(File output, String outputRootPath, String relativePath) {
        File[] children = output.listFiles();
        if (children == null) {
            this.fileGeneratedEvent.add(outputRootPath, relativePath);
        } else {
            String prefix = relativePath.isEmpty() || relativePath.equals(".") ? "" : relativePath + "/";
            for (File child : children) {
                this.addEventsRecursively(child, outputRootPath, prefix + child.getName());
            }
        }
    }

    @Override
    public void registerOutputFile(@NotNull File outputFile, @NotNull Collection<String> sourcePaths) throws IOException {
        if (outputFile == null) {
            BuildOutputConsumerImpl.$$$reportNull$$$0(0);
        }
        if (sourcePaths == null) {
            BuildOutputConsumerImpl.$$$reportNull$$$0(1);
        }
        this.registerOutput(outputFile, false, sourcePaths);
    }

    @Override
    public void registerOutputDirectory(@NotNull File outputDir, @NotNull Collection<String> sourcePaths) throws IOException {
        if (outputDir == null) {
            BuildOutputConsumerImpl.$$$reportNull$$$0(2);
        }
        if (sourcePaths == null) {
            BuildOutputConsumerImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(!(this.myTarget instanceof ModuleBuildTarget) && !(this.myTarget instanceof ArtifactBuildTarget), (Object)("'registerOutputDirectory' method cannot be used for target " + String.valueOf(this.myTarget) + ", it will break incremental compilation"));
        this.registerOutput(outputDir, true, sourcePaths);
    }

    public int getNumberOfProcessedSources() {
        return this.myRegisteredSources.size();
    }

    public void fireFileGeneratedEvent() {
        if (!this.fileGeneratedEvent.isEmpty()) {
            this.myContext.processMessage(this.fileGeneratedEvent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/builders/impl/BuildOutputConsumerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOutputFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOutputDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

