/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaExecutable;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;

public class DefaultJavaParameter
extends AbstractBaseJavaEntity
implements JavaParameter {
    private String name;
    private JavaClass type;
    private JavaExecutable executable;
    private boolean varArgs;

    public DefaultJavaParameter(JavaClass type, String name) {
        this(type, name, false);
    }

    public DefaultJavaParameter(JavaClass type, String name, boolean varArgs) {
        this.name = name;
        this.type = type;
        this.varArgs = varArgs;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeParameter(this).toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    @Override
    public JavaClass getJavaClass() {
        return this.type;
    }

    @Override
    public JavaExecutable getExecutable() {
        return this.executable;
    }

    public void setExecutable(JavaExecutable executable) {
        this.executable = executable;
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.getExecutable().getDeclaringClass();
    }

    @Override
    public boolean isVarArgs() {
        return this.varArgs;
    }

    @Override
    public String getBinaryName() {
        return this.type.getBinaryName();
    }

    @Override
    public String getFullyQualifiedName() {
        return this.type.getFullyQualifiedName();
    }

    @Override
    public String getCanonicalName() {
        return this.type.getCanonicalName();
    }

    @Override
    public String getValue() {
        return this.type.getValue();
    }

    @Override
    public String getGenericCanonicalName() {
        return this.type.getGenericCanonicalName();
    }

    @Override
    public String getGenericFullyQualifiedName() {
        return this.type.getGenericFullyQualifiedName();
    }

    @Override
    public String getResolvedValue() {
        return DefaultJavaType.getResolvedValue(this.type, this.getExecutable().getTypeParameters());
    }

    @Override
    public String getResolvedFullyQualifiedName() {
        return DefaultJavaType.getResolvedFullyQualifiedName(this.type, this.getExecutable().getTypeParameters());
    }

    @Override
    public String getResolvedGenericValue() {
        return DefaultJavaType.getResolvedGenericValue(this.type, this.getExecutable().getTypeParameters());
    }

    @Override
    public String getResolvedGenericFullyQualifiedName() {
        return DefaultJavaType.getResolvedGenericFullyQualifiedName(this.type, this.getExecutable().getTypeParameters());
    }

    public int hashCode() {
        return 13 + (this.isVarArgs() ? 1 : 0) + this.getType().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaParameter)) {
            return false;
        }
        JavaParameter p = (JavaParameter)obj;
        return this.getType().equals(p.getType()) && this.isVarArgs() == p.isVarArgs();
    }

    public String toString() {
        return this.getResolvedValue() + " " + this.name;
    }

    @Override
    public String getGenericValue() {
        return this.type.getGenericValue();
    }

    @Override
    public String toGenericString() {
        return this.type.toGenericString();
    }
}

