/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.Navigatable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.quickfix.ChooseAnotherJdkQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenImportingSettingsQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0019\u0010\u000f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/project/WrongJdkVersion;", "Lcom/intellij/build/issue/BuildIssue;", "mavenVer", "", "expectedJdkVersion", "Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/projectRoots/JavaSdkVersion;)V", "getMavenVer", "()Ljava/lang/String;", "getExpectedJdkVersion", "()Lcom/intellij/openapi/projectRoots/JavaSdkVersion;", "title", "Lcom/intellij/build/events/BuildEventsNls$Title;", "getTitle", "description", "Lcom/intellij/build/events/BuildEventsNls$Description;", "getDescription", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
final class WrongJdkVersion
implements BuildIssue {
    @NotNull
    private final String mavenVer;
    @NotNull
    private final JavaSdkVersion expectedJdkVersion;
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    @NotNull
    private final List<BuildIssueQuickFix> quickFixes;

    public WrongJdkVersion(@NotNull String mavenVer, @NotNull JavaSdkVersion expectedJdkVersion) {
        Intrinsics.checkNotNullParameter((Object)mavenVer, (String)"mavenVer");
        Intrinsics.checkNotNullParameter((Object)expectedJdkVersion, (String)"expectedJdkVersion");
        this.mavenVer = mavenVer;
        this.expectedJdkVersion = expectedJdkVersion;
        String string = SyncBundle.message("maven.sync.jdk.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.title = string;
        Object[] objectArray = new Object[]{this.mavenVer, this.expectedJdkVersion.getDescription(), "choose_another_maven_jdk_quick_fix", "open_maven_importing_settings_quick_fix"};
        String string2 = SyncBundle.message("maven.sync.jdk.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.description = string2;
        Object[] objectArray2 = new BuildIssueQuickFix[]{new OpenMavenImportingSettingsQuickFix(), new ChooseAnotherJdkQuickFix()};
        this.quickFixes = CollectionsKt.listOf((Object[])objectArray2);
    }

    @NotNull
    public final String getMavenVer() {
        return this.mavenVer;
    }

    @NotNull
    public final JavaSdkVersion getExpectedJdkVersion() {
        return this.expectedJdkVersion;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        return this.quickFixes;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }
}

