/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.openapi.project.Project;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelPluginQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelPropertyQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.TargetLevelPluginQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.TargetLevelPropertyQuickFix;
import org.jetbrains.idea.maven.importing.MavenProjectModelModifier;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public final class LanguageLevelQuickFixFactory {
    @Nullable
    public static LanguageLevelQuickFix getInstance(@NotNull Project project, @NotNull MavenProject mavenProject) {
        if (project == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(0);
        }
        if (mavenProject == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(1);
        }
        return LanguageLevelQuickFixFactory.getInstance(project, mavenProject, false);
    }

    @Nullable
    public static LanguageLevelQuickFix getTargetInstance(@NotNull Project project, @NotNull MavenProject mavenProject) {
        if (project == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(2);
        }
        if (mavenProject == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(3);
        }
        return LanguageLevelQuickFixFactory.getInstance(project, mavenProject, true);
    }

    @Nullable
    private static LanguageLevelQuickFix getInstance(@NotNull Project project, @NotNull MavenProject mavenProject, boolean targetVersion) {
        FixHolder holder2;
        if (project == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(4);
        }
        if (mavenProject == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(5);
        }
        if ((holder2 = LanguageLevelQuickFixFactory.getFixHolder(project, mavenProject, targetVersion)) == null) {
            return null;
        }
        return holder2.toInstance();
    }

    @Nullable
    private static FixHolder getFixHolder(@NotNull Project project, @NotNull MavenProject mavenProject, boolean targetVersion) {
        MavenDomProjectModel model;
        if (project == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(6);
        }
        if (mavenProject == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(7);
        }
        if ((model = MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile())) == null) {
            return null;
        }
        if (LanguageLevelQuickFixFactory.containCompilerPluginSource(model)) {
            return new FixHolder(true, targetVersion, mavenProject, project);
        }
        if (LanguageLevelQuickFixFactory.containPropertySource(model)) {
            return new FixHolder(false, targetVersion, mavenProject, project);
        }
        if (mavenProject.getParentId() == null) {
            return new FixHolder(false, targetVersion, mavenProject, project);
        }
        model = MavenDomUtil.getMavenDomProjectModel(project, (mavenProject = LanguageLevelQuickFixFactory.getParentMavenProject(project, mavenProject)).getFile());
        if (model == null) {
            return null;
        }
        return LanguageLevelQuickFixFactory.containCompilerPluginSource(model) ? new FixHolder(true, targetVersion, mavenProject, project) : new FixHolder(false, targetVersion, mavenProject, project);
    }

    @NotNull
    private static MavenProject getParentMavenProject(@NotNull Project project, @NotNull MavenProject mavenProject) {
        if (project == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(8);
        }
        if (mavenProject == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(9);
        }
        MavenProject parentProject = mavenProject;
        while (parentProject.getParentId() != null) {
            parentProject = MavenProjectsManager.getInstance(project).findProject(parentProject.getParentId());
            if (parentProject != null) continue;
            MavenProject mavenProject2 = mavenProject;
            if (mavenProject2 == null) {
                LanguageLevelQuickFixFactory.$$$reportNull$$$0(10);
            }
            return mavenProject2;
        }
        MavenProject mavenProject3 = parentProject;
        if (mavenProject3 == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(11);
        }
        return mavenProject3;
    }

    private static boolean containCompilerPluginSource(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(12);
        }
        return Optional.ofNullable(MavenProjectModelModifier.findCompilerPlugin(model)).map(p -> p.getConfiguration()).map(c -> c.getXmlTag()).map(tag -> tag.findFirstSubTag("source") != null).orElse(false);
    }

    private static boolean containPropertySource(@NotNull MavenDomProjectModel model) {
        if (model == null) {
            LanguageLevelQuickFixFactory.$$$reportNull$$$0(13);
        }
        return Optional.ofNullable(model.getProperties().getXmlTag()).map(tag -> tag.findFirstSubTag("maven.compiler.source") != null).orElse(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFixFactory";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFixFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentMavenProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFixHolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentMavenProject";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containCompilerPluginSource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containPropertySource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }

    private static class FixHolder {
        final boolean isPlugin;
        final boolean isTarget;
        final MavenProject mavenProject;
        final Project project;

        private FixHolder(boolean plugin, boolean target, MavenProject mavenProject, Project project) {
            this.isPlugin = plugin;
            this.isTarget = target;
            this.mavenProject = mavenProject;
            this.project = project;
        }

        private LanguageLevelQuickFix toInstance() {
            if (this.isPlugin && this.isTarget) {
                return new TargetLevelPluginQuickFix(this.project, this.mavenProject);
            }
            if (!this.isPlugin && this.isTarget) {
                return new TargetLevelPropertyQuickFix(this.project, this.mavenProject);
            }
            if (this.isPlugin) {
                return new LanguageLevelPluginQuickFix(this.project, this.mavenProject);
            }
            return new LanguageLevelPropertyQuickFix(this.project, this.mavenProject);
        }
    }
}

