/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.field;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.assertj.swing.dependency.fest_reflect.exception.ReflectionError;
import org.assertj.swing.dependency.fest_reflect.field.DecoratedInvoker;
import org.assertj.swing.dependency.fest_reflect.field.decorator.PostDecorator;
import org.assertj.swing.dependency.fest_reflect.field.decorator.PreDecorator;
import org.assertj.swing.dependency.fest_reflect.reference.TypeRef;
import org.assertj.swing.dependency.fest_reflect.util.Accessibles;
import org.assertj.swing.dependency.fest_util.Arrays;
import org.assertj.swing.dependency.fest_util.Strings;

public final class Invoker<T> {
    private final Object target;
    private final Field field;
    private final boolean accessible;
    private final Class<?> expectedType;

    static <T> Invoker<T> newInvoker(String fieldName, TypeRef<T> expectedType, Object target) {
        return Invoker.createInvoker(fieldName, expectedType.rawType(), target);
    }

    static <T> Invoker<T> newInvoker(String fieldName, Class<T> expectedType, Object target) {
        return Invoker.createInvoker(fieldName, expectedType, target);
    }

    private static <T> Invoker<T> createInvoker(String fieldName, Class<?> expectedType, Object target) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        Field field = Invoker.lookupInClassHierarchy(fieldName, Invoker.typeOf(target));
        Invoker.verifyCorrectType(field, expectedType);
        return new Invoker<T>(target, field, expectedType);
    }

    private static Class<?> typeOf(Object target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        return target.getClass();
    }

    private static Field lookupInClassHierarchy(String fieldName, Class<?> declaringType) {
        Field field = null;
        for (Class<?> target = declaringType; target != null && (field = Invoker.field(fieldName, target)) == null; target = target.getSuperclass()) {
        }
        if (field != null) {
            return field;
        }
        throw new ReflectionError(Strings.concat("Unable to find field ", Strings.quote(fieldName), " in ", declaringType.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyCorrectType(Field field, Class<?> expectedType) {
        boolean isAccessible = field.isAccessible();
        try {
            Accessibles.makeAccessible(field);
            Class<?> actualType = field.getType();
            if (!expectedType.isAssignableFrom(actualType)) {
                throw Invoker.incorrectFieldType(field, actualType, expectedType);
            }
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(field, isAccessible);
        }
    }

    private Invoker(Object target, Field field, Class<?> expectedType) {
        this.target = target;
        this.field = field;
        this.expectedType = expectedType;
        this.accessible = field.isAccessible();
    }

    private static Field field(String fieldName, Class<?> declaringType) {
        try {
            return declaringType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static ReflectionError incorrectFieldType(Field field, Class<?> actual, Class<?> expected) {
        String fieldTypeName = field.getDeclaringClass().getName();
        String message = Strings.concat("The type of the field ", Strings.quote(field.getName()), " in ", fieldTypeName, " should be <", expected.getName(), "> but was <", actual.getName(), ">");
        throw new ReflectionError(message);
    }

    public void set(T value) {
        try {
            Accessibles.setAccessible(this.field, true);
            this.field.set(this.target, value);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat("Unable to update the value in field ", Strings.quote(this.field.getName())), e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.field, this.accessible);
        }
    }

    public DecoratedInvoker<T> preDecorateWith(T decorator) {
        T target = this.get();
        PreDecorator<T> handler = new PreDecorator<T>(target, decorator);
        Object field = Proxy.newProxyInstance(decorator.getClass().getClassLoader(), Arrays.array(this.expectedType), handler);
        this.set(field);
        return DecoratedInvoker.newInvoker(target, decorator, this.expectedType, this, handler);
    }

    public DecoratedInvoker<T> postDecorateWith(T decorator) {
        T target = this.get();
        PostDecorator<T> handler = new PostDecorator<T>(target, decorator);
        Object field = Proxy.newProxyInstance(decorator.getClass().getClassLoader(), Arrays.array(this.expectedType), handler);
        this.set(field);
        return DecoratedInvoker.newInvoker(target, decorator, this.expectedType, this, handler);
    }

    public T get() {
        return Invoker.get(this.field, this.accessible, this.target);
    }

    static Object getNestedField(String fieldName, Object target) {
        Field field = Invoker.lookupInClassHierarchy(fieldName, Invoker.typeOf(target));
        return Invoker.get(field, field.isAccessible(), target);
    }

    private static <T> T get(Field field, boolean accessible, Object target) {
        try {
            Accessibles.setAccessible(field, true);
            Object object = field.get(target);
            return (T)object;
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat("Unable to obtain the value in field " + Strings.quote(field.getName())), e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(field, accessible);
        }
    }

    public Field info() {
        return this.field;
    }
}

