/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import git4idea.config.DefaultExecutableProblemHandler;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVersion;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\r\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0010\u001a\u00020\u000b*\u00020\u0011H\u0000\u001a)\u0010\u0012\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u000b\u0010\u0013\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\r\u0010\u0014\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fH\u0000\u001a)\u0010\u0015\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u000b\u0010\u0013\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\r\u0010\u0014\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fH\u0000\u001a\u0017\u0010\u0016\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a8\u0006\u0019"}, d2={"findGitExecutableProblemHandler", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "showUnsupportedVersionError", "", "version", "Lgit4idea/config/GitVersion;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "unsupportedVersionMessage", "", "Lorg/jetbrains/annotations/Nls;", "unsupportedVersionDescription", "getLinkToConfigure", "Lgit4idea/config/ErrorNotifier$FixOption;", "dumpToString", "Lcom/intellij/execution/process/ProcessOutput;", "getErrorTitle", "text", "description", "getErrorMessage", "getHumanReadableErrorFor", "exception", "", "intellij.vcs.git"})
public final class GitExecutableProblemHandlersKt {
    @NotNull
    public static final GitExecutableProblemHandler findGitExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SystemInfo.isWindows ? (GitExecutableProblemHandler)new WindowsExecutableProblemHandler(project) : (SystemInfo.isMac ? (GitExecutableProblemHandler)new MacExecutableProblemHandler(project) : (GitExecutableProblemHandler)new DefaultExecutableProblemHandler(project));
    }

    public static final void showUnsupportedVersionError(@NotNull Project project, @NotNull GitVersion version, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        if (GitVersion.isUnsupportedWslVersion(version.getType())) {
            String string = GitBundle.message((String)"git.executable.validation.error.wsl.start.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errorNotifier.showError(string, GitBundle.message((String)"git.executable.validation.error.wsl1.unsupported.message", (Object[])new Object[0]), GitExecutableProblemHandlersKt.getLinkToConfigure(project));
        } else {
            errorNotifier.showError(GitExecutableProblemHandlersKt.unsupportedVersionMessage(version), GitExecutableProblemHandlersKt.unsupportedVersionDescription(), GitExecutableProblemHandlersKt.getLinkToConfigure(project));
        }
    }

    @NotNull
    public static final String unsupportedVersionMessage(@NotNull GitVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Object[] objectArray = new Object[]{version.getPresentation()};
        String string = GitBundle.message((String)"git.executable.validation.error.version.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public static final String unsupportedVersionDescription() {
        Object[] objectArray = new Object[]{GitVersion.MIN.getPresentation()};
        String string = GitBundle.message((String)"git.executable.validation.error.version.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public static final ErrorNotifier.FixOption getLinkToConfigure(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ErrorNotifier.FixOption.Configure(project);
    }

    @NotNull
    public static final String dumpToString(@NotNull ProcessOutput $this$dumpToString) {
        Intrinsics.checkNotNullParameter((Object)$this$dumpToString, (String)"<this>");
        return "output: " + $this$dumpToString.getStdout() + ", error output: " + $this$dumpToString.getStderr();
    }

    @NotNull
    public static final String getErrorTitle(@NotNull String text2, @Nullable String description) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (description == null) {
            String string2 = GitBundle.message((String)"git.executable.validation.error.start.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = text2;
        }
        return string;
    }

    @NotNull
    public static final String getErrorMessage(@NotNull String text2, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String string = description;
        if (string == null) {
            string = text2;
        }
        return string;
    }

    @Nullable
    public static final String getHumanReadableErrorFor(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof GitNotInstalledException) {
            return null;
        }
        return GitExecutableProblemsNotifier.getPrettyErrorMessage(exception);
    }
}

