/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.commands.GitShallowCloneOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\t2\b\b\u0001\u0010\u0010\u001a\u00020\tH\u0007J\"\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0001\u0010\u0013\u001a\u00020\tH\u0002J\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u0013\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/checkout/GitCloneUtils;", "", "<init>", "()V", "clone", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedUrl", "", "directoryPath", "shallowCloneOptions", "Lgit4idea/commands/GitShallowCloneOptions;", "checkoutListener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "unableToCreateDirectoryId", "unableToFindDirectoryId", "notifyCreateDirectoryFailed", "message", "displayId", "notifyDestinationNotFound", "intellij.vcs.git"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGitCloneUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCloneUtils.kt\ngit4idea/checkout/GitCloneUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n24#2:80\n24#2:81\n*S KotlinDebug\n*F\n+ 1 GitCloneUtils.kt\ngit4idea/checkout/GitCloneUtils\n*L\n63#1:80\n72#1:81\n*E\n"})
public final class GitCloneUtils {
    @NotNull
    public static final GitCloneUtils INSTANCE = new GitCloneUtils();

    private GitCloneUtils() {
    }

    @RequiresEdt
    public final void clone(@NotNull Project project, @NotNull String selectedUrl, @NotNull String directoryPath, @Nullable GitShallowCloneOptions shallowCloneOptions, @NotNull CheckoutProvider.Listener checkoutListener, @NlsContexts.NotificationTitle @NotNull String unableToCreateDirectoryId, @NlsContexts.NotificationTitle @NotNull String unableToFindDirectoryId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedUrl, (String)"selectedUrl");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)checkoutListener, (String)"checkoutListener");
        Intrinsics.checkNotNullParameter((Object)unableToCreateDirectoryId, (String)"unableToCreateDirectoryId");
        Intrinsics.checkNotNullParameter((Object)unableToFindDirectoryId, (String)"unableToFindDirectoryId");
        Path parent = Paths.get(directoryPath, new String[0]).toAbsolutePath().getParent();
        ValidationInfo destinationValidation = CloneDvcsValidationUtils.createDestination((String)((Object)parent).toString());
        if (destinationValidation != null) {
            String string = destinationValidation.message;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
            this.notifyCreateDirectoryFailed(project, string, unableToCreateDirectoryId);
            return;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        VirtualFile destinationParent = lfs.findFileByIoFile(parent.toFile());
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent.toFile());
        }
        if (destinationParent == null) {
            this.notifyDestinationNotFound(project, unableToFindDirectoryId);
            return;
        }
        String directoryName = ((Object)Paths.get(directoryPath, new String[0]).getFileName()).toString();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        GitCheckoutProvider.clone(project, Git.getInstance(), checkoutListener, destinationParent, selectedUrl, directoryName, parentDirectory, shallowCloneOptions);
    }

    private final void notifyCreateDirectoryFailed(Project project, String message, @NlsContexts.NotificationTitle String displayId) {
        GitCloneUtils $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitCloneUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        String[] stringArray = new String[]{message};
        logger.error(CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.create.destination.directory", (Object[])new Object[0]), stringArray);
        VcsNotifier.getInstance((Project)project).notifyError(displayId, CollaborationToolsBundle.message((String)"clone.dialog.clone.failed", (Object[])new Object[0]), CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.find.destination.directory", (Object[])new Object[0]));
    }

    private final void notifyDestinationNotFound(Project project, @NlsContexts.NotificationTitle String displayId) {
        GitCloneUtils $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitCloneUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error(CollaborationToolsBundle.message((String)"clone.dialog.error.destination.not.exist", (Object[])new Object[0]));
        VcsNotifier.getInstance((Project)project).notifyError(displayId, CollaborationToolsBundle.message((String)"clone.dialog.clone.failed", (Object[])new Object[0]), CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.find.destination.directory", (Object[])new Object[0]));
    }
}

