/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitCommit;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitRepositoryLocation;
import git4idea.changes.GitVersionFilterComponent;
import git4idea.commands.GitHandler;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitCommittedChangeListProvider
implements CommittedChangesProvider<CommittedChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(GitCommittedChangeListProvider.class);
    @NotNull
    private final Project myProject;

    public GitCommittedChangeListProvider(@NotNull Project project) {
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new GitVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath rootPath) {
        VirtualFile gitRoot;
        if (rootPath == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(1);
        }
        if ((gitRoot = rootPath.getVirtualFile()) == null) {
            return null;
        }
        GitRepository repository2 = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(gitRoot);
        if (repository2 == null) {
            LOG.info("No GitRepository for " + String.valueOf(gitRoot));
            return null;
        }
        GitLocalBranch currentBranch = repository2.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitRemoteBranch trackedBranch = currentBranch.findTrackedBranch(repository2);
        if (trackedBranch == null) {
            return null;
        }
        File rootFile = new File(gitRoot.getPath());
        return new GitRepositoryLocation(trackedBranch.getRemote().getFirstUrl(), rootFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull AsynchConsumer<? super CommittedChangeList> consumer) throws VcsException {
        if (settings == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(2);
        }
        if (location == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(4);
        }
        try {
            this.getCommittedChangesImpl(settings, location, maxCount, (Consumer<? super GitCommittedChangeList>)consumer);
        }
        finally {
            consumer.finished();
        }
    }

    @NotNull
    public List<CommittedChangeList> getCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount) throws VcsException {
        if (settings == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(5);
        }
        if (location == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(6);
        }
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        this.getCommittedChangesImpl(settings, location, maxCount, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> result2.add((CommittedChangeList)committedChangeList)));
        ArrayList<CommittedChangeList> arrayList = result2;
        if (arrayList == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void getCommittedChangesImpl(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, Consumer<? super GitCommittedChangeList> consumer) throws VcsException {
        if (settings == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(8);
        }
        if (location == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(9);
        }
        GitRepositoryLocation l = (GitRepositoryLocation)location;
        Long beforeRev = settings.getChangeBeforeFilter();
        Long afterRev = settings.getChangeAfterFilter();
        Date beforeDate = settings.getDateBeforeFilter();
        Date afterDate = settings.getDateAfterFilter();
        String author = settings.getUserFilter();
        VirtualFile root = LocalFileSystem.getInstance().findFileByIoFile(l.getRoot());
        if (root == null) {
            throw new VcsException(GitBundle.message((String)"error.git.repository.not.found", (Object[])new Object[]{l.getRoot()}));
        }
        GitUtil.getLocalCommittedChanges(this.myProject, root, (Consumer<? super GitHandler>)((Consumer)h -> {
            if (!StringUtil.isEmpty((String)author)) {
                h.addParameters("--author=" + author);
            }
            if (beforeDate != null) {
                h.addParameters("--before=" + GitUtil.gitTime(beforeDate));
            }
            if (afterDate != null) {
                h.addParameters("--after=" + GitUtil.gitTime(afterDate));
            }
            if (maxCount != this.getUnlimitedCountValue()) {
                h.addParameters("-n" + maxCount);
            }
            if (beforeRev != null && afterRev != null) {
                h.addParameters(GitUtil.formatLongRev(afterRev) + ".." + GitUtil.formatLongRev(beforeRev));
            } else if (beforeRev != null) {
                h.addParameters(GitUtil.formatLongRev(beforeRev));
            } else if (afterRev != null) {
                h.addParameters(GitUtil.formatLongRev(afterRev) + "..");
            }
        }), consumer, false);
    }

    public ChangeListColumn @NotNull [] getColumns() {
        ChangeListColumn[] changeListColumnArray = new ChangeListColumn[]{ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION, ChangeListColumn.NAME};
        if (changeListColumnArray == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(10);
        }
        return changeListColumnArray;
    }

    public int getUnlimitedCountValue() {
        return -1;
    }

    @Nullable
    public Pair<CommittedChangeList, FilePath> getOneList(@NotNull VirtualFile file, @NotNull VcsRevisionNumber number) throws VcsException {
        if (file == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(11);
        }
        if (number == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(12);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        if (!(number instanceof GitRevisionNumber)) {
            LOG.error("Unsupported revision number: " + String.valueOf(number));
            return null;
        }
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)filePath));
        if (repository2 == null) {
            return null;
        }
        VirtualFile root = repository2.getRoot();
        VcsFullCommitDetails gitCommit = GitCommittedChangeListProvider.getCommitDetails(this.myProject, root, number);
        if (gitCommit == null) {
            return null;
        }
        GitCommittedChangeList commit = GitCommittedChangeListProvider.createCommittedChangeList(this.myProject, gitCommit, (GitRevisionNumber)number);
        Collection changes = commit.getChanges();
        if (changes.size() == 1) {
            Change change = (Change)changes.iterator().next();
            return Pair.create((Object)((Object)commit), (Object)ChangesUtil.getFilePath((Change)change));
        }
        for (Change change : changes) {
            if (change.getAfterRevision() == null || !FileUtil.filesEqual((File)filePath.getIOFile(), (File)change.getAfterRevision().getFile().getIOFile())) continue;
            return Pair.create((Object)((Object)commit), (Object)filePath);
        }
        String afterTime = "--after=" + GitUtil.gitTime(new Date(gitCommit.getCommitTime()));
        List<VcsFileRevision> history = GitFileHistory.collectHistory(this.myProject, filePath, afterTime);
        if (history.isEmpty()) {
            return Pair.create((Object)((Object)commit), (Object)filePath);
        }
        return Pair.create((Object)((Object)commit), (Object)((GitFileRevision)history.get(history.size() - 1)).getPath());
    }

    @Nullable
    private static VcsFullCommitDetails getCommitDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsRevisionNumber number) throws VcsException {
        String[] hashParameters;
        List<GitCommit> gitCommits;
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(14);
        }
        if (number == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(15);
        }
        if ((gitCommits = GitHistoryUtils.history(project, root, hashParameters = GitHistoryUtils.formHashParameters(project, Collections.singleton(number.asString())))).size() != 1) {
            return null;
        }
        return (VcsFullCommitDetails)gitCommits.get(0);
    }

    @NotNull
    private static GitCommittedChangeList createCommittedChangeList(@NotNull Project project, @NotNull VcsFullCommitDetails gitCommit, @NotNull GitRevisionNumber revisionNumber) {
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(16);
        }
        if (gitCommit == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(17);
        }
        if (revisionNumber == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(18);
        }
        return new GitCommittedChangeList(gitCommit.getFullMessage() + " (" + ((Hash)gitCommit.getId()).toShortString() + ")", gitCommit.getFullMessage(), VcsUserUtil.toExactString((VcsUser)gitCommit.getAuthor()), revisionNumber, new Date(gitCommit.getAuthorTime()), gitCommit.getChanges(), GitVcs.getInstance(project), true);
    }

    @Nullable
    public static GitCommittedChangeList getCommittedChangeList(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitRevisionNumber revisionNumber) throws VcsException {
        VcsFullCommitDetails details;
        if (project == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(19);
        }
        if (root == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(20);
        }
        if (revisionNumber == null) {
            GitCommittedChangeListProvider.$$$reportNull$$$0(21);
        }
        if ((details = GitCommittedChangeListProvider.getCommitDetails(project, root, (VcsRevisionNumber)revisionNumber)) == null) {
            return null;
        }
        return GitCommittedChangeListProvider.createCommittedChangeList(project, details, revisionNumber);
    }

    public boolean supportsIncomingChanges() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/changes/GitCommittedChangeListProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitCommit";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/changes/GitCommittedChangeListProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadCommittedChanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChanges";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChangesImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOneList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCommitDetails";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChangeList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }
}

