/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import git4idea.GitBranch;
import git4idea.actions.branch.GitBranchActionsDataKeys;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\"\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0012"}, d2={"Lgit4idea/actions/branch/GitBranchActionsUtil;", "", "<init>", "()V", "calculateNewBranchInitialName", "", "Lcom/intellij/openapi/util/NlsSafe;", "branch", "Lgit4idea/GitBranch;", "branchName", "isRemote", "", "getRepositoriesForTopLevelActions", "", "Lgit4idea/repo/GitRepository;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getAffectedRepositories", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchActionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchActionsUtil.kt\ngit4idea/actions/branch/GitBranchActionsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class GitBranchActionsUtil {
    @NotNull
    public static final GitBranchActionsUtil INSTANCE = new GitBranchActionsUtil();

    private GitBranchActionsUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String calculateNewBranchInitialName(@NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return GitBranchActionsUtil.calculateNewBranchInitialName(branch.getName(), branch.isRemote());
    }

    @JvmStatic
    @NotNull
    public static final String calculateNewBranchInitialName(@NotNull String branchName, boolean isRemote) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        if (!(((CharSequence)branchName).length() > 0)) {
            boolean bl = false;
            String string = "Given branch name cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!isRemote) {
            return branchName;
        }
        char[] cArray = new char[]{'/'};
        List split = StringsKt.split$default((CharSequence)branchName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        return split.size() == 1 ? branchName : CollectionsKt.joinToString$default((Iterable)UtilKt.tail((List)split), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmStatic
    @NotNull
    public static final List<GitRepository> getRepositoriesForTopLevelActions(@NotNull AnActionEvent e) {
        GitRepository selectedRepository;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        if (!GitVcsSettings.getInstance((Project)project2).shouldExecuteOperationsOnAllRoots() && (selectedRepository = (GitRepository)e.getData(GitBranchActionsDataKeys.SELECTED_REPOSITORY)) != null) {
            return CollectionsKt.listOf((Object)selectedRepository);
        }
        return GitBranchActionsUtil.getAffectedRepositories(e);
    }

    @JvmStatic
    @NotNull
    public static final List<GitRepository> getAffectedRepositories(@NotNull AnActionEvent e) {
        List list;
        List list2;
        List repositoriesInContext;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        List list3 = (List)e.getData(GitBranchActionsDataKeys.AFFECTED_REPOSITORIES);
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        if (!((Collection)(repositoriesInContext = list3)).isEmpty()) {
            return repositoriesInContext;
        }
        List<GitRepository> list4 = GitRepositoryManager.getInstance(project2).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"getRepositories(...)");
        List<GitRepository> allRepositories = list4;
        if (allRepositories.size() == 1 || GitVcsSettings.getInstance((Project)project2).shouldExecuteOperationsOnAllRoots()) {
            return allRepositories;
        }
        GitRepository gitRepository = GitBranchUtil.guessRepositoryForOperation(project2, e.getDataContext());
        if (gitRepository != null) {
            GitRepository p0 = gitRepository;
            boolean bl = false;
            list2 = CollectionsKt.listOf((Object)p0);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

