/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClassedPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ComplexityCache {
    private final ComplexityVisitor complexityVisitor = new ComplexityVisitor();
    private final Map cache = new HashMap();

    ComplexityCache() {
    }

    public boolean isComplex(Pattern pattern) {
        return Complexity.isComplex(this.complexityVisitor.visit(pattern));
    }

    private class ComplexityVisitor
    extends AbstractVisitor {
        private ComplexityVisitor() {
        }

        Object visit(Pattern pattern) {
            Object object = ComplexityCache.this.cache.get(pattern);
            if (object == null) {
                object = pattern.accept(this);
                ComplexityCache.this.cache.put(pattern, object);
            }
            return object;
        }

        public Object visitGrammar(GrammarPattern grammarPattern) {
            return Complexity.VERY_COMPLICATED;
        }

        public Object visitNameClassed(NameClassedPattern nameClassedPattern) {
            return this.brace(nameClassedPattern);
        }

        public Object visitList(ListPattern listPattern) {
            return this.brace(listPattern);
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return this.brace(mixedPattern);
        }

        private Object brace(UnaryPattern unaryPattern) {
            return Complexity.brace(this.visit(unaryPattern.getChild()));
        }

        public Object visitUnary(UnaryPattern unaryPattern) {
            return this.visit(unaryPattern.getChild());
        }

        public Object visitData(DataPattern dataPattern) {
            Object object = Complexity.SIMPLE;
            if (dataPattern.getParams().size() > 0) {
                object = Complexity.brace(object);
            }
            if (dataPattern.getExcept() != null) {
                object = Complexity.max(object, this.visit(dataPattern.getExcept()));
            }
            return object;
        }

        public Object visitComposite(CompositePattern compositePattern) {
            Object object = Complexity.SIMPLE;
            Iterator iterator = compositePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                object = Complexity.max(object, this.visit((Pattern)iterator.next()));
            }
            return Complexity.paren(object);
        }

        public Object visitPattern(Pattern pattern) {
            return Complexity.SIMPLE;
        }
    }

    private static class Complexity {
        private static final int MAX_BRACE = 0;
        private static final int MAX_PAREN = 2;
        static final Object SIMPLE = new Integer(0);
        static final Object VERY_COMPLICATED = new Integer(1);

        private Complexity() {
        }

        static Object max(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n > 0) {
                return n > n2 ? object : object2;
            }
            if (n2 > 0) {
                return object2;
            }
            return n < n2 ? object : object2;
        }

        static Object brace(Object object) {
            int n = (Integer)object;
            return new Integer(n <= 0 ? 1 : n + 1);
        }

        static Object paren(Object object) {
            int n = (Integer)object;
            return new Integer(n > 0 ? n : n - 1);
        }

        static boolean isComplex(Object object) {
            int n = (Integer)object;
            return n > 0 || n < -2;
        }
    }
}

