/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.TextLevelRule;

public abstract class AbstractStatisticSentenceStyleRule
extends TextLevelRule {
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\"\u201c\u201e\u00bb\u00ab]");
    private static final Pattern ENDING_QUOTES = Pattern.compile("[\"\u201c\u201d\u00bb\u00ab]");
    private static final Pattern MARKS_REGEX = Pattern.compile("[,;.:?\u2022!-\u2013\u2014]");
    private static final boolean DEFAULT_ACTIVATION = false;
    private final int minPercent;
    private final int defaultMinPercent;
    private int sentenceCount = 0;
    private int numMatches = 0;
    private boolean withoutDirectSpeech = false;

    protected abstract AnalyzedTokenReadings conditionFulfilled(List<AnalyzedTokenReadings> var1);

    protected abstract boolean excludeDirectSpeech();

    protected abstract String getLimitMessage(int var1, double var2);

    public abstract String getConfigureText();

    public AbstractStatisticSentenceStyleRule(ResourceBundle messages, Language lang, UserConfig userConfig, int minPercent, boolean defaultActive) {
        super(messages);
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.defaultMinPercent = minPercent;
        this.minPercent = this.getMinPercent(userConfig, minPercent);
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    private int getMinPercent(UserConfig userConfig, int minPercentDefault) {
        Object[] cf;
        if (userConfig != null && (cf = userConfig.getConfigValueByID(this.getId())) != null) {
            return (Integer)cf[0];
        }
        return minPercentDefault;
    }

    protected boolean isMark(AnalyzedTokenReadings token) {
        return MARKS_REGEX.matcher(token.getToken()).matches();
    }

    protected boolean isOpeningQuote(AnalyzedTokenReadings token) {
        return OPENING_QUOTES.matcher(token.getToken()).matches();
    }

    public AbstractStatisticSentenceStyleRule(ResourceBundle messages, Language lang, UserConfig userConfig, int minPercent) {
        this(messages, lang, userConfig, minPercent, false);
    }

    public double denominator() {
        return 100.0;
    }

    @Override
    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption(this.defaultMinPercent, this.getConfigureText(), 0, 100)};
        return ruleOptions;
    }

    public int getSentenceCount() {
        return this.sentenceCount;
    }

    public int getNumberOfMatches() {
        return this.numMatches;
    }

    public void setWithoutDirectSpeech(boolean withoutDirectSpeech) {
        this.withoutDirectSpeech = withoutDirectSpeech;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        ArrayList<Integer> startPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<AnalyzedSentence> relevantSentences = new ArrayList<AnalyzedSentence>();
        int pos = 0;
        this.sentenceCount = 0;
        boolean excludeDirectSpeech = this.excludeDirectSpeech();
        boolean isDirectSpeech = false;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            ArrayList<AnalyzedTokenReadings> relevantSentencePart = new ArrayList<AnalyzedTokenReadings>();
            boolean isSentenceCount = false;
            AnalyzedTokenReadings foundToken = null;
            for (int n = 1; n < tokens.length; ++n) {
                AnalyzedTokenReadings token = tokens[n];
                String sToken = token.getToken();
                if (excludeDirectSpeech && !isDirectSpeech && OPENING_QUOTES.matcher(sToken).matches() && n < tokens.length - 1 && !tokens[n + 1].isWhitespaceBefore()) {
                    isDirectSpeech = true;
                    if (!relevantSentencePart.isEmpty()) {
                        isSentenceCount = true;
                        foundToken = this.conditionFulfilled(relevantSentencePart);
                        if (foundToken != null) {
                            break;
                        }
                    }
                } else if (excludeDirectSpeech && isDirectSpeech && ENDING_QUOTES.matcher(sToken).matches() && n > 1 && !tokens[n].isWhitespaceBefore()) {
                    isDirectSpeech = false;
                    relevantSentencePart = new ArrayList();
                } else if (!(isDirectSpeech && (this.minPercent != 0 || this.withoutDirectSpeech) || token.isWhitespace())) {
                    relevantSentencePart.add(token);
                }
                if (n != tokens.length - 1 || relevantSentencePart.isEmpty()) continue;
                isSentenceCount = true;
                foundToken = this.conditionFulfilled(relevantSentencePart);
            }
            if (isSentenceCount) {
                ++this.sentenceCount;
            }
            if (foundToken != null) {
                startPos.add(foundToken.getStartPos() + pos);
                endPos.add(foundToken.getEndPos() + pos);
                relevantSentences.add(sentence);
            }
            pos += sentence.getCorrectedTextLength();
        }
        this.numMatches = startPos.size();
        double percent = this.sentenceCount > 0 ? (double)this.numMatches * this.denominator() / (double)this.sentenceCount : 0.0;
        if (percent > (double)this.minPercent) {
            for (int i = 0; i < startPos.size(); ++i) {
                RuleMatch ruleMatch = new RuleMatch(this, (AnalyzedSentence)relevantSentences.get(i), (Integer)startPos.get(i), (Integer)endPos.get(i), this.getLimitMessage(this.minPercent, percent));
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }
}

