/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.tables;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.scientific.tables.ColumnTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0014H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0014H\u0002\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u00020\u0014H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0014*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0002\u001a\b\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0016\u0010\u000f\"\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006!"}, d2={"JSON_PAYLOAD_FIELD", "", "SERIALIZED_DATAFRAME_FIELD", "COLUMNS_FIELD", "TYPES_FIELD", "NUM_ROWS_FIELD", "NUM_COLS_FIELD", "VERSION_FIELD", "DATA_FIELD", "METADATA_FIELD", "COLUMN_KIND_FIELD", "VALUE_COLUMN", "COLUMN_GROUP", "FRAME_COLUMN", "FRAME_CONVERTABLE", "ColumnValues", "", "", "isFrame", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "isFrameLike", "isColumnGroup", "pathToColumnKind", "columnKind", "extractRawJson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "text", "getByPath", "path", "createRoot", "Lcom/intellij/scientific/tables/ColumnTreeNode;", "childrenNames", "intellij.kotlin.jupyter.tables"})
public final class KotlinDataframeParsingKt {
    @NotNull
    private static final String JSON_PAYLOAD_FIELD = "application/kotlindataframe+json";
    @NotNull
    private static final String SERIALIZED_DATAFRAME_FIELD = "kotlin_dataframe";
    @NotNull
    private static final String COLUMNS_FIELD = "columns";
    @NotNull
    private static final String TYPES_FIELD = "types";
    @NotNull
    private static final String NUM_ROWS_FIELD = "nrow";
    @NotNull
    private static final String NUM_COLS_FIELD = "ncol";
    @NotNull
    private static final String VERSION_FIELD = "$version";
    @NotNull
    private static final String DATA_FIELD = "data";
    @NotNull
    private static final String METADATA_FIELD = "metadata";
    @NotNull
    private static final String COLUMN_KIND_FIELD = "kind";
    @NotNull
    public static final String VALUE_COLUMN = "ValueColumn";
    @NotNull
    public static final String COLUMN_GROUP = "ColumnGroup";
    @NotNull
    public static final String FRAME_COLUMN = "FrameColumn";
    @NotNull
    public static final String FRAME_CONVERTABLE = "DataFrameConvertable";
    @NotNull
    private static final List<String> pathToColumnKind;

    private static final boolean isFrame(JsonNode $this$isFrame) {
        return Intrinsics.areEqual((Object)KotlinDataframeParsingKt.columnKind($this$isFrame), (Object)FRAME_COLUMN);
    }

    private static final boolean isFrameLike(JsonNode $this$isFrameLike) {
        return Intrinsics.areEqual((Object)KotlinDataframeParsingKt.columnKind($this$isFrameLike), (Object)FRAME_CONVERTABLE);
    }

    private static final boolean isColumnGroup(JsonNode $this$isColumnGroup) {
        return Intrinsics.areEqual((Object)KotlinDataframeParsingKt.columnKind($this$isColumnGroup), (Object)COLUMN_GROUP);
    }

    private static final String columnKind(JsonNode $this$columnKind) {
        JsonNode jsonNode = KotlinDataframeParsingKt.getByPath($this$columnKind, pathToColumnKind);
        return jsonNode != null ? jsonNode.asText() : null;
    }

    private static final JsonNode extractRawJson(ObjectMapper $this$extractRawJson, String text) {
        JsonNode data = $this$extractRawJson.readTree(text);
        JsonNode jsonNode = $this$extractRawJson.readTree(data.get(JSON_PAYLOAD_FIELD).asText());
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        return jsonNode;
    }

    private static final JsonNode getByPath(JsonNode $this$getByPath, List<String> path) {
        JsonNode result2 = $this$getByPath;
        for (String field : path) {
            if (result2.get(field) != null) continue;
            return null;
        }
        return result2;
    }

    private static final ColumnTreeNode createRoot() {
        return new ColumnTreeNode("root", -1, 0, (List)new ArrayList());
    }

    @NotNull
    public static final ColumnTreeNode createRoot(@NotNull List<String> childrenNames) {
        Intrinsics.checkNotNullParameter(childrenNames, (String)"childrenNames");
        ColumnTreeNode root = KotlinDataframeParsingKt.createRoot();
        Iterator iterator = ((Iterable)childrenNames).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String column = (String)iterator.next();
            root.getColumnChildren().add(new ColumnTreeNode(column, index, index, (List)new ArrayList()));
        }
        return root;
    }

    public static final /* synthetic */ boolean access$isColumnGroup(JsonNode $receiver) {
        return KotlinDataframeParsingKt.isColumnGroup($receiver);
    }

    public static final /* synthetic */ boolean access$isFrame(JsonNode $receiver) {
        return KotlinDataframeParsingKt.isFrame($receiver);
    }

    public static final /* synthetic */ boolean access$isFrameLike(JsonNode $receiver) {
        return KotlinDataframeParsingKt.isFrameLike($receiver);
    }

    public static final /* synthetic */ JsonNode access$extractRawJson(ObjectMapper $receiver, String text) {
        return KotlinDataframeParsingKt.extractRawJson($receiver, text);
    }

    public static final /* synthetic */ JsonNode access$getByPath(JsonNode $receiver, List path) {
        return KotlinDataframeParsingKt.getByPath($receiver, path);
    }

    public static final /* synthetic */ ColumnTreeNode access$createRoot() {
        return KotlinDataframeParsingKt.createRoot();
    }

    static {
        Object[] objectArray = new String[]{METADATA_FIELD, COLUMN_KIND_FIELD};
        pathToColumnKind = CollectionsKt.listOf((Object[])objectArray);
    }
}

