/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.settings;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeWithMe.ClientId;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptionsProvider;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\u0010\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookApplicationOptions;", "", "<init>", "()V", "options", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookApplicationOptionsProvider;", "getOptions", "()Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookApplicationOptionsProvider;", "refreshEditors", "", "foldInjected", "", "(Ljava/lang/Boolean;)V", "updateFoldRegions", "editor", "Lcom/intellij/openapi/editor/Editor;", "get", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookApplicationOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookApplicationOptions.kt\ncom/intellij/kotlin/jupyter/core/settings/KotlinNotebookApplicationOptions\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,55:1\n53#2:56\n40#2,3:57\n13472#3,2:60\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookApplicationOptions.kt\ncom/intellij/kotlin/jupyter/core/settings/KotlinNotebookApplicationOptions\n*L\n15#1:56\n16#1:57,3\n30#1:60,2\n*E\n"})
public final class KotlinNotebookApplicationOptions {
    @NotNull
    public static final KotlinNotebookApplicationOptions INSTANCE = new KotlinNotebookApplicationOptions();

    private KotlinNotebookApplicationOptions() {
    }

    private final synchronized KotlinNotebookApplicationOptionsProvider getOptions() {
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        KotlinNotebookApplicationOptionsProvider kotlinNotebookApplicationOptionsProvider = (KotlinNotebookApplicationOptionsProvider)(application != null ? application.getServiceIfCreated(KotlinNotebookApplicationOptionsProvider.class) : null);
        if (kotlinNotebookApplicationOptionsProvider == null) {
            boolean $i$f$service = false;
            Class<KotlinNotebookApplicationOptionsProvider> serviceClass$iv = KotlinNotebookApplicationOptionsProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Object object2 = object;
            KotlinNotebookApplicationOptionsProvider $this$_get_options__u24lambda_u240 = (KotlinNotebookApplicationOptionsProvider)object2;
            boolean bl = false;
            $this$_get_options__u24lambda_u240.addListener((EventListener)new KotlinNotebookApplicationOptionsProvider.Listener(){

                public void onShowExecutionCountChanged() {
                    KotlinNotebookApplicationOptions.refreshEditors$default(KotlinNotebookApplicationOptions.INSTANCE, null, 1, null);
                }

                public void onShowFoldings(boolean oldValue, boolean newValue) {
                    KotlinNotebookApplicationOptions.access$refreshEditors(KotlinNotebookApplicationOptions.INSTANCE, newValue);
                }
            }, $this$_get_options__u24lambda_u240);
            kotlinNotebookApplicationOptionsProvider = (KotlinNotebookApplicationOptionsProvider)object2;
        }
        return kotlinNotebookApplicationOptionsProvider;
    }

    private final void refreshEditors(Boolean foldInjected) {
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = editorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)editor);
            if (!IsKotlinNotebookKt.isKotlinNotebook(editor)) continue;
            if (foldInjected != null) {
                INSTANCE.updateFoldRegions(editor, foldInjected);
            }
            editor.getComponent().repaint();
        }
    }

    static /* synthetic */ void refreshEditors$default(KotlinNotebookApplicationOptions kotlinNotebookApplicationOptions, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        kotlinNotebookApplicationOptions.refreshEditors(bl);
    }

    private final void updateFoldRegions(Editor editor, boolean foldInjected) {
        Boolean oldValue = (Boolean)editor.getUserData(FoldingUpdate.INJECTED_CODE_FOLDING_ENABLED);
        if (Intrinsics.areEqual((Object)oldValue, (Object)foldInjected)) {
            return;
        }
        editor.putUserData(FoldingUpdate.INJECTED_CODE_FOLDING_ENABLED, (Object)foldInjected);
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Document document = editor.getDocument();
        DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
        if (documentEx == null) {
            return;
        }
        DocumentEx document2 = documentEx;
        document2.setModificationStamp(document2.getModificationStamp() + 1L);
        document2.getModificationStamp();
        CodeFoldingManager.getInstance((Project)project2).updateFoldRegions(editor);
    }

    @NotNull
    public final KotlinNotebookApplicationOptionsProvider get() {
        return this.getOptions();
    }

    public static final /* synthetic */ void access$refreshEditors(KotlinNotebookApplicationOptions $this, Boolean foldInjected) {
        $this.refreshEditors(foldInjected);
    }
}

