/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.LogLevel;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.AbstractLogger;
import org.slf4j.helpers.MessageFormatter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0014\u001a\u00020\u00132\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory;", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "<init>", "()V", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "setConsoleView", "(Lcom/intellij/execution/ui/ConsoleView;)V", "logLevel", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/LogLevel;", "getLogLevel", "()Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/LogLevel;", "setLogLevel", "(Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/LogLevel;)V", "loggerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/slf4j/Logger;", "getLogger", "clazz", "Ljava/lang/Class;", "category", "getLoggerInstance", "name", "EmbeddedKotlinKernelLogger", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nEmbeddedKotlinKernelLoggerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedKotlinKernelLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n72#2,2:135\n1#3:137\n*S KotlinDebug\n*F\n+ 1 EmbeddedKotlinKernelLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory\n*L\n43#1:135,2\n43#1:137\n*E\n"})
public final class EmbeddedKotlinKernelLoggerFactory
implements KernelLoggerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ConsoleView consoleView;
    @NotNull
    private LogLevel logLevel = LogLevel.DEBUG;
    @NotNull
    private final ConcurrentHashMap<String, Logger> loggerMap = new ConcurrentHashMap();
    @NotNull
    private static final String NEW_LINE;
    @NotNull
    private static final DateTimeFormatter TIMESTAMP_FORMATTER;

    @Nullable
    public final ConsoleView getConsoleView() {
        return this.consoleView;
    }

    public final void setConsoleView(@Nullable ConsoleView consoleView) {
        this.consoleView = consoleView;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        this.logLevel = logLevel;
    }

    @NotNull
    public Logger getLogger(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.getLoggerInstance(string);
    }

    @NotNull
    public Logger getLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return this.getLoggerInstance(category);
    }

    /*
     * WARNING - void declaration
     */
    private final Logger getLoggerInstance(String name) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.loggerMap;
        String key$iv = name;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Logger default$iv = (Logger)new EmbeddedKotlinKernelLogger(this, name);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (Logger)object;
    }

    static {
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        NEW_LINE = string;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        TIMESTAMP_FORMATTER = dateTimeFormatter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory$Companion;", "", "<init>", "()V", "NEW_LINE", "", "getNEW_LINE", "()Ljava/lang/String;", "TIMESTAMP_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getTIMESTAMP_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNEW_LINE() {
            return NEW_LINE;
        }

        @NotNull
        public final DateTimeFormatter getTIMESTAMP_FORMATTER() {
            return TIMESTAMP_FORMATTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0012\u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u0012\u0010\r\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0014JG\u0010\u0012\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u00142\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0018\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014\u00a2\u0006\u0002\u0010\u001bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory$EmbeddedKotlinKernelLogger;", "Lorg/slf4j/helpers/AbstractLogger;", "tag", "", "<init>", "(Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory;Ljava/lang/String;)V", "isTraceEnabled", "", "marker", "Lorg/slf4j/Marker;", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isLogLevelEnabled", "level", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/LogLevel;", "getFullyQualifiedCallerName", "handleNormalizedLoggingCall", "", "Lorg/slf4j/event/Level;", "messagePattern", "arguments", "", "", "throwable", "", "(Lorg/slf4j/event/Level;Lorg/slf4j/Marker;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Throwable;)V", "intellij.kotlin.jupyter.core"})
    public final class EmbeddedKotlinKernelLogger
    extends AbstractLogger {
        @Nullable
        private final String tag;
        final /* synthetic */ EmbeddedKotlinKernelLoggerFactory this$0;

        public EmbeddedKotlinKernelLogger(@Nullable EmbeddedKotlinKernelLoggerFactory this$0, String tag) {
            this.this$0 = this$0;
            this.tag = tag;
        }

        public /* synthetic */ EmbeddedKotlinKernelLogger(EmbeddedKotlinKernelLoggerFactory embeddedKotlinKernelLoggerFactory, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(embeddedKotlinKernelLoggerFactory, string);
        }

        public boolean isTraceEnabled() {
            return this.isLogLevelEnabled(LogLevel.TRACE);
        }

        public boolean isTraceEnabled(@Nullable Marker marker) {
            return this.isTraceEnabled();
        }

        public boolean isDebugEnabled() {
            return this.isLogLevelEnabled(LogLevel.DEBUG);
        }

        public boolean isDebugEnabled(@Nullable Marker marker) {
            return this.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.isLogLevelEnabled(LogLevel.INFO);
        }

        public boolean isInfoEnabled(@Nullable Marker marker) {
            return this.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.isLogLevelEnabled(LogLevel.WARN);
        }

        public boolean isWarnEnabled(@Nullable Marker marker) {
            return this.isWarnEnabled();
        }

        public boolean isErrorEnabled() {
            return this.isLogLevelEnabled(LogLevel.ERROR);
        }

        public boolean isErrorEnabled(@Nullable Marker marker) {
            return this.isErrorEnabled();
        }

        private final boolean isLogLevelEnabled(LogLevel level) {
            return this.this$0.getLogLevel().toInt() <= level.toInt();
        }

        @NotNull
        protected String getFullyQualifiedCallerName() {
            return "";
        }

        protected void handleNormalizedLoggingCall(@Nullable Level level, @Nullable Marker marker, @Nullable String messagePattern, @Nullable Object[] arguments, @Nullable Throwable throwable) {
            ConsoleView consoleView = this.this$0.getConsoleView();
            if (consoleView == null) {
                return;
            }
            ConsoleView console = consoleView;
            Level level2 = level;
            ConsoleViewContentType type = switch (level2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[level2.ordinal()]) {
                case 1 -> ConsoleViewContentType.ERROR_OUTPUT;
                case 2 -> ConsoleViewContentType.LOG_WARNING_OUTPUT;
                case 3 -> ConsoleViewContentType.LOG_INFO_OUTPUT;
                case 4 -> ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                case 5 -> ConsoleViewContentType.LOG_VERBOSE_OUTPUT;
                case -1 -> ConsoleViewContentType.NORMAL_OUTPUT;
                default -> throw new NoWhenBranchMatchedException();
            };
            String timestamp = Companion.getTIMESTAMP_FORMATTER().format(Instant.now());
            StringBuilder log = new StringBuilder(timestamp);
            log.append(' ');
            if (this.tag != null) {
                log.append(this.tag);
                log.append(' ');
            }
            if (marker != null) {
                log.append("[" + marker.getName() + "] ");
            }
            if (level != null) {
                log.append(level.name());
                log.append(' ');
            }
            if (messagePattern != null) {
                log.append(MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments));
            }
            if (throwable != null) {
                if (messagePattern != null) {
                    log.append(Companion.getNEW_LINE());
                }
                log.append(ExceptionsKt.stackTraceToString((Throwable)throwable));
            }
            if (!StringsKt.endsWith$default((CharSequence)log, (CharSequence)Companion.getNEW_LINE(), (boolean)false, (int)2, null)) {
                log.append(Companion.getNEW_LINE());
            }
            console.print(log.toString(), type);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Level.values().length];
                try {
                    nArray[Level.ERROR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.WARN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.DEBUG.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Level.TRACE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

