/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service.components;

import com.intellij.kotlin.jupyter.core.editor.highlighting.service.components.ErrorHighlightersProcessor;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.components.InjectedFilesDataProcessor;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u0015\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\f2\u0006\u0010\u001b\u001a\u00020\u001cJ=\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/J\u001f\u00100\u001a\u00020\u00132\b\u0010+\u001a\u0004\u0018\u00010\r2\b\b\u0002\u00101\u001a\u00020!\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u00065"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/HighlightingPassTokensProcessor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "errorHighlightersProcessor", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/ErrorHighlightersProcessor;", "injectedFilesDataProcessor", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/InjectedFilesDataProcessor;", "remainingIndexesToProcess", "", "", "getRemainingIndexesToProcess", "()Ljava/util/Set;", "finishedFiles", "getFinishedFiles", "passCreated", "", "targetIndexes", "cells", "", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "completeRangeInd", "(Ljava/util/Set;Ljava/util/List;Ljava/lang/Integer;)V", "getInjectionHost", "psiFile", "Lcom/intellij/psi/PsiFile;", "disposeErrorHighlighters", "cellInFocus", "(Ljava/lang/Integer;)V", "isFileTarget", "", "injectedFileProcessed", "getErrorHighlighters", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "determineCellIndexesLeftToHighlight", "", "queue", "topLevelFile", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "cellFocusIndex", "(Ljava/util/Set;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/ex/MarkupModelEx;Ljava/lang/Integer;)Ljava/util/Set;", "editorCreated", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearState", "onRestart", "(Ljava/lang/Integer;Z)V", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nHighlightingPassTokensProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingPassTokensProcessor.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/HighlightingPassTokensProcessor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,151:1\n536#2:152\n521#2,6:153\n72#3,2:159\n1#4:161\n13#5:162\n*S KotlinDebug\n*F\n+ 1 HighlightingPassTokensProcessor.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/HighlightingPassTokensProcessor\n*L\n67#1:152\n67#1:153,6\n140#1:159,2\n140#1:161\n35#1:162\n*E\n"})
public final class HighlightingPassTokensProcessor
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ErrorHighlightersProcessor errorHighlightersProcessor;
    @NotNull
    private final InjectedFilesDataProcessor injectedFilesDataProcessor;
    @NotNull
    private static final Logger LOG;

    public HighlightingPassTokensProcessor(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.errorHighlightersProcessor = new ErrorHighlightersProcessor(this, LOG);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"getInstance(...)");
        this.injectedFilesDataProcessor = new InjectedFilesDataProcessor(injectedLanguageManager, LOG, this);
    }

    @NotNull
    public final Set<Integer> getRemainingIndexesToProcess() {
        return SetsKt.minus(this.injectedFilesDataProcessor.getTargetIndexes(), (Iterable)this.getFinishedFiles());
    }

    @NotNull
    public final Set<Integer> getFinishedFiles() {
        Set<Integer> set = this.injectedFilesDataProcessor.getFinishedFilesIndexes();
        Set set2 = this.errorHighlightersProcessor.getFileIndexesToErrors().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
        return SetsKt.minus(set, (Iterable)set2);
    }

    public final void passCreated(@NotNull Set<Integer> targetIndexes, @Nullable List<? extends PsiLanguageInjectionHost> cells, @Nullable Integer completeRangeInd) {
        Intrinsics.checkNotNullParameter(targetIndexes, (String)"targetIndexes");
        this.injectedFilesDataProcessor.passCreated(targetIndexes, cells, completeRangeInd);
    }

    @Nullable
    public final PsiLanguageInjectionHost getInjectionHost(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        InjectedFilesDataProcessor.InjectedFileData injectedFileData = this.injectedFilesDataProcessor.getFileInjectionData(psiFile);
        return injectedFileData != null ? injectedFileData.getInjectionHost() : null;
    }

    /*
     * Unable to fully structure code
     */
    public final void disposeErrorHighlighters(@Nullable Integer cellInFocus) {
        $this$filter$iv = this.errorHighlightersProcessor.getFileIndexesToErrors();
        $i$f$filter = false;
        var5_4 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var8_7 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var8_7.hasNext()) {
            entry = element$iv$iv = var8_7.next();
            $i$a$-filter-HighlightingPassTokensProcessor$disposeErrorHighlighters$errorData$1 = false;
            if (!this.injectedFilesDataProcessor.getTargetIndexes().contains(entry.getKey()) || !(((Collection)entry.getValue()).isEmpty() == false)) ** GOTO lbl-1000
            v0 = cellInFocus;
            if (v0 == null || ((Number)entry.getKey()).intValue() != v0.intValue()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        errorData = destination$iv$iv;
        KotlinNotebookPluginScope.Companion.invokeOnEDT((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Map<Integer, ? extends Set<RangeHighlighter>>)errorData, null){
            int label;
            final /* synthetic */ Map<Integer, Set<RangeHighlighter>> $errorData;
            {
                this.$errorData = $errorData;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Map<Integer, Set<RangeHighlighter>> $this$forEach$iv = this.$errorData;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<Integer, Set<RangeHighlighter>>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<Integer, Set<RangeHighlighter>> element$iv;
                            Map.Entry<Integer, Set<RangeHighlighter>> entry = element$iv = iterator.next();
                            boolean bl = false;
                            Iterable $this$forEach$iv2 = entry.getValue();
                            boolean $i$f$forEach2 = false;
                            for (T element$iv2 : $this$forEach$iv2) {
                                RangeHighlighter highlighter = (RangeHighlighter)element$iv2;
                                boolean bl2 = false;
                                highlighter.dispose();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final boolean isFileTarget(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.injectedFilesDataProcessor.isFileTarget(psiFile);
    }

    public final void injectedFileProcessed(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.injectedFilesDataProcessor.finishedForFile(psiFile);
    }

    @NotNull
    public final Set<RangeHighlighter> getErrorHighlighters(@NotNull PsiFile psiFile) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ConcurrentHashMap<Integer, Set<RangeHighlighter>> errorHighlighters = this.errorHighlightersProcessor.getFileIndexesToErrors();
        InjectedFilesDataProcessor.InjectedFileData injectedFileData = this.injectedFilesDataProcessor.getFileInjectionData(psiFile);
        if (injectedFileData == null) {
            return SetsKt.emptySet();
        }
        int cellInd = injectedFileData.getNotebookCellIndex();
        if (this.isFileTarget(psiFile)) {
            errorHighlighters.putIfAbsent(cellInd, new LinkedHashSet());
        }
        if ((set = errorHighlighters.get(cellInd)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<Integer> determineCellIndexesLeftToHighlight(@Nullable Set<Integer> queue, @Nullable PsiFile topLevelFile, @NotNull MarkupModelEx markupModel, @Nullable Integer cellFocusIndex) {
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        CollectionsKt.addIfNotNull((Collection)this.injectedFilesDataProcessor.getFinishedFilesIndexes(), (Object)cellFocusIndex);
        Set<Integer> finishedFilesIndexes = this.injectedFilesDataProcessor.getFinishedFilesIndexes();
        Set remaining = kotlin.collections.CollectionsKt.toMutableSet((Iterable)this.getRemainingIndexesToProcess());
        TypeIntrinsics.asMutableCollection((Object)remaining).remove(cellFocusIndex);
        this.errorHighlightersProcessor.determineFilesWithLeftErrors(markupModel, finishedFilesIndexes, cellFocusIndex);
        this.injectedFilesDataProcessor.determineFilesLeftToHighlight(markupModel, remaining);
        this.injectedFilesDataProcessor.processUnrecognizedFiles(topLevelFile, queue);
        return remaining;
    }

    public final void editorCreated(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.errorHighlightersProcessor.addMarkupListener(editor);
    }

    /*
     * WARNING - void declaration
     */
    public final void clearState(@Nullable Integer cellFocusIndex, boolean onRestart) {
        this.injectedFilesDataProcessor.clear();
        if (onRestart) {
            this.errorHighlightersProcessor.clear();
        } else {
            Set<RangeHighlighter> highlighters = this.errorHighlightersProcessor.getTargetErrorHighlighters();
            if (cellFocusIndex != null) {
                Set focusCellHighlighters;
                void $this$getOrPut$iv;
                ConcurrentMap concurrentMap = this.errorHighlightersProcessor.getFileIndexesToErrors();
                Integer key$iv = cellFocusIndex;
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(key$iv);
                if (object == null) {
                    boolean bl = false;
                    Set default$iv = new LinkedHashSet();
                    boolean bl2 = false;
                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                Set set = focusCellHighlighters = (Set)object;
                if (set != null) {
                    set.addAll((Collection)highlighters);
                }
            }
            highlighters.clear();
        }
    }

    public static /* synthetic */ void clearState$default(HighlightingPassTokensProcessor highlightingPassTokensProcessor, Integer n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        highlightingPassTokensProcessor.clearState(n, bl);
    }

    public void dispose() {
        this.clearState(null, true);
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/HighlightingPassTokensProcessor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

