/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.codeInsight.metaLanguage;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorsProvider;
import org.jetbrains.kotlinx.jupyter.magics.AbstractCompletionMagicsProcessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/codeInsight/metaLanguage/KotlinNotebookMagicsCompleter;", "Lorg/jetbrains/kotlinx/jupyter/magics/AbstractCompletionMagicsProcessor;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "descriptorsProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorsProvider;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorsProvider;)V", "key", "", "variant", "text", "icon", "getHttpResponseText", "url", "process", "", "metaStatement", "cursor", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookMagicsCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookMagicsCompleter.kt\ncom/intellij/kotlin/jupyter/core/editor/codeInsight/metaLanguage/KotlinNotebookMagicsCompleter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n14#2:55\n1573#3:56\n1604#3,4:57\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookMagicsCompleter.kt\ncom/intellij/kotlin/jupyter/core/editor/codeInsight/metaLanguage/KotlinNotebookMagicsCompleter\n*L\n29#1:55\n38#1:56\n38#1:57,4\n*E\n"})
public final class KotlinNotebookMagicsCompleter
extends AbstractCompletionMagicsProcessor<LookupElement> {
    public KotlinNotebookMagicsCompleter(@NotNull LibraryDescriptorsProvider descriptorsProvider) {
        Intrinsics.checkNotNullParameter((Object)descriptorsProvider, (String)"descriptorsProvider");
        super(descriptorsProvider, false, 2, null);
    }

    @NotNull
    protected String key(@NotNull LookupElement variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        String string = variant.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        return string;
    }

    @NotNull
    protected LookupElement variant(@NotNull String text, @NotNull String icon) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)text).withTypeText(icon);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withTypeText(...)");
        return (LookupElement)lookupElementBuilder;
    }

    @Nullable
    protected String getHttpResponseText(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = HttpRequests.request((String)url).readString();
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KotlinNotebookMagicsCompleter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Magic completion request failed", (Throwable)e);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull String metaStatement, int cursor, @NotNull CompletionResultSet result2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)metaStatement, (String)"metaStatement");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (((CharSequence)metaStatement).length() == 0 || metaStatement.charAt(0) != '%') {
            return;
        }
        AbstractCompletionMagicsProcessor.Handler handler = new AbstractCompletionMagicsProcessor.Handler((AbstractCompletionMagicsProcessor)this);
        String string = metaStatement.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        handler.handle(string, cursor > 0 ? cursor - 1 : cursor);
        Iterable $this$mapIndexed$iv = handler.getCompletions();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i2;
            String lookupString;
            void lookupElement;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LookupElement lookupElement2 = (LookupElement)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement.getLookupString(), (String)"getLookupString(...)");
            double priority = ((CharSequence)lookupString).length() == 0 ? -1.7976931348623157E308 : (Character.isDigit(lookupString.charAt(0)) ? -((double)i2) : (Character.isLetter(lookupString.charAt(0)) ? 10.0 : 0.0));
            collection.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority));
        }
        List prioritizedLookup = (List)destination$iv$iv;
        result2.addAllElements((Iterable)prioritizedLookup);
    }
}

